package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocatePublicContactPoints invokes the cassandra.AllocatePublicContactPoints API synchronously
func (client *Client) AllocatePublicContactPoints(request *AllocatePublicContactPointsRequest) (response *AllocatePublicContactPointsResponse, err error) {
	response = CreateAllocatePublicContactPointsResponse()
	err = client.DoAction(request, response)
	return
}

// AllocatePublicContactPointsWithChan invokes the cassandra.AllocatePublicContactPoints API asynchronously
func (client *Client) AllocatePublicContactPointsWithChan(request *AllocatePublicContactPointsRequest) (<-chan *AllocatePublicContactPointsResponse, <-chan error) {
	responseChan := make(chan *AllocatePublicContactPointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocatePublicContactPoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocatePublicContactPointsWithCallback invokes the cassandra.AllocatePublicContactPoints API asynchronously
func (client *Client) AllocatePublicContactPointsWithCallback(request *AllocatePublicContactPointsRequest, callback func(response *AllocatePublicContactPointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocatePublicContactPointsResponse
		var err error
		defer close(result)
		response, err = client.AllocatePublicContactPoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocatePublicContactPointsRequest is the request struct for api AllocatePublicContactPoints
type AllocatePublicContactPointsRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	DataCenterId string `position:"Query" name:"DataCenterId"`
	ClusterId    string `position:"Query" name:"ClusterId"`
}

// AllocatePublicContactPointsResponse is the response struct for api AllocatePublicContactPoints
type AllocatePublicContactPointsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocatePublicContactPointsRequest creates a request to invoke AllocatePublicContactPoints API
func CreateAllocatePublicContactPointsRequest() (request *AllocatePublicContactPointsRequest) {
	request = &AllocatePublicContactPointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "AllocatePublicContactPoints", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAllocatePublicContactPointsResponse creates a response to parse from AllocatePublicContactPoints response
func CreateAllocatePublicContactPointsResponse() (response *AllocatePublicContactPointsResponse) {
	response = &AllocatePublicContactPointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
