package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouterEcrAttachment invokes the cbn.CreateTransitRouterEcrAttachment API synchronously
func (client *Client) CreateTransitRouterEcrAttachment(request *CreateTransitRouterEcrAttachmentRequest) (response *CreateTransitRouterEcrAttachmentResponse, err error) {
	response = CreateCreateTransitRouterEcrAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterEcrAttachmentWithChan invokes the cbn.CreateTransitRouterEcrAttachment API asynchronously
func (client *Client) CreateTransitRouterEcrAttachmentWithChan(request *CreateTransitRouterEcrAttachmentRequest) (<-chan *CreateTransitRouterEcrAttachmentResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterEcrAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouterEcrAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterEcrAttachmentWithCallback invokes the cbn.CreateTransitRouterEcrAttachment API asynchronously
func (client *Client) CreateTransitRouterEcrAttachmentWithCallback(request *CreateTransitRouterEcrAttachmentRequest, callback func(response *CreateTransitRouterEcrAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterEcrAttachmentResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouterEcrAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterEcrAttachmentRequest is the request struct for api CreateTransitRouterEcrAttachment
type CreateTransitRouterEcrAttachmentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer                       `position:"Query" name:"ResourceOwnerId"`
	ClientToken                        string                                 `position:"Query" name:"ClientToken"`
	CenId                              string                                 `position:"Query" name:"CenId"`
	RouteTableAssociationEnabled       requests.Boolean                       `position:"Query" name:"RouteTableAssociationEnabled"`
	TransitRouterAttachmentName        string                                 `position:"Query" name:"TransitRouterAttachmentName"`
	FastLink                           requests.Boolean                       `position:"Query" name:"FastLink"`
	EcrId                              string                                 `position:"Query" name:"EcrId"`
	Tag                                *[]CreateTransitRouterEcrAttachmentTag `position:"Query" name:"Tag"  type:"Repeated"`
	AutoPublishRouteEnabled            requests.Boolean                       `position:"Query" name:"AutoPublishRouteEnabled"`
	RouteTablePropagationEnabled       requests.Boolean                       `position:"Query" name:"RouteTablePropagationEnabled"`
	EcrOwnerId                         requests.Integer                       `position:"Query" name:"EcrOwnerId"`
	DryRun                             requests.Boolean                       `position:"Query" name:"DryRun"`
	ResourceOwnerAccount               string                                 `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                       string                                 `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer                       `position:"Query" name:"OwnerId"`
	TransitRouterId                    string                                 `position:"Query" name:"TransitRouterId"`
	ResourceType                       string                                 `position:"Query" name:"ResourceType"`
	Version                            string                                 `position:"Query" name:"Version"`
	TransitRouterAttachmentDescription string                                 `position:"Query" name:"TransitRouterAttachmentDescription"`
}

// CreateTransitRouterEcrAttachmentTag is a repeated param struct in CreateTransitRouterEcrAttachmentRequest
type CreateTransitRouterEcrAttachmentTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateTransitRouterEcrAttachmentResponse is the response struct for api CreateTransitRouterEcrAttachment
type CreateTransitRouterEcrAttachmentResponse struct {
	*responses.BaseResponse
	TransitRouterAttachmentId string `json:"TransitRouterAttachmentId" xml:"TransitRouterAttachmentId"`
	RequestId                 string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTransitRouterEcrAttachmentRequest creates a request to invoke CreateTransitRouterEcrAttachment API
func CreateCreateTransitRouterEcrAttachmentRequest() (request *CreateTransitRouterEcrAttachmentRequest) {
	request = &CreateTransitRouterEcrAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouterEcrAttachment", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterEcrAttachmentResponse creates a response to parse from CreateTransitRouterEcrAttachment response
func CreateCreateTransitRouterEcrAttachmentResponse() (response *CreateTransitRouterEcrAttachmentResponse) {
	response = &CreateTransitRouterEcrAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
