package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartConference invokes the ccc.StartConference API synchronously
func (client *Client) StartConference(request *StartConferenceRequest) (response *StartConferenceResponse, err error) {
	response = CreateStartConferenceResponse()
	err = client.DoAction(request, response)
	return
}

// StartConferenceWithChan invokes the ccc.StartConference API asynchronously
func (client *Client) StartConferenceWithChan(request *StartConferenceRequest) (<-chan *StartConferenceResponse, <-chan error) {
	responseChan := make(chan *StartConferenceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartConference(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartConferenceWithCallback invokes the ccc.StartConference API asynchronously
func (client *Client) StartConferenceWithCallback(request *StartConferenceRequest, callback func(response *StartConferenceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartConferenceResponse
		var err error
		defer close(result)
		response, err = client.StartConference(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartConferenceRequest is the request struct for api StartConference
type StartConferenceRequest struct {
	*requests.RpcRequest
	UserId              string           `position:"Query" name:"UserId"`
	Tags                string           `position:"Query" name:"Tags"`
	TimeoutSeconds      requests.Integer `position:"Query" name:"TimeoutSeconds"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
	ParticipantListJson string           `position:"Query" name:"ParticipantListJson"`
}

// StartConferenceResponse is the response struct for api StartConference
type StartConferenceResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateStartConferenceRequest creates a request to invoke StartConference API
func CreateStartConferenceRequest() (request *StartConferenceRequest) {
	request = &StartConferenceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "StartConference", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartConferenceResponse creates a response to parse from StartConference response
func CreateStartConferenceResponse() (response *StartConferenceResponse) {
	response = &StartConferenceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
