package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCompanyTemplateView invokes the cloudesl.UpdateCompanyTemplateView API synchronously
func (client *Client) UpdateCompanyTemplateView(request *UpdateCompanyTemplateViewRequest) (response *UpdateCompanyTemplateViewResponse, err error) {
	response = CreateUpdateCompanyTemplateViewResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCompanyTemplateViewWithChan invokes the cloudesl.UpdateCompanyTemplateView API asynchronously
func (client *Client) UpdateCompanyTemplateViewWithChan(request *UpdateCompanyTemplateViewRequest) (<-chan *UpdateCompanyTemplateViewResponse, <-chan error) {
	responseChan := make(chan *UpdateCompanyTemplateViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCompanyTemplateView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCompanyTemplateViewWithCallback invokes the cloudesl.UpdateCompanyTemplateView API asynchronously
func (client *Client) UpdateCompanyTemplateViewWithCallback(request *UpdateCompanyTemplateViewRequest, callback func(response *UpdateCompanyTemplateViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCompanyTemplateViewResponse
		var err error
		defer close(result)
		response, err = client.UpdateCompanyTemplateView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCompanyTemplateViewRequest is the request struct for api UpdateCompanyTemplateView
type UpdateCompanyTemplateViewRequest struct {
	*requests.RpcRequest
	ExtraParams string `position:"Body" name:"ExtraParams"`
	Data        string `position:"Body" name:"Data"`
}

// UpdateCompanyTemplateViewResponse is the response struct for api UpdateCompanyTemplateView
type UpdateCompanyTemplateViewResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateUpdateCompanyTemplateViewRequest creates a request to invoke UpdateCompanyTemplateView API
func CreateUpdateCompanyTemplateViewRequest() (request *UpdateCompanyTemplateViewRequest) {
	request = &UpdateCompanyTemplateViewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "UpdateCompanyTemplateView", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCompanyTemplateViewResponse creates a response to parse from UpdateCompanyTemplateView response
func CreateUpdateCompanyTemplateViewResponse() (response *UpdateCompanyTemplateViewResponse) {
	response = &UpdateCompanyTemplateViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
