package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteHybridMonitorTask invokes the cms.DeleteHybridMonitorTask API synchronously
func (client *Client) DeleteHybridMonitorTask(request *DeleteHybridMonitorTaskRequest) (response *DeleteHybridMonitorTaskResponse, err error) {
	response = CreateDeleteHybridMonitorTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteHybridMonitorTaskWithChan invokes the cms.DeleteHybridMonitorTask API asynchronously
func (client *Client) DeleteHybridMonitorTaskWithChan(request *DeleteHybridMonitorTaskRequest) (<-chan *DeleteHybridMonitorTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteHybridMonitorTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteHybridMonitorTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteHybridMonitorTaskWithCallback invokes the cms.DeleteHybridMonitorTask API asynchronously
func (client *Client) DeleteHybridMonitorTaskWithCallback(request *DeleteHybridMonitorTaskRequest, callback func(response *DeleteHybridMonitorTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteHybridMonitorTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteHybridMonitorTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteHybridMonitorTaskRequest is the request struct for api DeleteHybridMonitorTask
type DeleteHybridMonitorTaskRequest struct {
	*requests.RpcRequest
	TargetUserId string `position:"Query" name:"TargetUserId"`
	Namespace    string `position:"Query" name:"Namespace"`
	TaskId       string `position:"Query" name:"TaskId"`
}

// DeleteHybridMonitorTaskResponse is the response struct for api DeleteHybridMonitorTask
type DeleteHybridMonitorTaskResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDeleteHybridMonitorTaskRequest creates a request to invoke DeleteHybridMonitorTask API
func CreateDeleteHybridMonitorTaskRequest() (request *DeleteHybridMonitorTaskRequest) {
	request = &DeleteHybridMonitorTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteHybridMonitorTask", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteHybridMonitorTaskResponse creates a response to parse from DeleteHybridMonitorTask response
func CreateDeleteHybridMonitorTaskResponse() (response *DeleteHybridMonitorTaskResponse) {
	response = &DeleteHybridMonitorTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
