package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigDeliveryChannel invokes the config.GetConfigDeliveryChannel API synchronously
func (client *Client) GetConfigDeliveryChannel(request *GetConfigDeliveryChannelRequest) (response *GetConfigDeliveryChannelResponse, err error) {
	response = CreateGetConfigDeliveryChannelResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigDeliveryChannelWithChan invokes the config.GetConfigDeliveryChannel API asynchronously
func (client *Client) GetConfigDeliveryChannelWithChan(request *GetConfigDeliveryChannelRequest) (<-chan *GetConfigDeliveryChannelResponse, <-chan error) {
	responseChan := make(chan *GetConfigDeliveryChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigDeliveryChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigDeliveryChannelWithCallback invokes the config.GetConfigDeliveryChannel API asynchronously
func (client *Client) GetConfigDeliveryChannelWithCallback(request *GetConfigDeliveryChannelRequest, callback func(response *GetConfigDeliveryChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigDeliveryChannelResponse
		var err error
		defer close(result)
		response, err = client.GetConfigDeliveryChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigDeliveryChannelRequest is the request struct for api GetConfigDeliveryChannel
type GetConfigDeliveryChannelRequest struct {
	*requests.RpcRequest
	DeliveryChannelId string `position:"Query" name:"DeliveryChannelId"`
}

// GetConfigDeliveryChannelResponse is the response struct for api GetConfigDeliveryChannel
type GetConfigDeliveryChannelResponse struct {
	*responses.BaseResponse
	RequestId       string                                    `json:"RequestId" xml:"RequestId"`
	DeliveryChannel DeliveryChannelInGetConfigDeliveryChannel `json:"DeliveryChannel" xml:"DeliveryChannel"`
}

// CreateGetConfigDeliveryChannelRequest creates a request to invoke GetConfigDeliveryChannel API
func CreateGetConfigDeliveryChannelRequest() (request *GetConfigDeliveryChannelRequest) {
	request = &GetConfigDeliveryChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetConfigDeliveryChannel", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConfigDeliveryChannelResponse creates a response to parse from GetConfigDeliveryChannel response
func CreateGetConfigDeliveryChannelResponse() (response *GetConfigDeliveryChannelResponse) {
	response = &GetConfigDeliveryChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
