package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBootAndAntiUninstallPolicy invokes the csas.GetBootAndAntiUninstallPolicy API synchronously
func (client *Client) GetBootAndAntiUninstallPolicy(request *GetBootAndAntiUninstallPolicyRequest) (response *GetBootAndAntiUninstallPolicyResponse, err error) {
	response = CreateGetBootAndAntiUninstallPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetBootAndAntiUninstallPolicyWithChan invokes the csas.GetBootAndAntiUninstallPolicy API asynchronously
func (client *Client) GetBootAndAntiUninstallPolicyWithChan(request *GetBootAndAntiUninstallPolicyRequest) (<-chan *GetBootAndAntiUninstallPolicyResponse, <-chan error) {
	responseChan := make(chan *GetBootAndAntiUninstallPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBootAndAntiUninstallPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBootAndAntiUninstallPolicyWithCallback invokes the csas.GetBootAndAntiUninstallPolicy API asynchronously
func (client *Client) GetBootAndAntiUninstallPolicyWithCallback(request *GetBootAndAntiUninstallPolicyRequest, callback func(response *GetBootAndAntiUninstallPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBootAndAntiUninstallPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetBootAndAntiUninstallPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBootAndAntiUninstallPolicyRequest is the request struct for api GetBootAndAntiUninstallPolicy
type GetBootAndAntiUninstallPolicyRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// GetBootAndAntiUninstallPolicyResponse is the response struct for api GetBootAndAntiUninstallPolicy
type GetBootAndAntiUninstallPolicyResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Strategy  Strategy `json:"Strategy" xml:"Strategy"`
}

// CreateGetBootAndAntiUninstallPolicyRequest creates a request to invoke GetBootAndAntiUninstallPolicy API
func CreateGetBootAndAntiUninstallPolicyRequest() (request *GetBootAndAntiUninstallPolicyRequest) {
	request = &GetBootAndAntiUninstallPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetBootAndAntiUninstallPolicy", "", "")
	request.Method = requests.GET
	return
}

// CreateGetBootAndAntiUninstallPolicyResponse creates a response to parse from GetBootAndAntiUninstallPolicy response
func CreateGetBootAndAntiUninstallPolicyResponse() (response *GetBootAndAntiUninstallPolicyResponse) {
	response = &GetBootAndAntiUninstallPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
