package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgUserGroupQueryList invokes the dataworks_public.DsgUserGroupQueryList API synchronously
func (client *Client) DsgUserGroupQueryList(request *DsgUserGroupQueryListRequest) (response *DsgUserGroupQueryListResponse, err error) {
	response = CreateDsgUserGroupQueryListResponse()
	err = client.DoAction(request, response)
	return
}

// DsgUserGroupQueryListWithChan invokes the dataworks_public.DsgUserGroupQueryList API asynchronously
func (client *Client) DsgUserGroupQueryListWithChan(request *DsgUserGroupQueryListRequest) (<-chan *DsgUserGroupQueryListResponse, <-chan error) {
	responseChan := make(chan *DsgUserGroupQueryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgUserGroupQueryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgUserGroupQueryListWithCallback invokes the dataworks_public.DsgUserGroupQueryList API asynchronously
func (client *Client) DsgUserGroupQueryListWithCallback(request *DsgUserGroupQueryListRequest, callback func(response *DsgUserGroupQueryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgUserGroupQueryListResponse
		var err error
		defer close(result)
		response, err = client.DsgUserGroupQueryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgUserGroupQueryListRequest is the request struct for api DsgUserGroupQueryList
type DsgUserGroupQueryListRequest struct {
	*requests.RpcRequest
	Owner       string           `position:"Query" name:"Owner"`
	ProjectName string           `position:"Query" name:"ProjectName"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Name        string           `position:"Query" name:"Name"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
}

// DsgUserGroupQueryListResponse is the response struct for api DsgUserGroupQueryList
type DsgUserGroupQueryListResponse struct {
	*responses.BaseResponse
	Success        bool     `json:"Success" xml:"Success"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string   `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	PageData       PageData `json:"PageData" xml:"PageData"`
}

// CreateDsgUserGroupQueryListRequest creates a request to invoke DsgUserGroupQueryList API
func CreateDsgUserGroupQueryListRequest() (request *DsgUserGroupQueryListRequest) {
	request = &DsgUserGroupQueryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgUserGroupQueryList", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgUserGroupQueryListResponse creates a response to parse from DsgUserGroupQueryList response
func CreateDsgUserGroupQueryListResponse() (response *DsgUserGroupQueryListResponse) {
	response = &DsgUserGroupQueryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
