package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOptionValueForProject invokes the dataworks_public.GetOptionValueForProject API synchronously
func (client *Client) GetOptionValueForProject(request *GetOptionValueForProjectRequest) (response *GetOptionValueForProjectResponse, err error) {
	response = CreateGetOptionValueForProjectResponse()
	err = client.DoAction(request, response)
	return
}

// GetOptionValueForProjectWithChan invokes the dataworks_public.GetOptionValueForProject API asynchronously
func (client *Client) GetOptionValueForProjectWithChan(request *GetOptionValueForProjectRequest) (<-chan *GetOptionValueForProjectResponse, <-chan error) {
	responseChan := make(chan *GetOptionValueForProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOptionValueForProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOptionValueForProjectWithCallback invokes the dataworks_public.GetOptionValueForProject API asynchronously
func (client *Client) GetOptionValueForProjectWithCallback(request *GetOptionValueForProjectRequest, callback func(response *GetOptionValueForProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOptionValueForProjectResponse
		var err error
		defer close(result)
		response, err = client.GetOptionValueForProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOptionValueForProjectRequest is the request struct for api GetOptionValueForProject
type GetOptionValueForProjectRequest struct {
	*requests.RpcRequest
	ExtensionCode string `position:"Body" name:"ExtensionCode"`
	ProjectId     string `position:"Body" name:"ProjectId"`
}

// GetOptionValueForProjectResponse is the response struct for api GetOptionValueForProject
type GetOptionValueForProjectResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	OptionValue string `json:"OptionValue" xml:"OptionValue"`
}

// CreateGetOptionValueForProjectRequest creates a request to invoke GetOptionValueForProject API
func CreateGetOptionValueForProjectRequest() (request *GetOptionValueForProjectRequest) {
	request = &GetOptionValueForProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetOptionValueForProject", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOptionValueForProjectResponse creates a response to parse from GetOptionValueForProject response
func CreateGetOptionValueForProjectResponse() (response *GetOptionValueForProjectResponse) {
	response = &GetOptionValueForProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
