package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunSmokeTest invokes the dataworks_public.RunSmokeTest API synchronously
func (client *Client) RunSmokeTest(request *RunSmokeTestRequest) (response *RunSmokeTestResponse, err error) {
	response = CreateRunSmokeTestResponse()
	err = client.DoAction(request, response)
	return
}

// RunSmokeTestWithChan invokes the dataworks_public.RunSmokeTest API asynchronously
func (client *Client) RunSmokeTestWithChan(request *RunSmokeTestRequest) (<-chan *RunSmokeTestResponse, <-chan error) {
	responseChan := make(chan *RunSmokeTestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunSmokeTest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunSmokeTestWithCallback invokes the dataworks_public.RunSmokeTest API asynchronously
func (client *Client) RunSmokeTestWithCallback(request *RunSmokeTestRequest, callback func(response *RunSmokeTestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunSmokeTestResponse
		var err error
		defer close(result)
		response, err = client.RunSmokeTest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunSmokeTestRequest is the request struct for api RunSmokeTest
type RunSmokeTestRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	Bizdate    string           `position:"Body" name:"Bizdate"`
	Name       string           `position:"Body" name:"Name"`
	NodeParams string           `position:"Body" name:"NodeParams"`
	NodeId     requests.Integer `position:"Body" name:"NodeId"`
}

// RunSmokeTestResponse is the response struct for api RunSmokeTest
type RunSmokeTestResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           int64  `json:"Data" xml:"Data"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateRunSmokeTestRequest creates a request to invoke RunSmokeTest API
func CreateRunSmokeTestRequest() (request *RunSmokeTestRequest) {
	request = &RunSmokeTestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "RunSmokeTest", "", "")
	request.Method = requests.POST
	return
}

// CreateRunSmokeTestResponse creates a response to parse from RunSmokeTest response
func CreateRunSmokeTestResponse() (response *RunSmokeTestResponse) {
	response = &RunSmokeTestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
