package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMetaCategory invokes the dataworks_public.UpdateMetaCategory API synchronously
func (client *Client) UpdateMetaCategory(request *UpdateMetaCategoryRequest) (response *UpdateMetaCategoryResponse, err error) {
	response = CreateUpdateMetaCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMetaCategoryWithChan invokes the dataworks_public.UpdateMetaCategory API asynchronously
func (client *Client) UpdateMetaCategoryWithChan(request *UpdateMetaCategoryRequest) (<-chan *UpdateMetaCategoryResponse, <-chan error) {
	responseChan := make(chan *UpdateMetaCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMetaCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMetaCategoryWithCallback invokes the dataworks_public.UpdateMetaCategory API asynchronously
func (client *Client) UpdateMetaCategoryWithCallback(request *UpdateMetaCategoryRequest, callback func(response *UpdateMetaCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMetaCategoryResponse
		var err error
		defer close(result)
		response, err = client.UpdateMetaCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMetaCategoryRequest is the request struct for api UpdateMetaCategory
type UpdateMetaCategoryRequest struct {
	*requests.RpcRequest
	Name       string           `position:"Body" name:"Name"`
	Comment    string           `position:"Body" name:"Comment"`
	CategoryId requests.Integer `position:"Body" name:"CategoryId"`
}

// UpdateMetaCategoryResponse is the response struct for api UpdateMetaCategory
type UpdateMetaCategoryResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateMetaCategoryRequest creates a request to invoke UpdateMetaCategory API
func CreateUpdateMetaCategoryRequest() (request *UpdateMetaCategoryRequest) {
	request = &UpdateMetaCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateMetaCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateMetaCategoryResponse creates a response to parse from UpdateMetaCategory response
func CreateUpdateMetaCategoryResponse() (response *UpdateMetaCategoryResponse) {
	response = &UpdateMetaCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
