package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRoutineCodeRevision invokes the dcdn.DeleteRoutineCodeRevision API synchronously
func (client *Client) DeleteRoutineCodeRevision(request *DeleteRoutineCodeRevisionRequest) (response *DeleteRoutineCodeRevisionResponse, err error) {
	response = CreateDeleteRoutineCodeRevisionResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRoutineCodeRevisionWithChan invokes the dcdn.DeleteRoutineCodeRevision API asynchronously
func (client *Client) DeleteRoutineCodeRevisionWithChan(request *DeleteRoutineCodeRevisionRequest) (<-chan *DeleteRoutineCodeRevisionResponse, <-chan error) {
	responseChan := make(chan *DeleteRoutineCodeRevisionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRoutineCodeRevision(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRoutineCodeRevisionWithCallback invokes the dcdn.DeleteRoutineCodeRevision API asynchronously
func (client *Client) DeleteRoutineCodeRevisionWithCallback(request *DeleteRoutineCodeRevisionRequest, callback func(response *DeleteRoutineCodeRevisionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRoutineCodeRevisionResponse
		var err error
		defer close(result)
		response, err = client.DeleteRoutineCodeRevision(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRoutineCodeRevisionRequest is the request struct for api DeleteRoutineCodeRevision
type DeleteRoutineCodeRevisionRequest struct {
	*requests.RpcRequest
	Name               string `position:"Body" name:"Name"`
	SelectCodeRevision string `position:"Body" name:"SelectCodeRevision"`
}

// DeleteRoutineCodeRevisionResponse is the response struct for api DeleteRoutineCodeRevision
type DeleteRoutineCodeRevisionResponse struct {
	*responses.BaseResponse
	Content   map[string]interface{} `json:"Content" xml:"Content"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRoutineCodeRevisionRequest creates a request to invoke DeleteRoutineCodeRevision API
func CreateDeleteRoutineCodeRevisionRequest() (request *DeleteRoutineCodeRevisionRequest) {
	request = &DeleteRoutineCodeRevisionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteRoutineCodeRevision", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRoutineCodeRevisionResponse creates a response to parse from DeleteRoutineCodeRevision response
func CreateDeleteRoutineCodeRevisionResponse() (response *DeleteRoutineCodeRevisionResponse) {
	response = &DeleteRoutineCodeRevisionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
