package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePort invokes the ddoscoo.CreatePort API synchronously
func (client *Client) CreatePort(request *CreatePortRequest) (response *CreatePortResponse, err error) {
	response = CreateCreatePortResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePortWithChan invokes the ddoscoo.CreatePort API asynchronously
func (client *Client) CreatePortWithChan(request *CreatePortRequest) (<-chan *CreatePortResponse, <-chan error) {
	responseChan := make(chan *CreatePortResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePort(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePortWithCallback invokes the ddoscoo.CreatePort API asynchronously
func (client *Client) CreatePortWithCallback(request *CreatePortRequest, callback func(response *CreatePortResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePortResponse
		var err error
		defer close(result)
		response, err = client.CreatePort(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePortRequest is the request struct for api CreatePort
type CreatePortRequest struct {
	*requests.RpcRequest
	SourceIp         string    `position:"Query" name:"SourceIp"`
	BackendPort      string    `position:"Query" name:"BackendPort"`
	FrontendProtocol string    `position:"Query" name:"FrontendProtocol"`
	InstanceId       string    `position:"Query" name:"InstanceId"`
	RealServers      *[]string `position:"Query" name:"RealServers"  type:"Repeated"`
	FrontendPort     string    `position:"Query" name:"FrontendPort"`
}

// CreatePortResponse is the response struct for api CreatePort
type CreatePortResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreatePortRequest creates a request to invoke CreatePort API
func CreateCreatePortRequest() (request *CreatePortRequest) {
	request = &CreatePortRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "CreatePort", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePortResponse creates a response to parse from CreatePort response
func CreateCreatePortResponse() (response *CreatePortResponse) {
	response = &CreatePortResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
