package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MakeTaskFlowInstanceSuccess invokes the dms_enterprise.MakeTaskFlowInstanceSuccess API synchronously
func (client *Client) MakeTaskFlowInstanceSuccess(request *MakeTaskFlowInstanceSuccessRequest) (response *MakeTaskFlowInstanceSuccessResponse, err error) {
	response = CreateMakeTaskFlowInstanceSuccessResponse()
	err = client.DoAction(request, response)
	return
}

// MakeTaskFlowInstanceSuccessWithChan invokes the dms_enterprise.MakeTaskFlowInstanceSuccess API asynchronously
func (client *Client) MakeTaskFlowInstanceSuccessWithChan(request *MakeTaskFlowInstanceSuccessRequest) (<-chan *MakeTaskFlowInstanceSuccessResponse, <-chan error) {
	responseChan := make(chan *MakeTaskFlowInstanceSuccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MakeTaskFlowInstanceSuccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MakeTaskFlowInstanceSuccessWithCallback invokes the dms_enterprise.MakeTaskFlowInstanceSuccess API asynchronously
func (client *Client) MakeTaskFlowInstanceSuccessWithCallback(request *MakeTaskFlowInstanceSuccessRequest, callback func(response *MakeTaskFlowInstanceSuccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MakeTaskFlowInstanceSuccessResponse
		var err error
		defer close(result)
		response, err = client.MakeTaskFlowInstanceSuccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MakeTaskFlowInstanceSuccessRequest is the request struct for api MakeTaskFlowInstanceSuccess
type MakeTaskFlowInstanceSuccessRequest struct {
	*requests.RpcRequest
	DagId         requests.Integer `position:"Query" name:"DagId"`
	Tid           requests.Integer `position:"Query" name:"Tid"`
	DagInstanceId requests.Integer `position:"Query" name:"DagInstanceId"`
}

// MakeTaskFlowInstanceSuccessResponse is the response struct for api MakeTaskFlowInstanceSuccess
type MakeTaskFlowInstanceSuccessResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateMakeTaskFlowInstanceSuccessRequest creates a request to invoke MakeTaskFlowInstanceSuccess API
func CreateMakeTaskFlowInstanceSuccessRequest() (request *MakeTaskFlowInstanceSuccessRequest) {
	request = &MakeTaskFlowInstanceSuccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "MakeTaskFlowInstanceSuccess", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMakeTaskFlowInstanceSuccessResponse creates a response to parse from MakeTaskFlowInstanceSuccess response
func CreateMakeTaskFlowInstanceSuccessResponse() (response *MakeTaskFlowInstanceSuccessResponse) {
	response = &MakeTaskFlowInstanceSuccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
