package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAndBindNasFileSystem invokes the ecd.CreateAndBindNasFileSystem API synchronously
func (client *Client) CreateAndBindNasFileSystem(request *CreateAndBindNasFileSystemRequest) (response *CreateAndBindNasFileSystemResponse, err error) {
	response = CreateCreateAndBindNasFileSystemResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAndBindNasFileSystemWithChan invokes the ecd.CreateAndBindNasFileSystem API asynchronously
func (client *Client) CreateAndBindNasFileSystemWithChan(request *CreateAndBindNasFileSystemRequest) (<-chan *CreateAndBindNasFileSystemResponse, <-chan error) {
	responseChan := make(chan *CreateAndBindNasFileSystemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAndBindNasFileSystem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAndBindNasFileSystemWithCallback invokes the ecd.CreateAndBindNasFileSystem API asynchronously
func (client *Client) CreateAndBindNasFileSystemWithCallback(request *CreateAndBindNasFileSystemRequest, callback func(response *CreateAndBindNasFileSystemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAndBindNasFileSystemResponse
		var err error
		defer close(result)
		response, err = client.CreateAndBindNasFileSystem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAndBindNasFileSystemRequest is the request struct for api CreateAndBindNasFileSystem
type CreateAndBindNasFileSystemRequest struct {
	*requests.RpcRequest
	OfficeSiteId   string           `position:"Query" name:"OfficeSiteId"`
	EndUserIds     *[]string        `position:"Query" name:"EndUserIds"  type:"Repeated"`
	Description    string           `position:"Query" name:"Description"`
	StorageType    string           `position:"Query" name:"StorageType"`
	EncryptType    requests.Integer `position:"Query" name:"EncryptType"`
	DesktopGroupId string           `position:"Query" name:"DesktopGroupId"`
	FileSystemName string           `position:"Query" name:"FileSystemName"`
}

// CreateAndBindNasFileSystemResponse is the response struct for api CreateAndBindNasFileSystem
type CreateAndBindNasFileSystemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateAndBindNasFileSystemRequest creates a request to invoke CreateAndBindNasFileSystem API
func CreateCreateAndBindNasFileSystemRequest() (request *CreateAndBindNasFileSystemRequest) {
	request = &CreateAndBindNasFileSystemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateAndBindNasFileSystem", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAndBindNasFileSystemResponse creates a response to parse from CreateAndBindNasFileSystem response
func CreateCreateAndBindNasFileSystemResponse() (response *CreateAndBindNasFileSystemResponse) {
	response = &CreateAndBindNasFileSystemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
