package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePriceForCreateDesktopOversoldGroup invokes the ecd.DescribePriceForCreateDesktopOversoldGroup API synchronously
func (client *Client) DescribePriceForCreateDesktopOversoldGroup(request *DescribePriceForCreateDesktopOversoldGroupRequest) (response *DescribePriceForCreateDesktopOversoldGroupResponse, err error) {
	response = CreateDescribePriceForCreateDesktopOversoldGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePriceForCreateDesktopOversoldGroupWithChan invokes the ecd.DescribePriceForCreateDesktopOversoldGroup API asynchronously
func (client *Client) DescribePriceForCreateDesktopOversoldGroupWithChan(request *DescribePriceForCreateDesktopOversoldGroupRequest) (<-chan *DescribePriceForCreateDesktopOversoldGroupResponse, <-chan error) {
	responseChan := make(chan *DescribePriceForCreateDesktopOversoldGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePriceForCreateDesktopOversoldGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePriceForCreateDesktopOversoldGroupWithCallback invokes the ecd.DescribePriceForCreateDesktopOversoldGroup API asynchronously
func (client *Client) DescribePriceForCreateDesktopOversoldGroupWithCallback(request *DescribePriceForCreateDesktopOversoldGroupRequest, callback func(response *DescribePriceForCreateDesktopOversoldGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePriceForCreateDesktopOversoldGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribePriceForCreateDesktopOversoldGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePriceForCreateDesktopOversoldGroupRequest is the request struct for api DescribePriceForCreateDesktopOversoldGroup
type DescribePriceForCreateDesktopOversoldGroupRequest struct {
	*requests.RpcRequest
	Period            requests.Integer `position:"Query" name:"Period"`
	OversoldUserCount requests.Integer `position:"Query" name:"OversoldUserCount"`
	PeriodUnit        string           `position:"Query" name:"PeriodUnit"`
	DataDiskSize      requests.Integer `position:"Query" name:"DataDiskSize"`
	SystemDiskSize    requests.Integer `position:"Query" name:"SystemDiskSize"`
	ConcurrenceCount  requests.Integer `position:"Query" name:"ConcurrenceCount"`
	DesktopType       string           `position:"Query" name:"DesktopType"`
}

// DescribePriceForCreateDesktopOversoldGroupResponse is the response struct for api DescribePriceForCreateDesktopOversoldGroup
type DescribePriceForCreateDesktopOversoldGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribePriceForCreateDesktopOversoldGroupRequest creates a request to invoke DescribePriceForCreateDesktopOversoldGroup API
func CreateDescribePriceForCreateDesktopOversoldGroupRequest() (request *DescribePriceForCreateDesktopOversoldGroupRequest) {
	request = &DescribePriceForCreateDesktopOversoldGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribePriceForCreateDesktopOversoldGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePriceForCreateDesktopOversoldGroupResponse creates a response to parse from DescribePriceForCreateDesktopOversoldGroup response
func CreateDescribePriceForCreateDesktopOversoldGroupResponse() (response *DescribePriceForCreateDesktopOversoldGroupResponse) {
	response = &DescribePriceForCreateDesktopOversoldGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
