package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyEntitlement invokes the ecd.ModifyEntitlement API synchronously
func (client *Client) ModifyEntitlement(request *ModifyEntitlementRequest) (response *ModifyEntitlementResponse, err error) {
	response = CreateModifyEntitlementResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyEntitlementWithChan invokes the ecd.ModifyEntitlement API asynchronously
func (client *Client) ModifyEntitlementWithChan(request *ModifyEntitlementRequest) (<-chan *ModifyEntitlementResponse, <-chan error) {
	responseChan := make(chan *ModifyEntitlementResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyEntitlement(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyEntitlementWithCallback invokes the ecd.ModifyEntitlement API asynchronously
func (client *Client) ModifyEntitlementWithCallback(request *ModifyEntitlementRequest, callback func(response *ModifyEntitlementResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyEntitlementResponse
		var err error
		defer close(result)
		response, err = client.ModifyEntitlement(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyEntitlementRequest is the request struct for api ModifyEntitlement
type ModifyEntitlementRequest struct {
	*requests.RpcRequest
	EndUserId *[]string `position:"Query" name:"EndUserId"  type:"Repeated"`
	DesktopId string    `position:"Query" name:"DesktopId"`
}

// ModifyEntitlementResponse is the response struct for api ModifyEntitlement
type ModifyEntitlementResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyEntitlementRequest creates a request to invoke ModifyEntitlement API
func CreateModifyEntitlementRequest() (request *ModifyEntitlementRequest) {
	request = &ModifyEntitlementRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyEntitlement", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyEntitlementResponse creates a response to parse from ModifyEntitlement response
func CreateModifyEntitlementResponse() (response *ModifyEntitlementResponse) {
	response = &ModifyEntitlementResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
