package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStorageGateway invokes the ens.CreateStorageGateway API synchronously
func (client *Client) CreateStorageGateway(request *CreateStorageGatewayRequest) (response *CreateStorageGatewayResponse, err error) {
	response = CreateCreateStorageGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStorageGatewayWithChan invokes the ens.CreateStorageGateway API asynchronously
func (client *Client) CreateStorageGatewayWithChan(request *CreateStorageGatewayRequest) (<-chan *CreateStorageGatewayResponse, <-chan error) {
	responseChan := make(chan *CreateStorageGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStorageGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStorageGatewayWithCallback invokes the ens.CreateStorageGateway API asynchronously
func (client *Client) CreateStorageGatewayWithCallback(request *CreateStorageGatewayRequest, callback func(response *CreateStorageGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStorageGatewayResponse
		var err error
		defer close(result)
		response, err = client.CreateStorageGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStorageGatewayRequest is the request struct for api CreateStorageGateway
type CreateStorageGatewayRequest struct {
	*requests.RpcRequest
	OrderDetails *[]CreateStorageGatewayOrderDetails `position:"Query" name:"OrderDetails"  type:"Json"`
}

// CreateStorageGatewayOrderDetails is a repeated param struct in CreateStorageGatewayRequest
type CreateStorageGatewayOrderDetails struct {
	GatewayType string `name:"GatewayType"`
	VpcId       string `name:"VpcId"`
	GatewayName string `name:"GatewayName"`
	EnsRegionId string `name:"EnsRegionId"`
	Description string `name:"Description"`
}

// CreateStorageGatewayResponse is the response struct for api CreateStorageGateway
type CreateStorageGatewayResponse struct {
	*responses.BaseResponse
	RequestId      string                                   `json:"RequestId" xml:"RequestId"`
	BizStatusCode  string                                   `json:"BizStatusCode" xml:"BizStatusCode"`
	AllocationId   []AllocationIdItemInCreateStorageGateway `json:"AllocationId" xml:"AllocationId"`
	UnAllocationId []UnAllocationIdItem                     `json:"UnAllocationId" xml:"UnAllocationId"`
}

// CreateCreateStorageGatewayRequest creates a request to invoke CreateStorageGateway API
func CreateCreateStorageGatewayRequest() (request *CreateStorageGatewayRequest) {
	request = &CreateStorageGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateStorageGateway", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateStorageGatewayResponse creates a response to parse from CreateStorageGateway response
func CreateCreateStorageGatewayResponse() (response *CreateStorageGatewayResponse) {
	response = &CreateStorageGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
