package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CommitJob invokes the foas.CommitJob API synchronously
func (client *Client) CommitJob(request *CommitJobRequest) (response *CommitJobResponse, err error) {
	response = CreateCommitJobResponse()
	err = client.DoAction(request, response)
	return
}

// CommitJobWithChan invokes the foas.CommitJob API asynchronously
func (client *Client) CommitJobWithChan(request *CommitJobRequest) (<-chan *CommitJobResponse, <-chan error) {
	responseChan := make(chan *CommitJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CommitJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CommitJobWithCallback invokes the foas.CommitJob API asynchronously
func (client *Client) CommitJobWithCallback(request *CommitJobRequest, callback func(response *CommitJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CommitJobResponse
		var err error
		defer close(result)
		response, err = client.CommitJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CommitJobRequest is the request struct for api CommitJob
type CommitJobRequest struct {
	*requests.RoaRequest
	ProjectName        string                         `position:"Path" name:"projectName"`
	RecommendOnly      requests.Boolean               `position:"Body" name:"recommendOnly"`
	SuspendPeriods     string                         `position:"Body" name:"suspendPeriods"`
	MaxCU              requests.Float                 `position:"Body" name:"maxCU"`
	Configure          string                         `position:"Body" name:"configure"`
	IsOnOff            requests.Boolean               `position:"Body" name:"isOnOff"`
	JobName            string                         `position:"Path" name:"jobName"`
	SuspendPeriodParam *[]CommitJobSuspendPeriodParam `position:"Body" name:"suspendPeriodParam"  type:"Repeated"`
}

// CommitJobSuspendPeriodParam is a repeated param struct in CommitJobRequest
type CommitJobSuspendPeriodParam struct {
	EndTime   string `name:"endTime"`
	StartTime string `name:"startTime"`
	Plan      string `name:"plan"`
	Policy    string `name:"policy"`
}

// CommitJobResponse is the response struct for api CommitJob
type CommitJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCommitJobRequest creates a request to invoke CommitJob API
func CreateCommitJobRequest() (request *CommitJobRequest) {
	request = &CommitJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "CommitJob", "/api/v2/projects/[projectName]/jobs/[jobName]/commit", "foas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateCommitJobResponse creates a response to parse from CommitJob response
func CreateCommitJobResponse() (response *CommitJobResponse) {
	response = &CommitJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
