package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLdpsComputeGroup invokes the hitsdb.UpdateLdpsComputeGroup API synchronously
func (client *Client) UpdateLdpsComputeGroup(request *UpdateLdpsComputeGroupRequest) (response *UpdateLdpsComputeGroupResponse, err error) {
	response = CreateUpdateLdpsComputeGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLdpsComputeGroupWithChan invokes the hitsdb.UpdateLdpsComputeGroup API asynchronously
func (client *Client) UpdateLdpsComputeGroupWithChan(request *UpdateLdpsComputeGroupRequest) (<-chan *UpdateLdpsComputeGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateLdpsComputeGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLdpsComputeGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLdpsComputeGroupWithCallback invokes the hitsdb.UpdateLdpsComputeGroup API asynchronously
func (client *Client) UpdateLdpsComputeGroupWithCallback(request *UpdateLdpsComputeGroupRequest, callback func(response *UpdateLdpsComputeGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLdpsComputeGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateLdpsComputeGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLdpsComputeGroupRequest is the request struct for api UpdateLdpsComputeGroup
type UpdateLdpsComputeGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	GroupName            string           `position:"Query" name:"GroupName"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Properties           string           `position:"Query" name:"Properties"`
}

// UpdateLdpsComputeGroupResponse is the response struct for api UpdateLdpsComputeGroup
type UpdateLdpsComputeGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLdpsComputeGroupRequest creates a request to invoke UpdateLdpsComputeGroup API
func CreateUpdateLdpsComputeGroupRequest() (request *UpdateLdpsComputeGroupRequest) {
	request = &UpdateLdpsComputeGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "UpdateLdpsComputeGroup", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLdpsComputeGroupResponse creates a response to parse from UpdateLdpsComputeGroup response
func CreateUpdateLdpsComputeGroupResponse() (response *UpdateLdpsComputeGroupResponse) {
	response = &UpdateLdpsComputeGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
