package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeviceTunnel invokes the iot.CreateDeviceTunnel API synchronously
func (client *Client) CreateDeviceTunnel(request *CreateDeviceTunnelRequest) (response *CreateDeviceTunnelResponse, err error) {
	response = CreateCreateDeviceTunnelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeviceTunnelWithChan invokes the iot.CreateDeviceTunnel API asynchronously
func (client *Client) CreateDeviceTunnelWithChan(request *CreateDeviceTunnelRequest) (<-chan *CreateDeviceTunnelResponse, <-chan error) {
	responseChan := make(chan *CreateDeviceTunnelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeviceTunnel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeviceTunnelWithCallback invokes the iot.CreateDeviceTunnel API asynchronously
func (client *Client) CreateDeviceTunnelWithCallback(request *CreateDeviceTunnelRequest, callback func(response *CreateDeviceTunnelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeviceTunnelResponse
		var err error
		defer close(result)
		response, err = client.CreateDeviceTunnel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeviceTunnelRequest is the request struct for api CreateDeviceTunnel
type CreateDeviceTunnelRequest struct {
	*requests.RpcRequest
	Description   string `position:"Query" name:"Description"`
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
	Udi           string `position:"Query" name:"Udi"`
}

// CreateDeviceTunnelResponse is the response struct for api CreateDeviceTunnel
type CreateDeviceTunnelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateCreateDeviceTunnelRequest creates a request to invoke CreateDeviceTunnel API
func CreateCreateDeviceTunnelRequest() (request *CreateDeviceTunnelRequest) {
	request = &CreateDeviceTunnelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateDeviceTunnel", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDeviceTunnelResponse creates a response to parse from CreateDeviceTunnel response
func CreateCreateDeviceTunnelResponse() (response *CreateDeviceTunnelResponse) {
	response = &CreateDeviceTunnelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
