package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySharePromotionActivityAuditResult invokes the iot.QuerySharePromotionActivityAuditResult API synchronously
func (client *Client) QuerySharePromotionActivityAuditResult(request *QuerySharePromotionActivityAuditResultRequest) (response *QuerySharePromotionActivityAuditResultResponse, err error) {
	response = CreateQuerySharePromotionActivityAuditResultResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySharePromotionActivityAuditResultWithChan invokes the iot.QuerySharePromotionActivityAuditResult API asynchronously
func (client *Client) QuerySharePromotionActivityAuditResultWithChan(request *QuerySharePromotionActivityAuditResultRequest) (<-chan *QuerySharePromotionActivityAuditResultResponse, <-chan error) {
	responseChan := make(chan *QuerySharePromotionActivityAuditResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySharePromotionActivityAuditResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySharePromotionActivityAuditResultWithCallback invokes the iot.QuerySharePromotionActivityAuditResult API asynchronously
func (client *Client) QuerySharePromotionActivityAuditResultWithCallback(request *QuerySharePromotionActivityAuditResultRequest, callback func(response *QuerySharePromotionActivityAuditResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySharePromotionActivityAuditResultResponse
		var err error
		defer close(result)
		response, err = client.QuerySharePromotionActivityAuditResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySharePromotionActivityAuditResultRequest is the request struct for api QuerySharePromotionActivityAuditResult
type QuerySharePromotionActivityAuditResultRequest struct {
	*requests.RpcRequest
	SharePromotionActivityId string `position:"Body" name:"SharePromotionActivityId"`
	IotInstanceId            string `position:"Body" name:"IotInstanceId"`
	ShareTaskCode            string `position:"Body" name:"ShareTaskCode"`
	ApiProduct               string `position:"Body" name:"ApiProduct"`
	ApiRevision              string `position:"Body" name:"ApiRevision"`
}

// QuerySharePromotionActivityAuditResultResponse is the response struct for api QuerySharePromotionActivityAuditResult
type QuerySharePromotionActivityAuditResultResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQuerySharePromotionActivityAuditResultRequest creates a request to invoke QuerySharePromotionActivityAuditResult API
func CreateQuerySharePromotionActivityAuditResultRequest() (request *QuerySharePromotionActivityAuditResultRequest) {
	request = &QuerySharePromotionActivityAuditResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySharePromotionActivityAuditResult", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySharePromotionActivityAuditResultResponse creates a response to parse from QuerySharePromotionActivityAuditResult response
func CreateQuerySharePromotionActivityAuditResultResponse() (response *QuerySharePromotionActivityAuditResultResponse) {
	response = &QuerySharePromotionActivityAuditResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
