package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveMgsApirest invokes the mpaas.SaveMgsApirest API synchronously
func (client *Client) SaveMgsApirest(request *SaveMgsApirestRequest) (response *SaveMgsApirestResponse, err error) {
	response = CreateSaveMgsApirestResponse()
	err = client.DoAction(request, response)
	return
}

// SaveMgsApirestWithChan invokes the mpaas.SaveMgsApirest API asynchronously
func (client *Client) SaveMgsApirestWithChan(request *SaveMgsApirestRequest) (<-chan *SaveMgsApirestResponse, <-chan error) {
	responseChan := make(chan *SaveMgsApirestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveMgsApirest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveMgsApirestWithCallback invokes the mpaas.SaveMgsApirest API asynchronously
func (client *Client) SaveMgsApirestWithCallback(request *SaveMgsApirestRequest, callback func(response *SaveMgsApirestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveMgsApirestResponse
		var err error
		defer close(result)
		response, err = client.SaveMgsApirest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveMgsApirestRequest is the request struct for api SaveMgsApirest
type SaveMgsApirestRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMgsApirestSaveJsonStr string `position:"Body" name:"MpaasMappcenterMgsApirestSaveJsonStr"`
	TenantId                             string `position:"Body" name:"TenantId"`
	AppId                                string `position:"Body" name:"AppId"`
	WorkspaceId                          string `position:"Body" name:"WorkspaceId"`
}

// SaveMgsApirestResponse is the response struct for api SaveMgsApirest
type SaveMgsApirestResponse struct {
	*responses.BaseResponse
	ResultMessage string                        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInSaveMgsApirest `json:"ResultContent" xml:"ResultContent"`
}

// CreateSaveMgsApirestRequest creates a request to invoke SaveMgsApirest API
func CreateSaveMgsApirestRequest() (request *SaveMgsApirestRequest) {
	request = &SaveMgsApirestRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "SaveMgsApirest", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveMgsApirestResponse creates a response to parse from SaveMgsApirest response
func CreateSaveMgsApirestResponse() (response *SaveMgsApirestResponse) {
	response = &SaveMgsApirestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
