package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGatewayAuthConsumer invokes the mse.AddGatewayAuthConsumer API synchronously
func (client *Client) AddGatewayAuthConsumer(request *AddGatewayAuthConsumerRequest) (response *AddGatewayAuthConsumerResponse, err error) {
	response = CreateAddGatewayAuthConsumerResponse()
	err = client.DoAction(request, response)
	return
}

// AddGatewayAuthConsumerWithChan invokes the mse.AddGatewayAuthConsumer API asynchronously
func (client *Client) AddGatewayAuthConsumerWithChan(request *AddGatewayAuthConsumerRequest) (<-chan *AddGatewayAuthConsumerResponse, <-chan error) {
	responseChan := make(chan *AddGatewayAuthConsumerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGatewayAuthConsumer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGatewayAuthConsumerWithCallback invokes the mse.AddGatewayAuthConsumer API asynchronously
func (client *Client) AddGatewayAuthConsumerWithCallback(request *AddGatewayAuthConsumerRequest, callback func(response *AddGatewayAuthConsumerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGatewayAuthConsumerResponse
		var err error
		defer close(result)
		response, err = client.AddGatewayAuthConsumer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGatewayAuthConsumerRequest is the request struct for api AddGatewayAuthConsumer
type AddGatewayAuthConsumerRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	Type            string           `position:"Query" name:"Type"`
	KeyName         string           `position:"Query" name:"KeyName"`
	TokenPrefix     string           `position:"Query" name:"TokenPrefix"`
	Name            string           `position:"Query" name:"Name"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Jwks            string           `position:"Query" name:"Jwks"`
	Description     string           `position:"Query" name:"Description"`
	TokenPosition   string           `position:"Query" name:"TokenPosition"`
	EncodeType      string           `position:"Query" name:"EncodeType"`
	KeyValue        string           `position:"Query" name:"KeyValue"`
	TokenPass       requests.Boolean `position:"Query" name:"TokenPass"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	TokenName       string           `position:"Query" name:"TokenName"`
}

// AddGatewayAuthConsumerResponse is the response struct for api AddGatewayAuthConsumer
type AddGatewayAuthConsumerResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateAddGatewayAuthConsumerRequest creates a request to invoke AddGatewayAuthConsumer API
func CreateAddGatewayAuthConsumerRequest() (request *AddGatewayAuthConsumerRequest) {
	request = &AddGatewayAuthConsumerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddGatewayAuthConsumer", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddGatewayAuthConsumerResponse creates a response to parse from AddGatewayAuthConsumer response
func CreateAddGatewayAuthConsumerResponse() (response *AddGatewayAuthConsumerResponse) {
	response = &AddGatewayAuthConsumerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
