package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TagCustomPerson invokes the mts.TagCustomPerson API synchronously
func (client *Client) TagCustomPerson(request *TagCustomPersonRequest) (response *TagCustomPersonResponse, err error) {
	response = CreateTagCustomPersonResponse()
	err = client.DoAction(request, response)
	return
}

// TagCustomPersonWithChan invokes the mts.TagCustomPerson API asynchronously
func (client *Client) TagCustomPersonWithChan(request *TagCustomPersonRequest) (<-chan *TagCustomPersonResponse, <-chan error) {
	responseChan := make(chan *TagCustomPersonResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TagCustomPerson(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TagCustomPersonWithCallback invokes the mts.TagCustomPerson API asynchronously
func (client *Client) TagCustomPersonWithCallback(request *TagCustomPersonRequest, callback func(response *TagCustomPersonResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TagCustomPersonResponse
		var err error
		defer close(result)
		response, err = client.TagCustomPerson(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TagCustomPersonRequest is the request struct for api TagCustomPerson
type TagCustomPersonRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PersonDescription    string           `position:"Query" name:"PersonDescription"`
	CategoryDescription  string           `position:"Query" name:"CategoryDescription"`
	PersonId             string           `position:"Query" name:"PersonId"`
	CategoryId           string           `position:"Query" name:"CategoryId"`
	PersonName           string           `position:"Query" name:"PersonName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CategoryName         string           `position:"Query" name:"CategoryName"`
}

// TagCustomPersonResponse is the response struct for api TagCustomPerson
type TagCustomPersonResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateTagCustomPersonRequest creates a request to invoke TagCustomPerson API
func CreateTagCustomPersonRequest() (request *TagCustomPersonRequest) {
	request = &TagCustomPersonRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "TagCustomPerson", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTagCustomPersonResponse creates a response to parse from TagCustomPerson response
func CreateTagCustomPersonResponse() (response *TagCustomPersonResponse) {
	response = &TagCustomPersonResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
