package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOceanBaseDataSource invokes the oceanbasepro.CreateOceanBaseDataSource API synchronously
func (client *Client) CreateOceanBaseDataSource(request *CreateOceanBaseDataSourceRequest) (response *CreateOceanBaseDataSourceResponse, err error) {
	response = CreateCreateOceanBaseDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOceanBaseDataSourceWithChan invokes the oceanbasepro.CreateOceanBaseDataSource API asynchronously
func (client *Client) CreateOceanBaseDataSourceWithChan(request *CreateOceanBaseDataSourceRequest) (<-chan *CreateOceanBaseDataSourceResponse, <-chan error) {
	responseChan := make(chan *CreateOceanBaseDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOceanBaseDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOceanBaseDataSourceWithCallback invokes the oceanbasepro.CreateOceanBaseDataSource API asynchronously
func (client *Client) CreateOceanBaseDataSourceWithCallback(request *CreateOceanBaseDataSourceRequest, callback func(response *CreateOceanBaseDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOceanBaseDataSourceResponse
		var err error
		defer close(result)
		response, err = client.CreateOceanBaseDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOceanBaseDataSourceRequest is the request struct for api CreateOceanBaseDataSource
type CreateOceanBaseDataSourceRequest struct {
	*requests.RpcRequest
	Cluster          string           `position:"Body" name:"Cluster"`
	DrcUserName      string           `position:"Body" name:"DrcUserName"`
	LogProxyIp       string           `position:"Body" name:"LogProxyIp"`
	Description      string           `position:"Body" name:"Description"`
	Type             string           `position:"Body" name:"Type"`
	Password         string           `position:"Body" name:"Password"`
	InnerDrcPassword string           `position:"Body" name:"InnerDrcPassword"`
	Tenant           string           `position:"Body" name:"Tenant"`
	ConfigUrl        string           `position:"Body" name:"ConfigUrl"`
	Ip               string           `position:"Body" name:"Ip"`
	Port             requests.Integer `position:"Body" name:"Port"`
	VpcId            string           `position:"Body" name:"VpcId"`
	Name             string           `position:"Body" name:"Name"`
	DrcPassword      string           `position:"Body" name:"DrcPassword"`
	LogProxyPort     string           `position:"Body" name:"LogProxyPort"`
	UserName         string           `position:"Body" name:"UserName"`
}

// CreateOceanBaseDataSourceResponse is the response struct for api CreateOceanBaseDataSource
type CreateOceanBaseDataSourceResponse struct {
	*responses.BaseResponse
}

// CreateCreateOceanBaseDataSourceRequest creates a request to invoke CreateOceanBaseDataSource API
func CreateCreateOceanBaseDataSourceRequest() (request *CreateOceanBaseDataSourceRequest) {
	request = &CreateOceanBaseDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateOceanBaseDataSource", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOceanBaseDataSourceResponse creates a response to parse from CreateOceanBaseDataSource response
func CreateCreateOceanBaseDataSourceResponse() (response *CreateOceanBaseDataSourceResponse) {
	response = &CreateOceanBaseDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
