package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// KillProcessList invokes the oceanbasepro.KillProcessList API synchronously
func (client *Client) KillProcessList(request *KillProcessListRequest) (response *KillProcessListResponse, err error) {
	response = CreateKillProcessListResponse()
	err = client.DoAction(request, response)
	return
}

// KillProcessListWithChan invokes the oceanbasepro.KillProcessList API asynchronously
func (client *Client) KillProcessListWithChan(request *KillProcessListRequest) (<-chan *KillProcessListResponse, <-chan error) {
	responseChan := make(chan *KillProcessListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.KillProcessList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// KillProcessListWithCallback invokes the oceanbasepro.KillProcessList API asynchronously
func (client *Client) KillProcessListWithCallback(request *KillProcessListRequest, callback func(response *KillProcessListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *KillProcessListResponse
		var err error
		defer close(result)
		response, err = client.KillProcessList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// KillProcessListRequest is the request struct for api KillProcessList
type KillProcessListRequest struct {
	*requests.RpcRequest
	SessionList string `position:"Body" name:"SessionList"`
	InstanceId  string `position:"Body" name:"InstanceId"`
	TenantId    string `position:"Body" name:"TenantId"`
}

// KillProcessListResponse is the response struct for api KillProcessList
type KillProcessListResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Data      []DataItemInKillProcessList `json:"Data" xml:"Data"`
}

// CreateKillProcessListRequest creates a request to invoke KillProcessList API
func CreateKillProcessListRequest() (request *KillProcessListRequest) {
	request = &KillProcessListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "KillProcessList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateKillProcessListResponse creates a response to parse from KillProcessList response
func CreateKillProcessListResponse() (response *KillProcessListResponse) {
	response = &KillProcessListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
