package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTenantTags invokes the oceanbasepro.ModifyTenantTags API synchronously
func (client *Client) ModifyTenantTags(request *ModifyTenantTagsRequest) (response *ModifyTenantTagsResponse, err error) {
	response = CreateModifyTenantTagsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTenantTagsWithChan invokes the oceanbasepro.ModifyTenantTags API asynchronously
func (client *Client) ModifyTenantTagsWithChan(request *ModifyTenantTagsRequest) (<-chan *ModifyTenantTagsResponse, <-chan error) {
	responseChan := make(chan *ModifyTenantTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTenantTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTenantTagsWithCallback invokes the oceanbasepro.ModifyTenantTags API asynchronously
func (client *Client) ModifyTenantTagsWithCallback(request *ModifyTenantTagsRequest, callback func(response *ModifyTenantTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTenantTagsResponse
		var err error
		defer close(result)
		response, err = client.ModifyTenantTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTenantTagsRequest is the request struct for api ModifyTenantTags
type ModifyTenantTagsRequest struct {
	*requests.RpcRequest
	Tags       string `position:"Body" name:"Tags"`
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// ModifyTenantTagsResponse is the response struct for api ModifyTenantTags
type ModifyTenantTagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyTenantTagsRequest creates a request to invoke ModifyTenantTags API
func CreateModifyTenantTagsRequest() (request *ModifyTenantTagsRequest) {
	request = &ModifyTenantTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyTenantTags", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTenantTagsResponse creates a response to parse from ModifyTenantTags response
func CreateModifyTenantTagsResponse() (response *ModifyTenantTagsResponse) {
	response = &ModifyTenantTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
