package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDBEndpointAddress invokes the polardb.DeleteDBEndpointAddress API synchronously
func (client *Client) DeleteDBEndpointAddress(request *DeleteDBEndpointAddressRequest) (response *DeleteDBEndpointAddressResponse, err error) {
	response = CreateDeleteDBEndpointAddressResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDBEndpointAddressWithChan invokes the polardb.DeleteDBEndpointAddress API asynchronously
func (client *Client) DeleteDBEndpointAddressWithChan(request *DeleteDBEndpointAddressRequest) (<-chan *DeleteDBEndpointAddressResponse, <-chan error) {
	responseChan := make(chan *DeleteDBEndpointAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDBEndpointAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDBEndpointAddressWithCallback invokes the polardb.DeleteDBEndpointAddress API asynchronously
func (client *Client) DeleteDBEndpointAddressWithCallback(request *DeleteDBEndpointAddressRequest, callback func(response *DeleteDBEndpointAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDBEndpointAddressResponse
		var err error
		defer close(result)
		response, err = client.DeleteDBEndpointAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDBEndpointAddressRequest is the request struct for api DeleteDBEndpointAddress
type DeleteDBEndpointAddressRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBEndpointId         string           `position:"Query" name:"DBEndpointId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NetType              string           `position:"Query" name:"NetType"`
}

// DeleteDBEndpointAddressResponse is the response struct for api DeleteDBEndpointAddress
type DeleteDBEndpointAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDBEndpointAddressRequest creates a request to invoke DeleteDBEndpointAddress API
func CreateDeleteDBEndpointAddressRequest() (request *DeleteDBEndpointAddressRequest) {
	request = &DeleteDBEndpointAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DeleteDBEndpointAddress", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDBEndpointAddressResponse creates a response to parse from DeleteDBEndpointAddress response
func CreateDeleteDBEndpointAddressResponse() (response *DeleteDBEndpointAddressResponse) {
	response = &DeleteDBEndpointAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
