package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCheckTypeToScheme invokes the qualitycheck.CreateCheckTypeToScheme API synchronously
func (client *Client) CreateCheckTypeToScheme(request *CreateCheckTypeToSchemeRequest) (response *CreateCheckTypeToSchemeResponse, err error) {
	response = CreateCreateCheckTypeToSchemeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCheckTypeToSchemeWithChan invokes the qualitycheck.CreateCheckTypeToScheme API asynchronously
func (client *Client) CreateCheckTypeToSchemeWithChan(request *CreateCheckTypeToSchemeRequest) (<-chan *CreateCheckTypeToSchemeResponse, <-chan error) {
	responseChan := make(chan *CreateCheckTypeToSchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCheckTypeToScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCheckTypeToSchemeWithCallback invokes the qualitycheck.CreateCheckTypeToScheme API asynchronously
func (client *Client) CreateCheckTypeToSchemeWithCallback(request *CreateCheckTypeToSchemeRequest, callback func(response *CreateCheckTypeToSchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCheckTypeToSchemeResponse
		var err error
		defer close(result)
		response, err = client.CreateCheckTypeToScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCheckTypeToSchemeRequest is the request struct for api CreateCheckTypeToScheme
type CreateCheckTypeToSchemeRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// CreateCheckTypeToSchemeResponse is the response struct for api CreateCheckTypeToScheme
type CreateCheckTypeToSchemeResponse struct {
	*responses.BaseResponse
	Data           int64                             `json:"Data" xml:"Data"`
	RequestId      string                            `json:"RequestId" xml:"RequestId"`
	Success        bool                              `json:"Success" xml:"Success"`
	Code           string                            `json:"Code" xml:"Code"`
	Message        string                            `json:"Message" xml:"Message"`
	HttpStatusCode int                               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInCreateCheckTypeToScheme `json:"Messages" xml:"Messages"`
}

// CreateCreateCheckTypeToSchemeRequest creates a request to invoke CreateCheckTypeToScheme API
func CreateCreateCheckTypeToSchemeRequest() (request *CreateCheckTypeToSchemeRequest) {
	request = &CreateCheckTypeToSchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "CreateCheckTypeToScheme", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCheckTypeToSchemeResponse creates a response to parse from CreateCheckTypeToScheme response
func CreateCreateCheckTypeToSchemeResponse() (response *CreateCheckTypeToSchemeResponse) {
	response = &CreateCheckTypeToSchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
