package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateQuotaAlarm invokes the quotas.UpdateQuotaAlarm API synchronously
func (client *Client) UpdateQuotaAlarm(request *UpdateQuotaAlarmRequest) (response *UpdateQuotaAlarmResponse, err error) {
	response = CreateUpdateQuotaAlarmResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateQuotaAlarmWithChan invokes the quotas.UpdateQuotaAlarm API asynchronously
func (client *Client) UpdateQuotaAlarmWithChan(request *UpdateQuotaAlarmRequest) (<-chan *UpdateQuotaAlarmResponse, <-chan error) {
	responseChan := make(chan *UpdateQuotaAlarmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateQuotaAlarm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateQuotaAlarmWithCallback invokes the quotas.UpdateQuotaAlarm API asynchronously
func (client *Client) UpdateQuotaAlarmWithCallback(request *UpdateQuotaAlarmRequest, callback func(response *UpdateQuotaAlarmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateQuotaAlarmResponse
		var err error
		defer close(result)
		response, err = client.UpdateQuotaAlarm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateQuotaAlarmRequest is the request struct for api UpdateQuotaAlarm
type UpdateQuotaAlarmRequest struct {
	*requests.RpcRequest
	WebHook          string         `position:"Body" name:"WebHook"`
	Threshold        requests.Float `position:"Body" name:"Threshold"`
	ThresholdType    string         `position:"Body" name:"ThresholdType"`
	OriginalContext  string         `position:"Body" name:"OriginalContext"`
	ThresholdPercent requests.Float `position:"Body" name:"ThresholdPercent"`
	AlarmId          string         `position:"Body" name:"AlarmId"`
	AlarmName        string         `position:"Body" name:"AlarmName"`
}

// UpdateQuotaAlarmResponse is the response struct for api UpdateQuotaAlarm
type UpdateQuotaAlarmResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateQuotaAlarmRequest creates a request to invoke UpdateQuotaAlarm API
func CreateUpdateQuotaAlarmRequest() (request *UpdateQuotaAlarmRequest) {
	request = &UpdateQuotaAlarmRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "UpdateQuotaAlarm", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateQuotaAlarmResponse creates a response to parse from UpdateQuotaAlarm response
func CreateUpdateQuotaAlarmResponse() (response *UpdateQuotaAlarmResponse) {
	response = &UpdateQuotaAlarmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
