package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMaskingRules invokes the rds.ModifyMaskingRules API synchronously
func (client *Client) ModifyMaskingRules(request *ModifyMaskingRulesRequest) (response *ModifyMaskingRulesResponse, err error) {
	response = CreateModifyMaskingRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMaskingRulesWithChan invokes the rds.ModifyMaskingRules API asynchronously
func (client *Client) ModifyMaskingRulesWithChan(request *ModifyMaskingRulesRequest) (<-chan *ModifyMaskingRulesResponse, <-chan error) {
	responseChan := make(chan *ModifyMaskingRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMaskingRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMaskingRulesWithCallback invokes the rds.ModifyMaskingRules API asynchronously
func (client *Client) ModifyMaskingRulesWithCallback(request *ModifyMaskingRulesRequest, callback func(response *ModifyMaskingRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMaskingRulesResponse
		var err error
		defer close(result)
		response, err = client.ModifyMaskingRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMaskingRulesRequest is the request struct for api ModifyMaskingRules
type ModifyMaskingRulesRequest struct {
	*requests.RpcRequest
	DBInstanceName       string                       `position:"Query" name:"DBInstanceName"`
	ResourceOwnerId      requests.Integer             `position:"Query" name:"ResourceOwnerId"`
	MaskingAlgo          string                       `position:"Query" name:"MaskingAlgo"`
	RuleName             string                       `position:"Query" name:"RuleName"`
	Enabled              string                       `position:"Query" name:"Enabled"`
	ResourceOwnerAccount string                       `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              string                       `position:"Query" name:"OwnerId"`
	DefaultAlgo          string                       `position:"Query" name:"DefaultAlgo"`
	RuleConfig           ModifyMaskingRulesRuleConfig `position:"Query" name:"RuleConfig"  type:"Struct"`
}

// ModifyMaskingRulesRuleConfig is a repeated param struct in ModifyMaskingRulesRequest
type ModifyMaskingRulesRuleConfig struct {
	Databases *[]string `name:"Databases" type:"Repeated"`
	Tables    *[]string `name:"Tables" type:"Repeated"`
	Columns   *[]string `name:"Columns" type:"Repeated"`
}

// ModifyMaskingRulesResponse is the response struct for api ModifyMaskingRules
type ModifyMaskingRulesResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   string                 `json:"Success" xml:"Success"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateModifyMaskingRulesRequest creates a request to invoke ModifyMaskingRules API
func CreateModifyMaskingRulesRequest() (request *ModifyMaskingRulesRequest) {
	request = &ModifyMaskingRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyMaskingRules", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyMaskingRulesResponse creates a response to parse from ModifyMaskingRules response
func CreateModifyMaskingRulesResponse() (response *ModifyMaskingRulesResponse) {
	response = &ModifyMaskingRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
