package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeAccountEmail invokes the resourcemanager.ChangeAccountEmail API synchronously
func (client *Client) ChangeAccountEmail(request *ChangeAccountEmailRequest) (response *ChangeAccountEmailResponse, err error) {
	response = CreateChangeAccountEmailResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeAccountEmailWithChan invokes the resourcemanager.ChangeAccountEmail API asynchronously
func (client *Client) ChangeAccountEmailWithChan(request *ChangeAccountEmailRequest) (<-chan *ChangeAccountEmailResponse, <-chan error) {
	responseChan := make(chan *ChangeAccountEmailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeAccountEmail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeAccountEmailWithCallback invokes the resourcemanager.ChangeAccountEmail API asynchronously
func (client *Client) ChangeAccountEmailWithCallback(request *ChangeAccountEmailRequest, callback func(response *ChangeAccountEmailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeAccountEmailResponse
		var err error
		defer close(result)
		response, err = client.ChangeAccountEmail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeAccountEmailRequest is the request struct for api ChangeAccountEmail
type ChangeAccountEmailRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
	Email     string `position:"Query" name:"Email"`
}

// ChangeAccountEmailResponse is the response struct for api ChangeAccountEmail
type ChangeAccountEmailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateChangeAccountEmailRequest creates a request to invoke ChangeAccountEmail API
func CreateChangeAccountEmailRequest() (request *ChangeAccountEmailRequest) {
	request = &ChangeAccountEmailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ChangeAccountEmail", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeAccountEmailResponse creates a response to parse from ChangeAccountEmail response
func CreateChangeAccountEmailResponse() (response *ChangeAccountEmailResponse) {
	response = &ChangeAccountEmailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
