package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PromoteResourceAccount invokes the resourcemanager.PromoteResourceAccount API synchronously
func (client *Client) PromoteResourceAccount(request *PromoteResourceAccountRequest) (response *PromoteResourceAccountResponse, err error) {
	response = CreatePromoteResourceAccountResponse()
	err = client.DoAction(request, response)
	return
}

// PromoteResourceAccountWithChan invokes the resourcemanager.PromoteResourceAccount API asynchronously
func (client *Client) PromoteResourceAccountWithChan(request *PromoteResourceAccountRequest) (<-chan *PromoteResourceAccountResponse, <-chan error) {
	responseChan := make(chan *PromoteResourceAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PromoteResourceAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PromoteResourceAccountWithCallback invokes the resourcemanager.PromoteResourceAccount API asynchronously
func (client *Client) PromoteResourceAccountWithCallback(request *PromoteResourceAccountRequest, callback func(response *PromoteResourceAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PromoteResourceAccountResponse
		var err error
		defer close(result)
		response, err = client.PromoteResourceAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PromoteResourceAccountRequest is the request struct for api PromoteResourceAccount
type PromoteResourceAccountRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
	Email     string `position:"Query" name:"Email"`
}

// PromoteResourceAccountResponse is the response struct for api PromoteResourceAccount
type PromoteResourceAccountResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Account   Account `json:"Account" xml:"Account"`
}

// CreatePromoteResourceAccountRequest creates a request to invoke PromoteResourceAccount API
func CreatePromoteResourceAccountRequest() (request *PromoteResourceAccountRequest) {
	request = &PromoteResourceAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "PromoteResourceAccount", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePromoteResourceAccountResponse creates a response to parse from PromoteResourceAccount response
func CreatePromoteResourceAccountResponse() (response *PromoteResourceAccountResponse) {
	response = &PromoteResourceAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
