package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCalendarNames invokes the schedulerx3.ListCalendarNames API synchronously
func (client *Client) ListCalendarNames(request *ListCalendarNamesRequest) (response *ListCalendarNamesResponse, err error) {
	response = CreateListCalendarNamesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCalendarNamesWithChan invokes the schedulerx3.ListCalendarNames API asynchronously
func (client *Client) ListCalendarNamesWithChan(request *ListCalendarNamesRequest) (<-chan *ListCalendarNamesResponse, <-chan error) {
	responseChan := make(chan *ListCalendarNamesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCalendarNames(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCalendarNamesWithCallback invokes the schedulerx3.ListCalendarNames API asynchronously
func (client *Client) ListCalendarNamesWithCallback(request *ListCalendarNamesRequest, callback func(response *ListCalendarNamesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCalendarNamesResponse
		var err error
		defer close(result)
		response, err = client.ListCalendarNames(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCalendarNamesRequest is the request struct for api ListCalendarNames
type ListCalendarNamesRequest struct {
	*requests.RpcRequest
	MseSessionId string `position:"Query" name:"MseSessionId"`
	ClusterId    string `position:"Query" name:"ClusterId"`
}

// ListCalendarNamesResponse is the response struct for api ListCalendarNames
type ListCalendarNamesResponse struct {
	*responses.BaseResponse
	Code      int      `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []string `json:"Data" xml:"Data"`
}

// CreateListCalendarNamesRequest creates a request to invoke ListCalendarNames API
func CreateListCalendarNamesRequest() (request *ListCalendarNamesRequest) {
	request = &ListCalendarNamesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ListCalendarNames", "", "")
	request.Method = requests.GET
	return
}

// CreateListCalendarNamesResponse creates a response to parse from ListCalendarNames response
func CreateListCalendarNamesResponse() (response *ListCalendarNamesResponse) {
	response = &ListCalendarNamesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
