package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayADInfo invokes the sgw.DescribeGatewayADInfo API synchronously
func (client *Client) DescribeGatewayADInfo(request *DescribeGatewayADInfoRequest) (response *DescribeGatewayADInfoResponse, err error) {
	response = CreateDescribeGatewayADInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayADInfoWithChan invokes the sgw.DescribeGatewayADInfo API asynchronously
func (client *Client) DescribeGatewayADInfoWithChan(request *DescribeGatewayADInfoRequest) (<-chan *DescribeGatewayADInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayADInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayADInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayADInfoWithCallback invokes the sgw.DescribeGatewayADInfo API asynchronously
func (client *Client) DescribeGatewayADInfoWithCallback(request *DescribeGatewayADInfoRequest, callback func(response *DescribeGatewayADInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayADInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayADInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayADInfoRequest is the request struct for api DescribeGatewayADInfo
type DescribeGatewayADInfoRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayADInfoResponse is the response struct for api DescribeGatewayADInfo
type DescribeGatewayADInfoResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    bool   `json:"Success" xml:"Success"`
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	Username   string `json:"Username" xml:"Username"`
	ServerIp   string `json:"ServerIp" xml:"ServerIp"`
	DomainName string `json:"DomainName" xml:"DomainName"`
	IsEnabled  bool   `json:"IsEnabled" xml:"IsEnabled"`
}

// CreateDescribeGatewayADInfoRequest creates a request to invoke DescribeGatewayADInfo API
func CreateDescribeGatewayADInfoRequest() (request *DescribeGatewayADInfoRequest) {
	request = &DescribeGatewayADInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayADInfo", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayADInfoResponse creates a response to parse from DescribeGatewayADInfo response
func CreateDescribeGatewayADInfoResponse() (response *DescribeGatewayADInfoResponse) {
	response = &DescribeGatewayADInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
