package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePlaybook invokes the sophonsoar.DeletePlaybook API synchronously
func (client *Client) DeletePlaybook(request *DeletePlaybookRequest) (response *DeletePlaybookResponse, err error) {
	response = CreateDeletePlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePlaybookWithChan invokes the sophonsoar.DeletePlaybook API asynchronously
func (client *Client) DeletePlaybookWithChan(request *DeletePlaybookRequest) (<-chan *DeletePlaybookResponse, <-chan error) {
	responseChan := make(chan *DeletePlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePlaybookWithCallback invokes the sophonsoar.DeletePlaybook API asynchronously
func (client *Client) DeletePlaybookWithCallback(request *DeletePlaybookRequest, callback func(response *DeletePlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePlaybookResponse
		var err error
		defer close(result)
		response, err = client.DeletePlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePlaybookRequest is the request struct for api DeletePlaybook
type DeletePlaybookRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	PlaybookUuid string `position:"Body" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Body" name:"Lang"`
}

// DeletePlaybookResponse is the response struct for api DeletePlaybook
type DeletePlaybookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePlaybookRequest creates a request to invoke DeletePlaybook API
func CreateDeletePlaybookRequest() (request *DeletePlaybookRequest) {
	request = &DeletePlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DeletePlaybook", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePlaybookResponse creates a response to parse from DeletePlaybook response
func CreateDeletePlaybookResponse() (response *DeletePlaybookResponse) {
	response = &DeletePlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
