package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeComponentAssets invokes the sophonsoar.DescribeComponentAssets API synchronously
func (client *Client) DescribeComponentAssets(request *DescribeComponentAssetsRequest) (response *DescribeComponentAssetsResponse, err error) {
	response = CreateDescribeComponentAssetsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComponentAssetsWithChan invokes the sophonsoar.DescribeComponentAssets API asynchronously
func (client *Client) DescribeComponentAssetsWithChan(request *DescribeComponentAssetsRequest) (<-chan *DescribeComponentAssetsResponse, <-chan error) {
	responseChan := make(chan *DescribeComponentAssetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeComponentAssets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComponentAssetsWithCallback invokes the sophonsoar.DescribeComponentAssets API asynchronously
func (client *Client) DescribeComponentAssetsWithCallback(request *DescribeComponentAssetsRequest, callback func(response *DescribeComponentAssetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComponentAssetsResponse
		var err error
		defer close(result)
		response, err = client.DescribeComponentAssets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComponentAssetsRequest is the request struct for api DescribeComponentAssets
type DescribeComponentAssetsRequest struct {
	*requests.RpcRequest
	RoleFor       string `position:"Query" name:"RoleFor"`
	ComponentName string `position:"Query" name:"ComponentName"`
	RoleType      string `position:"Query" name:"RoleType"`
	Lang          string `position:"Query" name:"Lang"`
}

// DescribeComponentAssetsResponse is the response struct for api DescribeComponentAssets
type DescribeComponentAssetsResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	ComponentAssets []ComponentAssetsItem `json:"ComponentAssets" xml:"ComponentAssets"`
}

// CreateDescribeComponentAssetsRequest creates a request to invoke DescribeComponentAssets API
func CreateDescribeComponentAssetsRequest() (request *DescribeComponentAssetsRequest) {
	request = &DescribeComponentAssetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeComponentAssets", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeComponentAssetsResponse creates a response to parse from DescribeComponentAssets response
func CreateDescribeComponentAssetsResponse() (response *DescribeComponentAssetsResponse) {
	response = &DescribeComponentAssetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
