package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPlans invokes the swas_open.ListPlans API synchronously
func (client *Client) ListPlans(request *ListPlansRequest) (response *ListPlansResponse, err error) {
	response = CreateListPlansResponse()
	err = client.DoAction(request, response)
	return
}

// ListPlansWithChan invokes the swas_open.ListPlans API asynchronously
func (client *Client) ListPlansWithChan(request *ListPlansRequest) (<-chan *ListPlansResponse, <-chan error) {
	responseChan := make(chan *ListPlansResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPlans(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPlansWithCallback invokes the swas_open.ListPlans API asynchronously
func (client *Client) ListPlansWithCallback(request *ListPlansRequest, callback func(response *ListPlansResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPlansResponse
		var err error
		defer close(result)
		response, err = client.ListPlans(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPlansRequest is the request struct for api ListPlans
type ListPlansRequest struct {
	*requests.RpcRequest
}

// ListPlansResponse is the response struct for api ListPlans
type ListPlansResponse struct {
	*responses.BaseResponse
	RequestId string            `json:"RequestId" xml:"RequestId"`
	Plans     []PlanInListPlans `json:"Plans" xml:"Plans"`
}

// CreateListPlansRequest creates a request to invoke ListPlans API
func CreateListPlansRequest() (request *ListPlansRequest) {
	request = &ListPlansRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ListPlans", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPlansResponse creates a response to parse from ListPlans response
func CreateListPlansResponse() (response *ListPlansResponse) {
	response = &ListPlansResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
