package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVcoRouteEntry invokes the vpc.DeleteVcoRouteEntry API synchronously
func (client *Client) DeleteVcoRouteEntry(request *DeleteVcoRouteEntryRequest) (response *DeleteVcoRouteEntryResponse, err error) {
	response = CreateDeleteVcoRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVcoRouteEntryWithChan invokes the vpc.DeleteVcoRouteEntry API asynchronously
func (client *Client) DeleteVcoRouteEntryWithChan(request *DeleteVcoRouteEntryRequest) (<-chan *DeleteVcoRouteEntryResponse, <-chan error) {
	responseChan := make(chan *DeleteVcoRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVcoRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVcoRouteEntryWithCallback invokes the vpc.DeleteVcoRouteEntry API asynchronously
func (client *Client) DeleteVcoRouteEntryWithCallback(request *DeleteVcoRouteEntryRequest, callback func(response *DeleteVcoRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVcoRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.DeleteVcoRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVcoRouteEntryRequest is the request struct for api DeleteVcoRouteEntry
type DeleteVcoRouteEntryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Weight               requests.Integer `position:"Query" name:"Weight"`
	RouteDest            string           `position:"Query" name:"RouteDest"`
	NextHop              string           `position:"Query" name:"NextHop"`
	VpnConnectionId      string           `position:"Query" name:"VpnConnectionId"`
	OverlayMode          string           `position:"Query" name:"OverlayMode"`
}

// DeleteVcoRouteEntryResponse is the response struct for api DeleteVcoRouteEntry
type DeleteVcoRouteEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVcoRouteEntryRequest creates a request to invoke DeleteVcoRouteEntry API
func CreateDeleteVcoRouteEntryRequest() (request *DeleteVcoRouteEntryRequest) {
	request = &DeleteVcoRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteVcoRouteEntry", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteVcoRouteEntryResponse creates a response to parse from DeleteVcoRouteEntry response
func CreateDeleteVcoRouteEntryResponse() (response *DeleteVcoRouteEntryResponse) {
	response = &DeleteVcoRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
