package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVcoRouteEntryWeight invokes the vpc.ModifyVcoRouteEntryWeight API synchronously
func (client *Client) ModifyVcoRouteEntryWeight(request *ModifyVcoRouteEntryWeightRequest) (response *ModifyVcoRouteEntryWeightResponse, err error) {
	response = CreateModifyVcoRouteEntryWeightResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVcoRouteEntryWeightWithChan invokes the vpc.ModifyVcoRouteEntryWeight API asynchronously
func (client *Client) ModifyVcoRouteEntryWeightWithChan(request *ModifyVcoRouteEntryWeightRequest) (<-chan *ModifyVcoRouteEntryWeightResponse, <-chan error) {
	responseChan := make(chan *ModifyVcoRouteEntryWeightResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVcoRouteEntryWeight(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVcoRouteEntryWeightWithCallback invokes the vpc.ModifyVcoRouteEntryWeight API asynchronously
func (client *Client) ModifyVcoRouteEntryWeightWithCallback(request *ModifyVcoRouteEntryWeightRequest, callback func(response *ModifyVcoRouteEntryWeightResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVcoRouteEntryWeightResponse
		var err error
		defer close(result)
		response, err = client.ModifyVcoRouteEntryWeight(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVcoRouteEntryWeightRequest is the request struct for api ModifyVcoRouteEntryWeight
type ModifyVcoRouteEntryWeightRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NewWeight            requests.Integer `position:"Query" name:"NewWeight"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Weight               requests.Integer `position:"Query" name:"Weight"`
	RouteDest            string           `position:"Query" name:"RouteDest"`
	NextHop              string           `position:"Query" name:"NextHop"`
	VpnConnectionId      string           `position:"Query" name:"VpnConnectionId"`
	OverlayMode          string           `position:"Query" name:"OverlayMode"`
}

// ModifyVcoRouteEntryWeightResponse is the response struct for api ModifyVcoRouteEntryWeight
type ModifyVcoRouteEntryWeightResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVcoRouteEntryWeightRequest creates a request to invoke ModifyVcoRouteEntryWeight API
func CreateModifyVcoRouteEntryWeightRequest() (request *ModifyVcoRouteEntryWeightRequest) {
	request = &ModifyVcoRouteEntryWeightRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyVcoRouteEntryWeight", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVcoRouteEntryWeightResponse creates a response to parse from ModifyVcoRouteEntryWeight response
func CreateModifyVcoRouteEntryWeightResponse() (response *ModifyVcoRouteEntryWeightResponse) {
	response = &ModifyVcoRouteEntryWeightResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
