#!/bin/bash

# Run this from the repository root:
#
# .github/generate-codecov-yml.sh >> .github/codecov.yml

cat <<EOT
# we measure coverage but don't enforce it
# https://docs.codecov.com/docs/codecov-yaml
codecov:
  require_ci_to_pass: false

coverage:
  status:
    patch:
      default:
        target: 0%
    project:
      default:
        target: 0%

# if a directory is ignored, there is no way to un-ignore files like pkg/models/helpers.go
# so we make a full list
ignore:
EOT

find . -name "*.go" | while read -r file; do
    if head -n 1 "$file" | grep -q "Code generated by"; then
        echo "  - \"$file\""
    fi
done
