// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlist"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlistitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// AllowListItemUpdate is the builder for updating AllowListItem entities.
type AllowListItemUpdate struct {
	config
	hooks    []Hook
	mutation *AllowListItemMutation
}

// Where appends a list predicates to the AllowListItemUpdate builder.
func (aliu *AllowListItemUpdate) Where(ps ...predicate.AllowListItem) *AllowListItemUpdate {
	aliu.mutation.Where(ps...)
	return aliu
}

// SetUpdatedAt sets the "updated_at" field.
func (aliu *AllowListItemUpdate) SetUpdatedAt(t time.Time) *AllowListItemUpdate {
	aliu.mutation.SetUpdatedAt(t)
	return aliu
}

// SetExpiresAt sets the "expires_at" field.
func (aliu *AllowListItemUpdate) SetExpiresAt(t time.Time) *AllowListItemUpdate {
	aliu.mutation.SetExpiresAt(t)
	return aliu
}

// SetNillableExpiresAt sets the "expires_at" field if the given value is not nil.
func (aliu *AllowListItemUpdate) SetNillableExpiresAt(t *time.Time) *AllowListItemUpdate {
	if t != nil {
		aliu.SetExpiresAt(*t)
	}
	return aliu
}

// ClearExpiresAt clears the value of the "expires_at" field.
func (aliu *AllowListItemUpdate) ClearExpiresAt() *AllowListItemUpdate {
	aliu.mutation.ClearExpiresAt()
	return aliu
}

// AddAllowlistIDs adds the "allowlist" edge to the AllowList entity by IDs.
func (aliu *AllowListItemUpdate) AddAllowlistIDs(ids ...int) *AllowListItemUpdate {
	aliu.mutation.AddAllowlistIDs(ids...)
	return aliu
}

// AddAllowlist adds the "allowlist" edges to the AllowList entity.
func (aliu *AllowListItemUpdate) AddAllowlist(a ...*AllowList) *AllowListItemUpdate {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return aliu.AddAllowlistIDs(ids...)
}

// Mutation returns the AllowListItemMutation object of the builder.
func (aliu *AllowListItemUpdate) Mutation() *AllowListItemMutation {
	return aliu.mutation
}

// ClearAllowlist clears all "allowlist" edges to the AllowList entity.
func (aliu *AllowListItemUpdate) ClearAllowlist() *AllowListItemUpdate {
	aliu.mutation.ClearAllowlist()
	return aliu
}

// RemoveAllowlistIDs removes the "allowlist" edge to AllowList entities by IDs.
func (aliu *AllowListItemUpdate) RemoveAllowlistIDs(ids ...int) *AllowListItemUpdate {
	aliu.mutation.RemoveAllowlistIDs(ids...)
	return aliu
}

// RemoveAllowlist removes "allowlist" edges to AllowList entities.
func (aliu *AllowListItemUpdate) RemoveAllowlist(a ...*AllowList) *AllowListItemUpdate {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return aliu.RemoveAllowlistIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (aliu *AllowListItemUpdate) Save(ctx context.Context) (int, error) {
	aliu.defaults()
	return withHooks(ctx, aliu.sqlSave, aliu.mutation, aliu.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aliu *AllowListItemUpdate) SaveX(ctx context.Context) int {
	affected, err := aliu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (aliu *AllowListItemUpdate) Exec(ctx context.Context) error {
	_, err := aliu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aliu *AllowListItemUpdate) ExecX(ctx context.Context) {
	if err := aliu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (aliu *AllowListItemUpdate) defaults() {
	if _, ok := aliu.mutation.UpdatedAt(); !ok {
		v := allowlistitem.UpdateDefaultUpdatedAt()
		aliu.mutation.SetUpdatedAt(v)
	}
}

func (aliu *AllowListItemUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(allowlistitem.Table, allowlistitem.Columns, sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt))
	if ps := aliu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := aliu.mutation.UpdatedAt(); ok {
		_spec.SetField(allowlistitem.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := aliu.mutation.ExpiresAt(); ok {
		_spec.SetField(allowlistitem.FieldExpiresAt, field.TypeTime, value)
	}
	if aliu.mutation.ExpiresAtCleared() {
		_spec.ClearField(allowlistitem.FieldExpiresAt, field.TypeTime)
	}
	if aliu.mutation.CommentCleared() {
		_spec.ClearField(allowlistitem.FieldComment, field.TypeString)
	}
	if aliu.mutation.StartIPCleared() {
		_spec.ClearField(allowlistitem.FieldStartIP, field.TypeInt64)
	}
	if aliu.mutation.EndIPCleared() {
		_spec.ClearField(allowlistitem.FieldEndIP, field.TypeInt64)
	}
	if aliu.mutation.StartSuffixCleared() {
		_spec.ClearField(allowlistitem.FieldStartSuffix, field.TypeInt64)
	}
	if aliu.mutation.EndSuffixCleared() {
		_spec.ClearField(allowlistitem.FieldEndSuffix, field.TypeInt64)
	}
	if aliu.mutation.IPSizeCleared() {
		_spec.ClearField(allowlistitem.FieldIPSize, field.TypeInt64)
	}
	if aliu.mutation.AllowlistCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   allowlistitem.AllowlistTable,
			Columns: allowlistitem.AllowlistPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aliu.mutation.RemovedAllowlistIDs(); len(nodes) > 0 && !aliu.mutation.AllowlistCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   allowlistitem.AllowlistTable,
			Columns: allowlistitem.AllowlistPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aliu.mutation.AllowlistIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   allowlistitem.AllowlistTable,
			Columns: allowlistitem.AllowlistPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, aliu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{allowlistitem.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	aliu.mutation.done = true
	return n, nil
}

// AllowListItemUpdateOne is the builder for updating a single AllowListItem entity.
type AllowListItemUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *AllowListItemMutation
}

// SetUpdatedAt sets the "updated_at" field.
func (aliuo *AllowListItemUpdateOne) SetUpdatedAt(t time.Time) *AllowListItemUpdateOne {
	aliuo.mutation.SetUpdatedAt(t)
	return aliuo
}

// SetExpiresAt sets the "expires_at" field.
func (aliuo *AllowListItemUpdateOne) SetExpiresAt(t time.Time) *AllowListItemUpdateOne {
	aliuo.mutation.SetExpiresAt(t)
	return aliuo
}

// SetNillableExpiresAt sets the "expires_at" field if the given value is not nil.
func (aliuo *AllowListItemUpdateOne) SetNillableExpiresAt(t *time.Time) *AllowListItemUpdateOne {
	if t != nil {
		aliuo.SetExpiresAt(*t)
	}
	return aliuo
}

// ClearExpiresAt clears the value of the "expires_at" field.
func (aliuo *AllowListItemUpdateOne) ClearExpiresAt() *AllowListItemUpdateOne {
	aliuo.mutation.ClearExpiresAt()
	return aliuo
}

// AddAllowlistIDs adds the "allowlist" edge to the AllowList entity by IDs.
func (aliuo *AllowListItemUpdateOne) AddAllowlistIDs(ids ...int) *AllowListItemUpdateOne {
	aliuo.mutation.AddAllowlistIDs(ids...)
	return aliuo
}

// AddAllowlist adds the "allowlist" edges to the AllowList entity.
func (aliuo *AllowListItemUpdateOne) AddAllowlist(a ...*AllowList) *AllowListItemUpdateOne {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return aliuo.AddAllowlistIDs(ids...)
}

// Mutation returns the AllowListItemMutation object of the builder.
func (aliuo *AllowListItemUpdateOne) Mutation() *AllowListItemMutation {
	return aliuo.mutation
}

// ClearAllowlist clears all "allowlist" edges to the AllowList entity.
func (aliuo *AllowListItemUpdateOne) ClearAllowlist() *AllowListItemUpdateOne {
	aliuo.mutation.ClearAllowlist()
	return aliuo
}

// RemoveAllowlistIDs removes the "allowlist" edge to AllowList entities by IDs.
func (aliuo *AllowListItemUpdateOne) RemoveAllowlistIDs(ids ...int) *AllowListItemUpdateOne {
	aliuo.mutation.RemoveAllowlistIDs(ids...)
	return aliuo
}

// RemoveAllowlist removes "allowlist" edges to AllowList entities.
func (aliuo *AllowListItemUpdateOne) RemoveAllowlist(a ...*AllowList) *AllowListItemUpdateOne {
	ids := make([]int, len(a))
	for i := range a {
		ids[i] = a[i].ID
	}
	return aliuo.RemoveAllowlistIDs(ids...)
}

// Where appends a list predicates to the AllowListItemUpdate builder.
func (aliuo *AllowListItemUpdateOne) Where(ps ...predicate.AllowListItem) *AllowListItemUpdateOne {
	aliuo.mutation.Where(ps...)
	return aliuo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (aliuo *AllowListItemUpdateOne) Select(field string, fields ...string) *AllowListItemUpdateOne {
	aliuo.fields = append([]string{field}, fields...)
	return aliuo
}

// Save executes the query and returns the updated AllowListItem entity.
func (aliuo *AllowListItemUpdateOne) Save(ctx context.Context) (*AllowListItem, error) {
	aliuo.defaults()
	return withHooks(ctx, aliuo.sqlSave, aliuo.mutation, aliuo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (aliuo *AllowListItemUpdateOne) SaveX(ctx context.Context) *AllowListItem {
	node, err := aliuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (aliuo *AllowListItemUpdateOne) Exec(ctx context.Context) error {
	_, err := aliuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (aliuo *AllowListItemUpdateOne) ExecX(ctx context.Context) {
	if err := aliuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (aliuo *AllowListItemUpdateOne) defaults() {
	if _, ok := aliuo.mutation.UpdatedAt(); !ok {
		v := allowlistitem.UpdateDefaultUpdatedAt()
		aliuo.mutation.SetUpdatedAt(v)
	}
}

func (aliuo *AllowListItemUpdateOne) sqlSave(ctx context.Context) (_node *AllowListItem, err error) {
	_spec := sqlgraph.NewUpdateSpec(allowlistitem.Table, allowlistitem.Columns, sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt))
	id, ok := aliuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "AllowListItem.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := aliuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, allowlistitem.FieldID)
		for _, f := range fields {
			if !allowlistitem.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != allowlistitem.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := aliuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := aliuo.mutation.UpdatedAt(); ok {
		_spec.SetField(allowlistitem.FieldUpdatedAt, field.TypeTime, value)
	}
	if value, ok := aliuo.mutation.ExpiresAt(); ok {
		_spec.SetField(allowlistitem.FieldExpiresAt, field.TypeTime, value)
	}
	if aliuo.mutation.ExpiresAtCleared() {
		_spec.ClearField(allowlistitem.FieldExpiresAt, field.TypeTime)
	}
	if aliuo.mutation.CommentCleared() {
		_spec.ClearField(allowlistitem.FieldComment, field.TypeString)
	}
	if aliuo.mutation.StartIPCleared() {
		_spec.ClearField(allowlistitem.FieldStartIP, field.TypeInt64)
	}
	if aliuo.mutation.EndIPCleared() {
		_spec.ClearField(allowlistitem.FieldEndIP, field.TypeInt64)
	}
	if aliuo.mutation.StartSuffixCleared() {
		_spec.ClearField(allowlistitem.FieldStartSuffix, field.TypeInt64)
	}
	if aliuo.mutation.EndSuffixCleared() {
		_spec.ClearField(allowlistitem.FieldEndSuffix, field.TypeInt64)
	}
	if aliuo.mutation.IPSizeCleared() {
		_spec.ClearField(allowlistitem.FieldIPSize, field.TypeInt64)
	}
	if aliuo.mutation.AllowlistCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   allowlistitem.AllowlistTable,
			Columns: allowlistitem.AllowlistPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aliuo.mutation.RemovedAllowlistIDs(); len(nodes) > 0 && !aliuo.mutation.AllowlistCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   allowlistitem.AllowlistTable,
			Columns: allowlistitem.AllowlistPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := aliuo.mutation.AllowlistIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   allowlistitem.AllowlistTable,
			Columns: allowlistitem.AllowlistPrimaryKey,
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(allowlist.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &AllowListItem{config: aliuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, aliuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{allowlistitem.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	aliuo.mutation.done = true
	return _node, nil
}
