Contributing to Eclipse Paho
============================

Thanks for your interest in this project.

Project Description:
--------------------

The Eclipse Paho project provides reliable open-source implementations of open and standard messaging protocols aimed at new, existing, and emerging applications for Machine-to-Machine (M2M) and Internet of Things (IoT).\
Paho reflects the inherent physical and cost constraints of device connectivity. Its objectives include effective levels of decoupling between devices and applications, designed to keep markets open and encourage the rapid growth of scalable Web and Enterprise middleware and applications. Paho contains MQTT publish/subscribe client implementations for use on embedded platforms, along with corresponding server support as determined by the community.

- https://projects.eclipse.org/projects/iot.paho

Terms of Use:
-------------

This repository is subject to the Terms of Use of the Eclipse Foundation

- https://www.eclipse.org/legal/termsofuse.php

Developer Resources:
--------------------

Github repositories maintained by the project

- https://projects.eclipse.org/projects/iot.paho/developer

Eclipse Development Process:
----------------------------

This Eclipse Foundation open project is governed by the Eclipse Foundation Development Process and operates under the terms of the Eclipse IP Policy.

- https://www.eclipse.org/projects/dev_process
- https://www.eclipse.org/org/documents/Eclipse_IP_Policy.pdf

Eclipse Contributor Agreement:
------------------------------

In order to be able to contribute to Eclipse Foundation projects you must electronically sign the Eclipse Contributor Agreement (ECA).

- https://www.eclipse.org/legal/ECA.php

The ECA provides the Eclipse Foundation with a permanent record that you agree that each of your contributions will comply with the commitments documented in the Developer Certificate of Origin (DCO). Having an ECA on file associated with the email address matching the "Author" field of your contribution's Git commits fulfills the DCO's requirement that you sign-off on your contributions.

For more information, please see the Eclipse Committer Handbook:\
https://www.eclipse.org/projects/handbook/#resources-commit

Contributing Code:
------------------

The Go client is developed in Github, see their documentation on the process of forking and pull requests\
https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/getting-started/about-collaborative-development-models

Git commit messages should follow the style described here\
http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html

Contact:
--------

Contact the project developers via the project's "dev" list.

- https://accounts.eclipse.org/mailing-list/paho-dev

Search for Bugs:
----------------

This project uses Github issues to track ongoing development and issues.

- https://github.com/eclipse/paho.golang/issues

Create a New Bug:
-----------------

Be sure to search for existing bugs before you create another one. Remember that contributions are always welcome!

- https://github.com/eclipse/paho.golang/issues
