package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ShowPageNoticesResponse Response Object
type ShowPageNoticesResponse struct {

	// **参数解释**: 总数 **取值范围**: 最小值0，最大值2147483647
	TotalNum *int32 `json:"total_num,omitempty"`

	// **参数解释**: 页面通知列表 **取值范围**: 最小值0，最大值200
	DataList       *[]ShowPageNoticesInfo `json:"data_list,omitempty"`
	HttpStatusCode int                    `json:"-"`
}

func (o ShowPageNoticesResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ShowPageNoticesResponse struct{}"
	}

	return strings.Join([]string{"ShowPageNoticesResponse", string(data)}, " ")
}
