package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/sdktime"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type MalwareProperties struct {

	// 进程ID。
	Pid *string `json:"pid,omitempty"`

	// 系统角色（例如:root，service）。
	User *string `json:"user,omitempty"`

	// 系统权限（例如：777，755）。
	Mod *string `json:"mod,omitempty"`

	// 进程启动时间，格式ISO8601：YYYY-MM-DDTHH:mm:ss.ms+timezone。
	StartTime *sdktime.SdkTime `json:"start_time,omitempty"`
}

func (o MalwareProperties) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "MalwareProperties struct{}"
	}

	return strings.Join([]string{"MalwareProperties", string(data)}, " ")
}
