package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// InstanceFailDetail 失败描述。  cluster_deleted,        // 集群被删除  cluster_unavailable,    // 集群不可用  cluster_inaccessible,   // 集群无法访问  namespace_deleted,      // 命名空间被删除  namespace_unavailable,  // 命名空间不可用  namespace_inaccessible, // 命名空间无法访问  resource_deleted,       // 资源已删除
type InstanceFailDetail struct {
	value string
}

type InstanceFailDetailEnum struct {
	CLUSTER_DELETED        InstanceFailDetail
	CLUSTER_UNAVAILABLE    InstanceFailDetail
	CLUSTER_INACCESSIBLE   InstanceFailDetail
	NAMESPACE_DELETED      InstanceFailDetail
	NAMESPACE_UNAVAILABLE  InstanceFailDetail
	NAMESPACE_INACCESSIBLE InstanceFailDetail
	RESOURCE_DELETED       InstanceFailDetail
}

func GetInstanceFailDetailEnum() InstanceFailDetailEnum {
	return InstanceFailDetailEnum{
		CLUSTER_DELETED: InstanceFailDetail{
			value: "cluster_deleted",
		},
		CLUSTER_UNAVAILABLE: InstanceFailDetail{
			value: "cluster_unavailable",
		},
		CLUSTER_INACCESSIBLE: InstanceFailDetail{
			value: "cluster_inaccessible",
		},
		NAMESPACE_DELETED: InstanceFailDetail{
			value: "namespace_deleted",
		},
		NAMESPACE_UNAVAILABLE: InstanceFailDetail{
			value: "namespace_unavailable",
		},
		NAMESPACE_INACCESSIBLE: InstanceFailDetail{
			value: "namespace_inaccessible",
		},
		RESOURCE_DELETED: InstanceFailDetail{
			value: "resource_deleted",
		},
	}
}

func (c InstanceFailDetail) Value() string {
	return c.value
}

func (c InstanceFailDetail) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *InstanceFailDetail) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
