package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityPreferredCvss 基于CVSS3和CVSS2的漏洞项评分及攻击向量
type VulnerabilityPreferredCvss struct {

	// 漏洞的CVSS-3评分
	ScoreV3 float32 `json:"score_v3,omitempty"`

	// 漏洞的CVSS-2评分
	ScoreV2 float32 `json:"score_v2,omitempty"`

	// 漏洞的CVSS-3攻击向量
	VectorV3 *string `json:"vector_v3,omitempty"`

	// 漏洞的CVSS-2攻击向量
	VectorV2 *string `json:"vector_v2,omitempty"`
}

func (o VulnerabilityPreferredCvss) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityPreferredCvss struct{}"
	}

	return strings.Join([]string{"VulnerabilityPreferredCvss", string(data)}, " ")
}
