package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// FailedTasks 失败的任务详细信息。
type FailedTasks struct {

	// 虚拟机ID
	TaskId *string `json:"task_id,omitempty"`

	// 任务的操作类型。 - FAILED_RESET 重置 - FAILED_REPLACE 替换 - FAILED_UNBIND 解绑
	OperateType *FailedTasksOperateType `json:"operate_type,omitempty"`

	// 任务时间
	TaskTime *string `json:"task_time,omitempty"`

	// 任务失败错误码
	TaskErrorCode *string `json:"task_error_code,omitempty"`

	// 任务失败错误码
	TaskErrorMsg *string `json:"task_error_msg,omitempty"`

	// 虚拟机名称
	ServerName *string `json:"server_name,omitempty"`

	// 虚拟机ID
	ServerId *string `json:"server_id,omitempty"`

	// 密钥对名称
	KeypairName *string `json:"keypair_name,omitempty"`
}

func (o FailedTasks) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "FailedTasks struct{}"
	}

	return strings.Join([]string{"FailedTasks", string(data)}, " ")
}

type FailedTasksOperateType struct {
	value string
}

type FailedTasksOperateTypeEnum struct {
	FAILED_RESET   FailedTasksOperateType
	FAILED_REPLACE FailedTasksOperateType
	FAILED_UNBIND  FailedTasksOperateType
}

func GetFailedTasksOperateTypeEnum() FailedTasksOperateTypeEnum {
	return FailedTasksOperateTypeEnum{
		FAILED_RESET: FailedTasksOperateType{
			value: "FAILED_RESET",
		},
		FAILED_REPLACE: FailedTasksOperateType{
			value: "FAILED_REPLACE",
		},
		FAILED_UNBIND: FailedTasksOperateType{
			value: "FAILED_UNBIND",
		},
	}
}

func (c FailedTasksOperateType) Value() string {
	return c.value
}

func (c FailedTasksOperateType) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *FailedTasksOperateType) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
