// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-stub'; DO NOT EDIT

package stub

import (
	"context"
	"log"

	"github.com/sacloud/iaas-api-go"
	"github.com/sacloud/iaas-api-go/types"
)

/*************************************************
* ArchiveStub
*************************************************/

// ArchiveFindStubResult is expected values of the Find operation
type ArchiveFindStubResult struct {
	Values *iaas.ArchiveFindResult
	Err    error
}

// ArchiveCreateStubResult is expected values of the Create operation
type ArchiveCreateStubResult struct {
	Archive *iaas.Archive
	Err     error
}

// ArchiveCreateBlankStubResult is expected values of the CreateBlank operation
type ArchiveCreateBlankStubResult struct {
	Archive   *iaas.Archive
	FTPServer *iaas.FTPServer
	Err       error
}

// ArchiveReadStubResult is expected values of the Read operation
type ArchiveReadStubResult struct {
	Archive *iaas.Archive
	Err     error
}

// ArchiveUpdateStubResult is expected values of the Update operation
type ArchiveUpdateStubResult struct {
	Archive *iaas.Archive
	Err     error
}

// ArchiveDeleteStubResult is expected values of the Delete operation
type ArchiveDeleteStubResult struct {
	Err error
}

// ArchiveOpenFTPStubResult is expected values of the OpenFTP operation
type ArchiveOpenFTPStubResult struct {
	FTPServer *iaas.FTPServer
	Err       error
}

// ArchiveCloseFTPStubResult is expected values of the CloseFTP operation
type ArchiveCloseFTPStubResult struct {
	Err error
}

// ArchiveShareStubResult is expected values of the Share operation
type ArchiveShareStubResult struct {
	ArchiveShareInfo *iaas.ArchiveShareInfo
	Err              error
}

// ArchiveCreateFromSharedStubResult is expected values of the CreateFromShared operation
type ArchiveCreateFromSharedStubResult struct {
	Archive *iaas.Archive
	Err     error
}

// ArchiveTransferStubResult is expected values of the Transfer operation
type ArchiveTransferStubResult struct {
	Archive *iaas.Archive
	Err     error
}

// ArchiveStub is for trace ArchiveOp operations
type ArchiveStub struct {
	FindStubResult             *ArchiveFindStubResult
	CreateStubResult           *ArchiveCreateStubResult
	CreateBlankStubResult      *ArchiveCreateBlankStubResult
	ReadStubResult             *ArchiveReadStubResult
	UpdateStubResult           *ArchiveUpdateStubResult
	DeleteStubResult           *ArchiveDeleteStubResult
	OpenFTPStubResult          *ArchiveOpenFTPStubResult
	CloseFTPStubResult         *ArchiveCloseFTPStubResult
	ShareStubResult            *ArchiveShareStubResult
	CreateFromSharedStubResult *ArchiveCreateFromSharedStubResult
	TransferStubResult         *ArchiveTransferStubResult
}

// NewArchiveStub creates new ArchiveStub instance
func NewArchiveStub(caller iaas.APICaller) iaas.ArchiveAPI {
	return &ArchiveStub{}
}

// Find is API call with trace log
func (s *ArchiveStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ArchiveFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ArchiveStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *ArchiveStub) Create(ctx context.Context, zone string, param *iaas.ArchiveCreateRequest) (*iaas.Archive, error) {
	if s.CreateStubResult == nil {
		log.Fatal("ArchiveStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Archive, s.CreateStubResult.Err
}

// CreateBlank is API call with trace log
func (s *ArchiveStub) CreateBlank(ctx context.Context, zone string, param *iaas.ArchiveCreateBlankRequest) (*iaas.Archive, *iaas.FTPServer, error) {
	if s.CreateBlankStubResult == nil {
		log.Fatal("ArchiveStub.CreateBlankStubResult is not set")
	}
	return s.CreateBlankStubResult.Archive, s.CreateBlankStubResult.FTPServer, s.CreateBlankStubResult.Err
}

// Read is API call with trace log
func (s *ArchiveStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Archive, error) {
	if s.ReadStubResult == nil {
		log.Fatal("ArchiveStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Archive, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *ArchiveStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.ArchiveUpdateRequest) (*iaas.Archive, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("ArchiveStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Archive, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *ArchiveStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("ArchiveStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// OpenFTP is API call with trace log
func (s *ArchiveStub) OpenFTP(ctx context.Context, zone string, id types.ID, openOption *iaas.OpenFTPRequest) (*iaas.FTPServer, error) {
	if s.OpenFTPStubResult == nil {
		log.Fatal("ArchiveStub.OpenFTPStubResult is not set")
	}
	return s.OpenFTPStubResult.FTPServer, s.OpenFTPStubResult.Err
}

// CloseFTP is API call with trace log
func (s *ArchiveStub) CloseFTP(ctx context.Context, zone string, id types.ID) error {
	if s.CloseFTPStubResult == nil {
		log.Fatal("ArchiveStub.CloseFTPStubResult is not set")
	}
	return s.CloseFTPStubResult.Err
}

// Share is API call with trace log
func (s *ArchiveStub) Share(ctx context.Context, zone string, id types.ID) (*iaas.ArchiveShareInfo, error) {
	if s.ShareStubResult == nil {
		log.Fatal("ArchiveStub.ShareStubResult is not set")
	}
	return s.ShareStubResult.ArchiveShareInfo, s.ShareStubResult.Err
}

// CreateFromShared is API call with trace log
func (s *ArchiveStub) CreateFromShared(ctx context.Context, zone string, sourceArchiveID types.ID, destZoneID types.ID, param *iaas.ArchiveCreateRequestFromShared) (*iaas.Archive, error) {
	if s.CreateFromSharedStubResult == nil {
		log.Fatal("ArchiveStub.CreateFromSharedStubResult is not set")
	}
	return s.CreateFromSharedStubResult.Archive, s.CreateFromSharedStubResult.Err
}

// Transfer is API call with trace log
func (s *ArchiveStub) Transfer(ctx context.Context, zone string, sourceArchiveID types.ID, destZoneID types.ID, param *iaas.ArchiveTransferRequest) (*iaas.Archive, error) {
	if s.TransferStubResult == nil {
		log.Fatal("ArchiveStub.TransferStubResult is not set")
	}
	return s.TransferStubResult.Archive, s.TransferStubResult.Err
}

/*************************************************
* AuthStatusStub
*************************************************/

// AuthStatusReadStubResult is expected values of the Read operation
type AuthStatusReadStubResult struct {
	AuthStatus *iaas.AuthStatus
	Err        error
}

// AuthStatusStub is for trace AuthStatusOp operations
type AuthStatusStub struct {
	ReadStubResult *AuthStatusReadStubResult
}

// NewAuthStatusStub creates new AuthStatusStub instance
func NewAuthStatusStub(caller iaas.APICaller) iaas.AuthStatusAPI {
	return &AuthStatusStub{}
}

// Read is API call with trace log
func (s *AuthStatusStub) Read(ctx context.Context) (*iaas.AuthStatus, error) {
	if s.ReadStubResult == nil {
		log.Fatal("AuthStatusStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.AuthStatus, s.ReadStubResult.Err
}

/*************************************************
* AutoBackupStub
*************************************************/

// AutoBackupFindStubResult is expected values of the Find operation
type AutoBackupFindStubResult struct {
	Values *iaas.AutoBackupFindResult
	Err    error
}

// AutoBackupCreateStubResult is expected values of the Create operation
type AutoBackupCreateStubResult struct {
	AutoBackup *iaas.AutoBackup
	Err        error
}

// AutoBackupReadStubResult is expected values of the Read operation
type AutoBackupReadStubResult struct {
	AutoBackup *iaas.AutoBackup
	Err        error
}

// AutoBackupUpdateStubResult is expected values of the Update operation
type AutoBackupUpdateStubResult struct {
	AutoBackup *iaas.AutoBackup
	Err        error
}

// AutoBackupUpdateSettingsStubResult is expected values of the UpdateSettings operation
type AutoBackupUpdateSettingsStubResult struct {
	AutoBackup *iaas.AutoBackup
	Err        error
}

// AutoBackupDeleteStubResult is expected values of the Delete operation
type AutoBackupDeleteStubResult struct {
	Err error
}

// AutoBackupStub is for trace AutoBackupOp operations
type AutoBackupStub struct {
	FindStubResult           *AutoBackupFindStubResult
	CreateStubResult         *AutoBackupCreateStubResult
	ReadStubResult           *AutoBackupReadStubResult
	UpdateStubResult         *AutoBackupUpdateStubResult
	UpdateSettingsStubResult *AutoBackupUpdateSettingsStubResult
	DeleteStubResult         *AutoBackupDeleteStubResult
}

// NewAutoBackupStub creates new AutoBackupStub instance
func NewAutoBackupStub(caller iaas.APICaller) iaas.AutoBackupAPI {
	return &AutoBackupStub{}
}

// Find is API call with trace log
func (s *AutoBackupStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.AutoBackupFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("AutoBackupStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *AutoBackupStub) Create(ctx context.Context, zone string, param *iaas.AutoBackupCreateRequest) (*iaas.AutoBackup, error) {
	if s.CreateStubResult == nil {
		log.Fatal("AutoBackupStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.AutoBackup, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *AutoBackupStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.AutoBackup, error) {
	if s.ReadStubResult == nil {
		log.Fatal("AutoBackupStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.AutoBackup, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *AutoBackupStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.AutoBackupUpdateRequest) (*iaas.AutoBackup, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("AutoBackupStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.AutoBackup, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *AutoBackupStub) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.AutoBackupUpdateSettingsRequest) (*iaas.AutoBackup, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("AutoBackupStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.AutoBackup, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *AutoBackupStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("AutoBackupStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* AutoScaleStub
*************************************************/

// AutoScaleFindStubResult is expected values of the Find operation
type AutoScaleFindStubResult struct {
	Values *iaas.AutoScaleFindResult
	Err    error
}

// AutoScaleCreateStubResult is expected values of the Create operation
type AutoScaleCreateStubResult struct {
	AutoScale *iaas.AutoScale
	Err       error
}

// AutoScaleReadStubResult is expected values of the Read operation
type AutoScaleReadStubResult struct {
	AutoScale *iaas.AutoScale
	Err       error
}

// AutoScaleUpdateStubResult is expected values of the Update operation
type AutoScaleUpdateStubResult struct {
	AutoScale *iaas.AutoScale
	Err       error
}

// AutoScaleUpdateSettingsStubResult is expected values of the UpdateSettings operation
type AutoScaleUpdateSettingsStubResult struct {
	AutoScale *iaas.AutoScale
	Err       error
}

// AutoScaleDeleteStubResult is expected values of the Delete operation
type AutoScaleDeleteStubResult struct {
	Err error
}

// AutoScaleStatusStubResult is expected values of the Status operation
type AutoScaleStatusStubResult struct {
	AutoScaleStatus *iaas.AutoScaleStatus
	Err             error
}

// AutoScaleScaleUpStubResult is expected values of the ScaleUp operation
type AutoScaleScaleUpStubResult struct {
	Err error
}

// AutoScaleScaleDownStubResult is expected values of the ScaleDown operation
type AutoScaleScaleDownStubResult struct {
	Err error
}

// AutoScaleStub is for trace AutoScaleOp operations
type AutoScaleStub struct {
	FindStubResult           *AutoScaleFindStubResult
	CreateStubResult         *AutoScaleCreateStubResult
	ReadStubResult           *AutoScaleReadStubResult
	UpdateStubResult         *AutoScaleUpdateStubResult
	UpdateSettingsStubResult *AutoScaleUpdateSettingsStubResult
	DeleteStubResult         *AutoScaleDeleteStubResult
	StatusStubResult         *AutoScaleStatusStubResult
	ScaleUpStubResult        *AutoScaleScaleUpStubResult
	ScaleDownStubResult      *AutoScaleScaleDownStubResult
}

// NewAutoScaleStub creates new AutoScaleStub instance
func NewAutoScaleStub(caller iaas.APICaller) iaas.AutoScaleAPI {
	return &AutoScaleStub{}
}

// Find is API call with trace log
func (s *AutoScaleStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.AutoScaleFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("AutoScaleStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *AutoScaleStub) Create(ctx context.Context, param *iaas.AutoScaleCreateRequest) (*iaas.AutoScale, error) {
	if s.CreateStubResult == nil {
		log.Fatal("AutoScaleStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.AutoScale, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *AutoScaleStub) Read(ctx context.Context, id types.ID) (*iaas.AutoScale, error) {
	if s.ReadStubResult == nil {
		log.Fatal("AutoScaleStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.AutoScale, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *AutoScaleStub) Update(ctx context.Context, id types.ID, param *iaas.AutoScaleUpdateRequest) (*iaas.AutoScale, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("AutoScaleStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.AutoScale, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *AutoScaleStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.AutoScaleUpdateSettingsRequest) (*iaas.AutoScale, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("AutoScaleStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.AutoScale, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *AutoScaleStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("AutoScaleStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Status is API call with trace log
func (s *AutoScaleStub) Status(ctx context.Context, id types.ID) (*iaas.AutoScaleStatus, error) {
	if s.StatusStubResult == nil {
		log.Fatal("AutoScaleStub.StatusStubResult is not set")
	}
	return s.StatusStubResult.AutoScaleStatus, s.StatusStubResult.Err
}

// ScaleUp is API call with trace log
func (s *AutoScaleStub) ScaleUp(ctx context.Context, id types.ID) error {
	if s.ScaleUpStubResult == nil {
		log.Fatal("AutoScaleStub.ScaleUpStubResult is not set")
	}
	return s.ScaleUpStubResult.Err
}

// ScaleDown is API call with trace log
func (s *AutoScaleStub) ScaleDown(ctx context.Context, id types.ID) error {
	if s.ScaleDownStubResult == nil {
		log.Fatal("AutoScaleStub.ScaleDownStubResult is not set")
	}
	return s.ScaleDownStubResult.Err
}

/*************************************************
* BillStub
*************************************************/

// BillByContractStubResult is expected values of the ByContract operation
type BillByContractStubResult struct {
	Values *iaas.BillByContractResult
	Err    error
}

// BillByContractYearStubResult is expected values of the ByContractYear operation
type BillByContractYearStubResult struct {
	Values *iaas.BillByContractYearResult
	Err    error
}

// BillByContractYearMonthStubResult is expected values of the ByContractYearMonth operation
type BillByContractYearMonthStubResult struct {
	Values *iaas.BillByContractYearMonthResult
	Err    error
}

// BillReadStubResult is expected values of the Read operation
type BillReadStubResult struct {
	Values *iaas.BillReadResult
	Err    error
}

// BillDetailsStubResult is expected values of the Details operation
type BillDetailsStubResult struct {
	Values *iaas.BillDetailsResult
	Err    error
}

// BillDetailsCSVStubResult is expected values of the DetailsCSV operation
type BillDetailsCSVStubResult struct {
	BillDetailCSV *iaas.BillDetailCSV
	Err           error
}

// BillStub is for trace BillOp operations
type BillStub struct {
	ByContractStubResult          *BillByContractStubResult
	ByContractYearStubResult      *BillByContractYearStubResult
	ByContractYearMonthStubResult *BillByContractYearMonthStubResult
	ReadStubResult                *BillReadStubResult
	DetailsStubResult             *BillDetailsStubResult
	DetailsCSVStubResult          *BillDetailsCSVStubResult
}

// NewBillStub creates new BillStub instance
func NewBillStub(caller iaas.APICaller) iaas.BillAPI {
	return &BillStub{}
}

// ByContract is API call with trace log
func (s *BillStub) ByContract(ctx context.Context, accountID types.ID) (*iaas.BillByContractResult, error) {
	if s.ByContractStubResult == nil {
		log.Fatal("BillStub.ByContractStubResult is not set")
	}
	return s.ByContractStubResult.Values, s.ByContractStubResult.Err
}

// ByContractYear is API call with trace log
func (s *BillStub) ByContractYear(ctx context.Context, accountID types.ID, year int) (*iaas.BillByContractYearResult, error) {
	if s.ByContractYearStubResult == nil {
		log.Fatal("BillStub.ByContractYearStubResult is not set")
	}
	return s.ByContractYearStubResult.Values, s.ByContractYearStubResult.Err
}

// ByContractYearMonth is API call with trace log
func (s *BillStub) ByContractYearMonth(ctx context.Context, accountID types.ID, year int, month int) (*iaas.BillByContractYearMonthResult, error) {
	if s.ByContractYearMonthStubResult == nil {
		log.Fatal("BillStub.ByContractYearMonthStubResult is not set")
	}
	return s.ByContractYearMonthStubResult.Values, s.ByContractYearMonthStubResult.Err
}

// Read is API call with trace log
func (s *BillStub) Read(ctx context.Context, id types.ID) (*iaas.BillReadResult, error) {
	if s.ReadStubResult == nil {
		log.Fatal("BillStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Values, s.ReadStubResult.Err
}

// Details is API call with trace log
func (s *BillStub) Details(ctx context.Context, MemberCode string, id types.ID) (*iaas.BillDetailsResult, error) {
	if s.DetailsStubResult == nil {
		log.Fatal("BillStub.DetailsStubResult is not set")
	}
	return s.DetailsStubResult.Values, s.DetailsStubResult.Err
}

// DetailsCSV is API call with trace log
func (s *BillStub) DetailsCSV(ctx context.Context, MemberCode string, id types.ID) (*iaas.BillDetailCSV, error) {
	if s.DetailsCSVStubResult == nil {
		log.Fatal("BillStub.DetailsCSVStubResult is not set")
	}
	return s.DetailsCSVStubResult.BillDetailCSV, s.DetailsCSVStubResult.Err
}

/*************************************************
* BridgeStub
*************************************************/

// BridgeFindStubResult is expected values of the Find operation
type BridgeFindStubResult struct {
	Values *iaas.BridgeFindResult
	Err    error
}

// BridgeCreateStubResult is expected values of the Create operation
type BridgeCreateStubResult struct {
	Bridge *iaas.Bridge
	Err    error
}

// BridgeReadStubResult is expected values of the Read operation
type BridgeReadStubResult struct {
	Bridge *iaas.Bridge
	Err    error
}

// BridgeUpdateStubResult is expected values of the Update operation
type BridgeUpdateStubResult struct {
	Bridge *iaas.Bridge
	Err    error
}

// BridgeDeleteStubResult is expected values of the Delete operation
type BridgeDeleteStubResult struct {
	Err error
}

// BridgeStub is for trace BridgeOp operations
type BridgeStub struct {
	FindStubResult   *BridgeFindStubResult
	CreateStubResult *BridgeCreateStubResult
	ReadStubResult   *BridgeReadStubResult
	UpdateStubResult *BridgeUpdateStubResult
	DeleteStubResult *BridgeDeleteStubResult
}

// NewBridgeStub creates new BridgeStub instance
func NewBridgeStub(caller iaas.APICaller) iaas.BridgeAPI {
	return &BridgeStub{}
}

// Find is API call with trace log
func (s *BridgeStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.BridgeFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("BridgeStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *BridgeStub) Create(ctx context.Context, zone string, param *iaas.BridgeCreateRequest) (*iaas.Bridge, error) {
	if s.CreateStubResult == nil {
		log.Fatal("BridgeStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Bridge, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *BridgeStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Bridge, error) {
	if s.ReadStubResult == nil {
		log.Fatal("BridgeStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Bridge, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *BridgeStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.BridgeUpdateRequest) (*iaas.Bridge, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("BridgeStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Bridge, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *BridgeStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("BridgeStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* CDROMStub
*************************************************/

// CDROMFindStubResult is expected values of the Find operation
type CDROMFindStubResult struct {
	Values *iaas.CDROMFindResult
	Err    error
}

// CDROMCreateStubResult is expected values of the Create operation
type CDROMCreateStubResult struct {
	CDROM     *iaas.CDROM
	FTPServer *iaas.FTPServer
	Err       error
}

// CDROMReadStubResult is expected values of the Read operation
type CDROMReadStubResult struct {
	CDROM *iaas.CDROM
	Err   error
}

// CDROMUpdateStubResult is expected values of the Update operation
type CDROMUpdateStubResult struct {
	CDROM *iaas.CDROM
	Err   error
}

// CDROMDeleteStubResult is expected values of the Delete operation
type CDROMDeleteStubResult struct {
	Err error
}

// CDROMOpenFTPStubResult is expected values of the OpenFTP operation
type CDROMOpenFTPStubResult struct {
	FTPServer *iaas.FTPServer
	Err       error
}

// CDROMCloseFTPStubResult is expected values of the CloseFTP operation
type CDROMCloseFTPStubResult struct {
	Err error
}

// CDROMStub is for trace CDROMOp operations
type CDROMStub struct {
	FindStubResult     *CDROMFindStubResult
	CreateStubResult   *CDROMCreateStubResult
	ReadStubResult     *CDROMReadStubResult
	UpdateStubResult   *CDROMUpdateStubResult
	DeleteStubResult   *CDROMDeleteStubResult
	OpenFTPStubResult  *CDROMOpenFTPStubResult
	CloseFTPStubResult *CDROMCloseFTPStubResult
}

// NewCDROMStub creates new CDROMStub instance
func NewCDROMStub(caller iaas.APICaller) iaas.CDROMAPI {
	return &CDROMStub{}
}

// Find is API call with trace log
func (s *CDROMStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.CDROMFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("CDROMStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *CDROMStub) Create(ctx context.Context, zone string, param *iaas.CDROMCreateRequest) (*iaas.CDROM, *iaas.FTPServer, error) {
	if s.CreateStubResult == nil {
		log.Fatal("CDROMStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.CDROM, s.CreateStubResult.FTPServer, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *CDROMStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.CDROM, error) {
	if s.ReadStubResult == nil {
		log.Fatal("CDROMStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.CDROM, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *CDROMStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.CDROMUpdateRequest) (*iaas.CDROM, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("CDROMStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.CDROM, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *CDROMStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("CDROMStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// OpenFTP is API call with trace log
func (s *CDROMStub) OpenFTP(ctx context.Context, zone string, id types.ID, openOption *iaas.OpenFTPRequest) (*iaas.FTPServer, error) {
	if s.OpenFTPStubResult == nil {
		log.Fatal("CDROMStub.OpenFTPStubResult is not set")
	}
	return s.OpenFTPStubResult.FTPServer, s.OpenFTPStubResult.Err
}

// CloseFTP is API call with trace log
func (s *CDROMStub) CloseFTP(ctx context.Context, zone string, id types.ID) error {
	if s.CloseFTPStubResult == nil {
		log.Fatal("CDROMStub.CloseFTPStubResult is not set")
	}
	return s.CloseFTPStubResult.Err
}

/*************************************************
* CertificateAuthorityStub
*************************************************/

// CertificateAuthorityFindStubResult is expected values of the Find operation
type CertificateAuthorityFindStubResult struct {
	Values *iaas.CertificateAuthorityFindResult
	Err    error
}

// CertificateAuthorityCreateStubResult is expected values of the Create operation
type CertificateAuthorityCreateStubResult struct {
	CertificateAuthority *iaas.CertificateAuthority
	Err                  error
}

// CertificateAuthorityReadStubResult is expected values of the Read operation
type CertificateAuthorityReadStubResult struct {
	CertificateAuthority *iaas.CertificateAuthority
	Err                  error
}

// CertificateAuthorityUpdateStubResult is expected values of the Update operation
type CertificateAuthorityUpdateStubResult struct {
	CertificateAuthority *iaas.CertificateAuthority
	Err                  error
}

// CertificateAuthorityDeleteStubResult is expected values of the Delete operation
type CertificateAuthorityDeleteStubResult struct {
	Err error
}

// CertificateAuthorityDetailStubResult is expected values of the Detail operation
type CertificateAuthorityDetailStubResult struct {
	CertificateAuthority *iaas.CertificateAuthorityDetail
	Err                  error
}

// CertificateAuthorityAddClientStubResult is expected values of the AddClient operation
type CertificateAuthorityAddClientStubResult struct {
	CertificateAuthority *iaas.CertificateAuthorityAddClientOrServerResult
	Err                  error
}

// CertificateAuthorityListClientsStubResult is expected values of the ListClients operation
type CertificateAuthorityListClientsStubResult struct {
	Values *iaas.CertificateAuthorityListClientsResult
	Err    error
}

// CertificateAuthorityReadClientStubResult is expected values of the ReadClient operation
type CertificateAuthorityReadClientStubResult struct {
	CertificateAuthority *iaas.CertificateAuthorityClient
	Err                  error
}

// CertificateAuthorityRevokeClientStubResult is expected values of the RevokeClient operation
type CertificateAuthorityRevokeClientStubResult struct {
	Err error
}

// CertificateAuthorityHoldClientStubResult is expected values of the HoldClient operation
type CertificateAuthorityHoldClientStubResult struct {
	Err error
}

// CertificateAuthorityResumeClientStubResult is expected values of the ResumeClient operation
type CertificateAuthorityResumeClientStubResult struct {
	Err error
}

// CertificateAuthorityDenyClientStubResult is expected values of the DenyClient operation
type CertificateAuthorityDenyClientStubResult struct {
	Err error
}

// CertificateAuthorityAddServerStubResult is expected values of the AddServer operation
type CertificateAuthorityAddServerStubResult struct {
	CertificateAuthority *iaas.CertificateAuthorityAddClientOrServerResult
	Err                  error
}

// CertificateAuthorityListServersStubResult is expected values of the ListServers operation
type CertificateAuthorityListServersStubResult struct {
	Values *iaas.CertificateAuthorityListServersResult
	Err    error
}

// CertificateAuthorityReadServerStubResult is expected values of the ReadServer operation
type CertificateAuthorityReadServerStubResult struct {
	CertificateAuthority *iaas.CertificateAuthorityServer
	Err                  error
}

// CertificateAuthorityRevokeServerStubResult is expected values of the RevokeServer operation
type CertificateAuthorityRevokeServerStubResult struct {
	Err error
}

// CertificateAuthorityHoldServerStubResult is expected values of the HoldServer operation
type CertificateAuthorityHoldServerStubResult struct {
	Err error
}

// CertificateAuthorityResumeServerStubResult is expected values of the ResumeServer operation
type CertificateAuthorityResumeServerStubResult struct {
	Err error
}

// CertificateAuthorityStub is for trace CertificateAuthorityOp operations
type CertificateAuthorityStub struct {
	FindStubResult         *CertificateAuthorityFindStubResult
	CreateStubResult       *CertificateAuthorityCreateStubResult
	ReadStubResult         *CertificateAuthorityReadStubResult
	UpdateStubResult       *CertificateAuthorityUpdateStubResult
	DeleteStubResult       *CertificateAuthorityDeleteStubResult
	DetailStubResult       *CertificateAuthorityDetailStubResult
	AddClientStubResult    *CertificateAuthorityAddClientStubResult
	ListClientsStubResult  *CertificateAuthorityListClientsStubResult
	ReadClientStubResult   *CertificateAuthorityReadClientStubResult
	RevokeClientStubResult *CertificateAuthorityRevokeClientStubResult
	HoldClientStubResult   *CertificateAuthorityHoldClientStubResult
	ResumeClientStubResult *CertificateAuthorityResumeClientStubResult
	DenyClientStubResult   *CertificateAuthorityDenyClientStubResult
	AddServerStubResult    *CertificateAuthorityAddServerStubResult
	ListServersStubResult  *CertificateAuthorityListServersStubResult
	ReadServerStubResult   *CertificateAuthorityReadServerStubResult
	RevokeServerStubResult *CertificateAuthorityRevokeServerStubResult
	HoldServerStubResult   *CertificateAuthorityHoldServerStubResult
	ResumeServerStubResult *CertificateAuthorityResumeServerStubResult
}

// NewCertificateAuthorityStub creates new CertificateAuthorityStub instance
func NewCertificateAuthorityStub(caller iaas.APICaller) iaas.CertificateAuthorityAPI {
	return &CertificateAuthorityStub{}
}

// Find is API call with trace log
func (s *CertificateAuthorityStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.CertificateAuthorityFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("CertificateAuthorityStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *CertificateAuthorityStub) Create(ctx context.Context, param *iaas.CertificateAuthorityCreateRequest) (*iaas.CertificateAuthority, error) {
	if s.CreateStubResult == nil {
		log.Fatal("CertificateAuthorityStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.CertificateAuthority, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *CertificateAuthorityStub) Read(ctx context.Context, id types.ID) (*iaas.CertificateAuthority, error) {
	if s.ReadStubResult == nil {
		log.Fatal("CertificateAuthorityStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.CertificateAuthority, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *CertificateAuthorityStub) Update(ctx context.Context, id types.ID, param *iaas.CertificateAuthorityUpdateRequest) (*iaas.CertificateAuthority, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("CertificateAuthorityStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.CertificateAuthority, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *CertificateAuthorityStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("CertificateAuthorityStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Detail is API call with trace log
func (s *CertificateAuthorityStub) Detail(ctx context.Context, id types.ID) (*iaas.CertificateAuthorityDetail, error) {
	if s.DetailStubResult == nil {
		log.Fatal("CertificateAuthorityStub.DetailStubResult is not set")
	}
	return s.DetailStubResult.CertificateAuthority, s.DetailStubResult.Err
}

// AddClient is API call with trace log
func (s *CertificateAuthorityStub) AddClient(ctx context.Context, id types.ID, param *iaas.CertificateAuthorityAddClientParam) (*iaas.CertificateAuthorityAddClientOrServerResult, error) {
	if s.AddClientStubResult == nil {
		log.Fatal("CertificateAuthorityStub.AddClientStubResult is not set")
	}
	return s.AddClientStubResult.CertificateAuthority, s.AddClientStubResult.Err
}

// ListClients is API call with trace log
func (s *CertificateAuthorityStub) ListClients(ctx context.Context, id types.ID) (*iaas.CertificateAuthorityListClientsResult, error) {
	if s.ListClientsStubResult == nil {
		log.Fatal("CertificateAuthorityStub.ListClientsStubResult is not set")
	}
	return s.ListClientsStubResult.Values, s.ListClientsStubResult.Err
}

// ReadClient is API call with trace log
func (s *CertificateAuthorityStub) ReadClient(ctx context.Context, id types.ID, clientID string) (*iaas.CertificateAuthorityClient, error) {
	if s.ReadClientStubResult == nil {
		log.Fatal("CertificateAuthorityStub.ReadClientStubResult is not set")
	}
	return s.ReadClientStubResult.CertificateAuthority, s.ReadClientStubResult.Err
}

// RevokeClient is API call with trace log
func (s *CertificateAuthorityStub) RevokeClient(ctx context.Context, id types.ID, clientID string) error {
	if s.RevokeClientStubResult == nil {
		log.Fatal("CertificateAuthorityStub.RevokeClientStubResult is not set")
	}
	return s.RevokeClientStubResult.Err
}

// HoldClient is API call with trace log
func (s *CertificateAuthorityStub) HoldClient(ctx context.Context, id types.ID, clientID string) error {
	if s.HoldClientStubResult == nil {
		log.Fatal("CertificateAuthorityStub.HoldClientStubResult is not set")
	}
	return s.HoldClientStubResult.Err
}

// ResumeClient is API call with trace log
func (s *CertificateAuthorityStub) ResumeClient(ctx context.Context, id types.ID, clientID string) error {
	if s.ResumeClientStubResult == nil {
		log.Fatal("CertificateAuthorityStub.ResumeClientStubResult is not set")
	}
	return s.ResumeClientStubResult.Err
}

// DenyClient is API call with trace log
func (s *CertificateAuthorityStub) DenyClient(ctx context.Context, id types.ID, clientID string) error {
	if s.DenyClientStubResult == nil {
		log.Fatal("CertificateAuthorityStub.DenyClientStubResult is not set")
	}
	return s.DenyClientStubResult.Err
}

// AddServer is API call with trace log
func (s *CertificateAuthorityStub) AddServer(ctx context.Context, id types.ID, param *iaas.CertificateAuthorityAddServerParam) (*iaas.CertificateAuthorityAddClientOrServerResult, error) {
	if s.AddServerStubResult == nil {
		log.Fatal("CertificateAuthorityStub.AddServerStubResult is not set")
	}
	return s.AddServerStubResult.CertificateAuthority, s.AddServerStubResult.Err
}

// ListServers is API call with trace log
func (s *CertificateAuthorityStub) ListServers(ctx context.Context, id types.ID) (*iaas.CertificateAuthorityListServersResult, error) {
	if s.ListServersStubResult == nil {
		log.Fatal("CertificateAuthorityStub.ListServersStubResult is not set")
	}
	return s.ListServersStubResult.Values, s.ListServersStubResult.Err
}

// ReadServer is API call with trace log
func (s *CertificateAuthorityStub) ReadServer(ctx context.Context, id types.ID, serverID string) (*iaas.CertificateAuthorityServer, error) {
	if s.ReadServerStubResult == nil {
		log.Fatal("CertificateAuthorityStub.ReadServerStubResult is not set")
	}
	return s.ReadServerStubResult.CertificateAuthority, s.ReadServerStubResult.Err
}

// RevokeServer is API call with trace log
func (s *CertificateAuthorityStub) RevokeServer(ctx context.Context, id types.ID, serverID string) error {
	if s.RevokeServerStubResult == nil {
		log.Fatal("CertificateAuthorityStub.RevokeServerStubResult is not set")
	}
	return s.RevokeServerStubResult.Err
}

// HoldServer is API call with trace log
func (s *CertificateAuthorityStub) HoldServer(ctx context.Context, id types.ID, serverID string) error {
	if s.HoldServerStubResult == nil {
		log.Fatal("CertificateAuthorityStub.HoldServerStubResult is not set")
	}
	return s.HoldServerStubResult.Err
}

// ResumeServer is API call with trace log
func (s *CertificateAuthorityStub) ResumeServer(ctx context.Context, id types.ID, serverID string) error {
	if s.ResumeServerStubResult == nil {
		log.Fatal("CertificateAuthorityStub.ResumeServerStubResult is not set")
	}
	return s.ResumeServerStubResult.Err
}

/*************************************************
* ContainerRegistryStub
*************************************************/

// ContainerRegistryFindStubResult is expected values of the Find operation
type ContainerRegistryFindStubResult struct {
	Values *iaas.ContainerRegistryFindResult
	Err    error
}

// ContainerRegistryCreateStubResult is expected values of the Create operation
type ContainerRegistryCreateStubResult struct {
	ContainerRegistry *iaas.ContainerRegistry
	Err               error
}

// ContainerRegistryReadStubResult is expected values of the Read operation
type ContainerRegistryReadStubResult struct {
	ContainerRegistry *iaas.ContainerRegistry
	Err               error
}

// ContainerRegistryUpdateStubResult is expected values of the Update operation
type ContainerRegistryUpdateStubResult struct {
	ContainerRegistry *iaas.ContainerRegistry
	Err               error
}

// ContainerRegistryUpdateSettingsStubResult is expected values of the UpdateSettings operation
type ContainerRegistryUpdateSettingsStubResult struct {
	ContainerRegistry *iaas.ContainerRegistry
	Err               error
}

// ContainerRegistryDeleteStubResult is expected values of the Delete operation
type ContainerRegistryDeleteStubResult struct {
	Err error
}

// ContainerRegistryListUsersStubResult is expected values of the ListUsers operation
type ContainerRegistryListUsersStubResult struct {
	ContainerRegistryUsers *iaas.ContainerRegistryUsers
	Err                    error
}

// ContainerRegistryAddUserStubResult is expected values of the AddUser operation
type ContainerRegistryAddUserStubResult struct {
	Err error
}

// ContainerRegistryUpdateUserStubResult is expected values of the UpdateUser operation
type ContainerRegistryUpdateUserStubResult struct {
	Err error
}

// ContainerRegistryDeleteUserStubResult is expected values of the DeleteUser operation
type ContainerRegistryDeleteUserStubResult struct {
	Err error
}

// ContainerRegistryStub is for trace ContainerRegistryOp operations
type ContainerRegistryStub struct {
	FindStubResult           *ContainerRegistryFindStubResult
	CreateStubResult         *ContainerRegistryCreateStubResult
	ReadStubResult           *ContainerRegistryReadStubResult
	UpdateStubResult         *ContainerRegistryUpdateStubResult
	UpdateSettingsStubResult *ContainerRegistryUpdateSettingsStubResult
	DeleteStubResult         *ContainerRegistryDeleteStubResult
	ListUsersStubResult      *ContainerRegistryListUsersStubResult
	AddUserStubResult        *ContainerRegistryAddUserStubResult
	UpdateUserStubResult     *ContainerRegistryUpdateUserStubResult
	DeleteUserStubResult     *ContainerRegistryDeleteUserStubResult
}

// NewContainerRegistryStub creates new ContainerRegistryStub instance
func NewContainerRegistryStub(caller iaas.APICaller) iaas.ContainerRegistryAPI {
	return &ContainerRegistryStub{}
}

// Find is API call with trace log
func (s *ContainerRegistryStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ContainerRegistryFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ContainerRegistryStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *ContainerRegistryStub) Create(ctx context.Context, param *iaas.ContainerRegistryCreateRequest) (*iaas.ContainerRegistry, error) {
	if s.CreateStubResult == nil {
		log.Fatal("ContainerRegistryStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.ContainerRegistry, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *ContainerRegistryStub) Read(ctx context.Context, id types.ID) (*iaas.ContainerRegistry, error) {
	if s.ReadStubResult == nil {
		log.Fatal("ContainerRegistryStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.ContainerRegistry, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *ContainerRegistryStub) Update(ctx context.Context, id types.ID, param *iaas.ContainerRegistryUpdateRequest) (*iaas.ContainerRegistry, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("ContainerRegistryStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.ContainerRegistry, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *ContainerRegistryStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.ContainerRegistryUpdateSettingsRequest) (*iaas.ContainerRegistry, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("ContainerRegistryStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.ContainerRegistry, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *ContainerRegistryStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("ContainerRegistryStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// ListUsers is API call with trace log
func (s *ContainerRegistryStub) ListUsers(ctx context.Context, id types.ID) (*iaas.ContainerRegistryUsers, error) {
	if s.ListUsersStubResult == nil {
		log.Fatal("ContainerRegistryStub.ListUsersStubResult is not set")
	}
	return s.ListUsersStubResult.ContainerRegistryUsers, s.ListUsersStubResult.Err
}

// AddUser is API call with trace log
func (s *ContainerRegistryStub) AddUser(ctx context.Context, id types.ID, param *iaas.ContainerRegistryUserCreateRequest) error {
	if s.AddUserStubResult == nil {
		log.Fatal("ContainerRegistryStub.AddUserStubResult is not set")
	}
	return s.AddUserStubResult.Err
}

// UpdateUser is API call with trace log
func (s *ContainerRegistryStub) UpdateUser(ctx context.Context, id types.ID, username string, param *iaas.ContainerRegistryUserUpdateRequest) error {
	if s.UpdateUserStubResult == nil {
		log.Fatal("ContainerRegistryStub.UpdateUserStubResult is not set")
	}
	return s.UpdateUserStubResult.Err
}

// DeleteUser is API call with trace log
func (s *ContainerRegistryStub) DeleteUser(ctx context.Context, id types.ID, username string) error {
	if s.DeleteUserStubResult == nil {
		log.Fatal("ContainerRegistryStub.DeleteUserStubResult is not set")
	}
	return s.DeleteUserStubResult.Err
}

/*************************************************
* CouponStub
*************************************************/

// CouponFindStubResult is expected values of the Find operation
type CouponFindStubResult struct {
	Values *iaas.CouponFindResult
	Err    error
}

// CouponStub is for trace CouponOp operations
type CouponStub struct {
	FindStubResult *CouponFindStubResult
}

// NewCouponStub creates new CouponStub instance
func NewCouponStub(caller iaas.APICaller) iaas.CouponAPI {
	return &CouponStub{}
}

// Find is API call with trace log
func (s *CouponStub) Find(ctx context.Context, accountID types.ID) (*iaas.CouponFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("CouponStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

/*************************************************
* DatabaseStub
*************************************************/

// DatabaseFindStubResult is expected values of the Find operation
type DatabaseFindStubResult struct {
	Values *iaas.DatabaseFindResult
	Err    error
}

// DatabaseCreateStubResult is expected values of the Create operation
type DatabaseCreateStubResult struct {
	Database *iaas.Database
	Err      error
}

// DatabaseReadStubResult is expected values of the Read operation
type DatabaseReadStubResult struct {
	Database *iaas.Database
	Err      error
}

// DatabaseUpdateStubResult is expected values of the Update operation
type DatabaseUpdateStubResult struct {
	Database *iaas.Database
	Err      error
}

// DatabaseUpdateSettingsStubResult is expected values of the UpdateSettings operation
type DatabaseUpdateSettingsStubResult struct {
	Database *iaas.Database
	Err      error
}

// DatabaseDeleteStubResult is expected values of the Delete operation
type DatabaseDeleteStubResult struct {
	Err error
}

// DatabaseConfigStubResult is expected values of the Config operation
type DatabaseConfigStubResult struct {
	Err error
}

// DatabaseBootStubResult is expected values of the Boot operation
type DatabaseBootStubResult struct {
	Err error
}

// DatabaseShutdownStubResult is expected values of the Shutdown operation
type DatabaseShutdownStubResult struct {
	Err error
}

// DatabaseResetStubResult is expected values of the Reset operation
type DatabaseResetStubResult struct {
	Err error
}

// DatabaseMonitorCPUStubResult is expected values of the MonitorCPU operation
type DatabaseMonitorCPUStubResult struct {
	CPUTimeActivity *iaas.CPUTimeActivity
	Err             error
}

// DatabaseMonitorDiskStubResult is expected values of the MonitorDisk operation
type DatabaseMonitorDiskStubResult struct {
	DiskActivity *iaas.DiskActivity
	Err          error
}

// DatabaseMonitorInterfaceStubResult is expected values of the MonitorInterface operation
type DatabaseMonitorInterfaceStubResult struct {
	InterfaceActivity *iaas.InterfaceActivity
	Err               error
}

// DatabaseMonitorDatabaseStubResult is expected values of the MonitorDatabase operation
type DatabaseMonitorDatabaseStubResult struct {
	DatabaseActivity *iaas.DatabaseActivity
	Err              error
}

// DatabaseStatusStubResult is expected values of the Status operation
type DatabaseStatusStubResult struct {
	DatabaseStatus *iaas.DatabaseStatus
	Err            error
}

// DatabaseGetParameterStubResult is expected values of the GetParameter operation
type DatabaseGetParameterStubResult struct {
	DatabaseParameter *iaas.DatabaseParameter
	Err               error
}

// DatabaseSetParameterStubResult is expected values of the SetParameter operation
type DatabaseSetParameterStubResult struct {
	Err error
}

// DatabaseStub is for trace DatabaseOp operations
type DatabaseStub struct {
	FindStubResult             *DatabaseFindStubResult
	CreateStubResult           *DatabaseCreateStubResult
	ReadStubResult             *DatabaseReadStubResult
	UpdateStubResult           *DatabaseUpdateStubResult
	UpdateSettingsStubResult   *DatabaseUpdateSettingsStubResult
	DeleteStubResult           *DatabaseDeleteStubResult
	ConfigStubResult           *DatabaseConfigStubResult
	BootStubResult             *DatabaseBootStubResult
	ShutdownStubResult         *DatabaseShutdownStubResult
	ResetStubResult            *DatabaseResetStubResult
	MonitorCPUStubResult       *DatabaseMonitorCPUStubResult
	MonitorDiskStubResult      *DatabaseMonitorDiskStubResult
	MonitorInterfaceStubResult *DatabaseMonitorInterfaceStubResult
	MonitorDatabaseStubResult  *DatabaseMonitorDatabaseStubResult
	StatusStubResult           *DatabaseStatusStubResult
	GetParameterStubResult     *DatabaseGetParameterStubResult
	SetParameterStubResult     *DatabaseSetParameterStubResult
}

// NewDatabaseStub creates new DatabaseStub instance
func NewDatabaseStub(caller iaas.APICaller) iaas.DatabaseAPI {
	return &DatabaseStub{}
}

// Find is API call with trace log
func (s *DatabaseStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.DatabaseFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("DatabaseStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *DatabaseStub) Create(ctx context.Context, zone string, param *iaas.DatabaseCreateRequest) (*iaas.Database, error) {
	if s.CreateStubResult == nil {
		log.Fatal("DatabaseStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Database, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *DatabaseStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Database, error) {
	if s.ReadStubResult == nil {
		log.Fatal("DatabaseStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Database, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *DatabaseStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.DatabaseUpdateRequest) (*iaas.Database, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("DatabaseStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Database, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *DatabaseStub) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.DatabaseUpdateSettingsRequest) (*iaas.Database, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("DatabaseStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.Database, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *DatabaseStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("DatabaseStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Config is API call with trace log
func (s *DatabaseStub) Config(ctx context.Context, zone string, id types.ID) error {
	if s.ConfigStubResult == nil {
		log.Fatal("DatabaseStub.ConfigStubResult is not set")
	}
	return s.ConfigStubResult.Err
}

// Boot is API call with trace log
func (s *DatabaseStub) Boot(ctx context.Context, zone string, id types.ID) error {
	if s.BootStubResult == nil {
		log.Fatal("DatabaseStub.BootStubResult is not set")
	}
	return s.BootStubResult.Err
}

// Shutdown is API call with trace log
func (s *DatabaseStub) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	if s.ShutdownStubResult == nil {
		log.Fatal("DatabaseStub.ShutdownStubResult is not set")
	}
	return s.ShutdownStubResult.Err
}

// Reset is API call with trace log
func (s *DatabaseStub) Reset(ctx context.Context, zone string, id types.ID) error {
	if s.ResetStubResult == nil {
		log.Fatal("DatabaseStub.ResetStubResult is not set")
	}
	return s.ResetStubResult.Err
}

// MonitorCPU is API call with trace log
func (s *DatabaseStub) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	if s.MonitorCPUStubResult == nil {
		log.Fatal("DatabaseStub.MonitorCPUStubResult is not set")
	}
	return s.MonitorCPUStubResult.CPUTimeActivity, s.MonitorCPUStubResult.Err
}

// MonitorDisk is API call with trace log
func (s *DatabaseStub) MonitorDisk(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DiskActivity, error) {
	if s.MonitorDiskStubResult == nil {
		log.Fatal("DatabaseStub.MonitorDiskStubResult is not set")
	}
	return s.MonitorDiskStubResult.DiskActivity, s.MonitorDiskStubResult.Err
}

// MonitorInterface is API call with trace log
func (s *DatabaseStub) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	if s.MonitorInterfaceStubResult == nil {
		log.Fatal("DatabaseStub.MonitorInterfaceStubResult is not set")
	}
	return s.MonitorInterfaceStubResult.InterfaceActivity, s.MonitorInterfaceStubResult.Err
}

// MonitorDatabase is API call with trace log
func (s *DatabaseStub) MonitorDatabase(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DatabaseActivity, error) {
	if s.MonitorDatabaseStubResult == nil {
		log.Fatal("DatabaseStub.MonitorDatabaseStubResult is not set")
	}
	return s.MonitorDatabaseStubResult.DatabaseActivity, s.MonitorDatabaseStubResult.Err
}

// Status is API call with trace log
func (s *DatabaseStub) Status(ctx context.Context, zone string, id types.ID) (*iaas.DatabaseStatus, error) {
	if s.StatusStubResult == nil {
		log.Fatal("DatabaseStub.StatusStubResult is not set")
	}
	return s.StatusStubResult.DatabaseStatus, s.StatusStubResult.Err
}

// GetParameter is API call with trace log
func (s *DatabaseStub) GetParameter(ctx context.Context, zone string, id types.ID) (*iaas.DatabaseParameter, error) {
	if s.GetParameterStubResult == nil {
		log.Fatal("DatabaseStub.GetParameterStubResult is not set")
	}
	return s.GetParameterStubResult.DatabaseParameter, s.GetParameterStubResult.Err
}

// SetParameter is API call with trace log
func (s *DatabaseStub) SetParameter(ctx context.Context, zone string, id types.ID, param map[string]interface{}) error {
	if s.SetParameterStubResult == nil {
		log.Fatal("DatabaseStub.SetParameterStubResult is not set")
	}
	return s.SetParameterStubResult.Err
}

/*************************************************
* DiskStub
*************************************************/

// DiskFindStubResult is expected values of the Find operation
type DiskFindStubResult struct {
	Values *iaas.DiskFindResult
	Err    error
}

// DiskCreateStubResult is expected values of the Create operation
type DiskCreateStubResult struct {
	Disk *iaas.Disk
	Err  error
}

// DiskConfigStubResult is expected values of the Config operation
type DiskConfigStubResult struct {
	Err error
}

// DiskCreateWithConfigStubResult is expected values of the CreateWithConfig operation
type DiskCreateWithConfigStubResult struct {
	Disk *iaas.Disk
	Err  error
}

// DiskResizePartitionStubResult is expected values of the ResizePartition operation
type DiskResizePartitionStubResult struct {
	Err error
}

// DiskConnectToServerStubResult is expected values of the ConnectToServer operation
type DiskConnectToServerStubResult struct {
	Err error
}

// DiskDisconnectFromServerStubResult is expected values of the DisconnectFromServer operation
type DiskDisconnectFromServerStubResult struct {
	Err error
}

// DiskReadStubResult is expected values of the Read operation
type DiskReadStubResult struct {
	Disk *iaas.Disk
	Err  error
}

// DiskUpdateStubResult is expected values of the Update operation
type DiskUpdateStubResult struct {
	Disk *iaas.Disk
	Err  error
}

// DiskDeleteStubResult is expected values of the Delete operation
type DiskDeleteStubResult struct {
	Err error
}

// DiskMonitorStubResult is expected values of the Monitor operation
type DiskMonitorStubResult struct {
	DiskActivity *iaas.DiskActivity
	Err          error
}

// DiskMonitorDiskStubResult is expected values of the MonitorDisk operation
type DiskMonitorDiskStubResult struct {
	DiskActivity *iaas.DiskActivity
	Err          error
}

// DiskStub is for trace DiskOp operations
type DiskStub struct {
	FindStubResult                 *DiskFindStubResult
	CreateStubResult               *DiskCreateStubResult
	ConfigStubResult               *DiskConfigStubResult
	CreateWithConfigStubResult     *DiskCreateWithConfigStubResult
	ResizePartitionStubResult      *DiskResizePartitionStubResult
	ConnectToServerStubResult      *DiskConnectToServerStubResult
	DisconnectFromServerStubResult *DiskDisconnectFromServerStubResult
	ReadStubResult                 *DiskReadStubResult
	UpdateStubResult               *DiskUpdateStubResult
	DeleteStubResult               *DiskDeleteStubResult
	MonitorStubResult              *DiskMonitorStubResult
	MonitorDiskStubResult          *DiskMonitorDiskStubResult
}

// NewDiskStub creates new DiskStub instance
func NewDiskStub(caller iaas.APICaller) iaas.DiskAPI {
	return &DiskStub{}
}

// Find is API call with trace log
func (s *DiskStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.DiskFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("DiskStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *DiskStub) Create(ctx context.Context, zone string, createParam *iaas.DiskCreateRequest, distantFrom []types.ID, kmeKeyID types.ID) (*iaas.Disk, error) {
	if s.CreateStubResult == nil {
		log.Fatal("DiskStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Disk, s.CreateStubResult.Err
}

// Config is API call with trace log
func (s *DiskStub) Config(ctx context.Context, zone string, id types.ID, edit *iaas.DiskEditRequest) error {
	if s.ConfigStubResult == nil {
		log.Fatal("DiskStub.ConfigStubResult is not set")
	}
	return s.ConfigStubResult.Err
}

// CreateWithConfig is API call with trace log
func (s *DiskStub) CreateWithConfig(ctx context.Context, zone string, createParam *iaas.DiskCreateRequest, editParam *iaas.DiskEditRequest, bootAtAvailable bool, distantFrom []types.ID, kmeKeyID types.ID) (*iaas.Disk, error) {
	if s.CreateWithConfigStubResult == nil {
		log.Fatal("DiskStub.CreateWithConfigStubResult is not set")
	}
	return s.CreateWithConfigStubResult.Disk, s.CreateWithConfigStubResult.Err
}

// ResizePartition is API call with trace log
func (s *DiskStub) ResizePartition(ctx context.Context, zone string, id types.ID, param *iaas.DiskResizePartitionRequest) error {
	if s.ResizePartitionStubResult == nil {
		log.Fatal("DiskStub.ResizePartitionStubResult is not set")
	}
	return s.ResizePartitionStubResult.Err
}

// ConnectToServer is API call with trace log
func (s *DiskStub) ConnectToServer(ctx context.Context, zone string, id types.ID, serverID types.ID) error {
	if s.ConnectToServerStubResult == nil {
		log.Fatal("DiskStub.ConnectToServerStubResult is not set")
	}
	return s.ConnectToServerStubResult.Err
}

// DisconnectFromServer is API call with trace log
func (s *DiskStub) DisconnectFromServer(ctx context.Context, zone string, id types.ID) error {
	if s.DisconnectFromServerStubResult == nil {
		log.Fatal("DiskStub.DisconnectFromServerStubResult is not set")
	}
	return s.DisconnectFromServerStubResult.Err
}

// Read is API call with trace log
func (s *DiskStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Disk, error) {
	if s.ReadStubResult == nil {
		log.Fatal("DiskStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Disk, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *DiskStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.DiskUpdateRequest) (*iaas.Disk, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("DiskStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Disk, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *DiskStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("DiskStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Monitor is API call with trace log
func (s *DiskStub) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DiskActivity, error) {
	if s.MonitorStubResult == nil {
		log.Fatal("DiskStub.MonitorStubResult is not set")
	}
	return s.MonitorStubResult.DiskActivity, s.MonitorStubResult.Err
}

// MonitorDisk is API call with trace log
func (s *DiskStub) MonitorDisk(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.DiskActivity, error) {
	if s.MonitorDiskStubResult == nil {
		log.Fatal("DiskStub.MonitorDiskStubResult is not set")
	}
	return s.MonitorDiskStubResult.DiskActivity, s.MonitorDiskStubResult.Err
}

/*************************************************
* DiskPlanStub
*************************************************/

// DiskPlanFindStubResult is expected values of the Find operation
type DiskPlanFindStubResult struct {
	Values *iaas.DiskPlanFindResult
	Err    error
}

// DiskPlanReadStubResult is expected values of the Read operation
type DiskPlanReadStubResult struct {
	DiskPlan *iaas.DiskPlan
	Err      error
}

// DiskPlanStub is for trace DiskPlanOp operations
type DiskPlanStub struct {
	FindStubResult *DiskPlanFindStubResult
	ReadStubResult *DiskPlanReadStubResult
}

// NewDiskPlanStub creates new DiskPlanStub instance
func NewDiskPlanStub(caller iaas.APICaller) iaas.DiskPlanAPI {
	return &DiskPlanStub{}
}

// Find is API call with trace log
func (s *DiskPlanStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.DiskPlanFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("DiskPlanStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *DiskPlanStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.DiskPlan, error) {
	if s.ReadStubResult == nil {
		log.Fatal("DiskPlanStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.DiskPlan, s.ReadStubResult.Err
}

/*************************************************
* DNSStub
*************************************************/

// DNSFindStubResult is expected values of the Find operation
type DNSFindStubResult struct {
	Values *iaas.DNSFindResult
	Err    error
}

// DNSCreateStubResult is expected values of the Create operation
type DNSCreateStubResult struct {
	DNS *iaas.DNS
	Err error
}

// DNSReadStubResult is expected values of the Read operation
type DNSReadStubResult struct {
	DNS *iaas.DNS
	Err error
}

// DNSUpdateStubResult is expected values of the Update operation
type DNSUpdateStubResult struct {
	DNS *iaas.DNS
	Err error
}

// DNSUpdateSettingsStubResult is expected values of the UpdateSettings operation
type DNSUpdateSettingsStubResult struct {
	DNS *iaas.DNS
	Err error
}

// DNSDeleteStubResult is expected values of the Delete operation
type DNSDeleteStubResult struct {
	Err error
}

// DNSStub is for trace DNSOp operations
type DNSStub struct {
	FindStubResult           *DNSFindStubResult
	CreateStubResult         *DNSCreateStubResult
	ReadStubResult           *DNSReadStubResult
	UpdateStubResult         *DNSUpdateStubResult
	UpdateSettingsStubResult *DNSUpdateSettingsStubResult
	DeleteStubResult         *DNSDeleteStubResult
}

// NewDNSStub creates new DNSStub instance
func NewDNSStub(caller iaas.APICaller) iaas.DNSAPI {
	return &DNSStub{}
}

// Find is API call with trace log
func (s *DNSStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.DNSFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("DNSStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *DNSStub) Create(ctx context.Context, param *iaas.DNSCreateRequest) (*iaas.DNS, error) {
	if s.CreateStubResult == nil {
		log.Fatal("DNSStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.DNS, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *DNSStub) Read(ctx context.Context, id types.ID) (*iaas.DNS, error) {
	if s.ReadStubResult == nil {
		log.Fatal("DNSStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.DNS, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *DNSStub) Update(ctx context.Context, id types.ID, param *iaas.DNSUpdateRequest) (*iaas.DNS, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("DNSStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.DNS, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *DNSStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.DNSUpdateSettingsRequest) (*iaas.DNS, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("DNSStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.DNS, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *DNSStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("DNSStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* EnhancedDBStub
*************************************************/

// EnhancedDBFindStubResult is expected values of the Find operation
type EnhancedDBFindStubResult struct {
	Values *iaas.EnhancedDBFindResult
	Err    error
}

// EnhancedDBCreateStubResult is expected values of the Create operation
type EnhancedDBCreateStubResult struct {
	EnhancedDB *iaas.EnhancedDB
	Err        error
}

// EnhancedDBReadStubResult is expected values of the Read operation
type EnhancedDBReadStubResult struct {
	EnhancedDB *iaas.EnhancedDB
	Err        error
}

// EnhancedDBUpdateStubResult is expected values of the Update operation
type EnhancedDBUpdateStubResult struct {
	EnhancedDB *iaas.EnhancedDB
	Err        error
}

// EnhancedDBDeleteStubResult is expected values of the Delete operation
type EnhancedDBDeleteStubResult struct {
	Err error
}

// EnhancedDBSetPasswordStubResult is expected values of the SetPassword operation
type EnhancedDBSetPasswordStubResult struct {
	Err error
}

// EnhancedDBGetConfigStubResult is expected values of the GetConfig operation
type EnhancedDBGetConfigStubResult struct {
	EnhancedDBConfig *iaas.EnhancedDBConfig
	Err              error
}

// EnhancedDBSetConfigStubResult is expected values of the SetConfig operation
type EnhancedDBSetConfigStubResult struct {
	Err error
}

// EnhancedDBStub is for trace EnhancedDBOp operations
type EnhancedDBStub struct {
	FindStubResult        *EnhancedDBFindStubResult
	CreateStubResult      *EnhancedDBCreateStubResult
	ReadStubResult        *EnhancedDBReadStubResult
	UpdateStubResult      *EnhancedDBUpdateStubResult
	DeleteStubResult      *EnhancedDBDeleteStubResult
	SetPasswordStubResult *EnhancedDBSetPasswordStubResult
	GetConfigStubResult   *EnhancedDBGetConfigStubResult
	SetConfigStubResult   *EnhancedDBSetConfigStubResult
}

// NewEnhancedDBStub creates new EnhancedDBStub instance
func NewEnhancedDBStub(caller iaas.APICaller) iaas.EnhancedDBAPI {
	return &EnhancedDBStub{}
}

// Find is API call with trace log
func (s *EnhancedDBStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.EnhancedDBFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("EnhancedDBStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *EnhancedDBStub) Create(ctx context.Context, param *iaas.EnhancedDBCreateRequest) (*iaas.EnhancedDB, error) {
	if s.CreateStubResult == nil {
		log.Fatal("EnhancedDBStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.EnhancedDB, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *EnhancedDBStub) Read(ctx context.Context, id types.ID) (*iaas.EnhancedDB, error) {
	if s.ReadStubResult == nil {
		log.Fatal("EnhancedDBStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.EnhancedDB, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *EnhancedDBStub) Update(ctx context.Context, id types.ID, param *iaas.EnhancedDBUpdateRequest) (*iaas.EnhancedDB, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("EnhancedDBStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.EnhancedDB, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *EnhancedDBStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("EnhancedDBStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// SetPassword is API call with trace log
func (s *EnhancedDBStub) SetPassword(ctx context.Context, id types.ID, param *iaas.EnhancedDBSetPasswordRequest) error {
	if s.SetPasswordStubResult == nil {
		log.Fatal("EnhancedDBStub.SetPasswordStubResult is not set")
	}
	return s.SetPasswordStubResult.Err
}

// GetConfig is API call with trace log
func (s *EnhancedDBStub) GetConfig(ctx context.Context, id types.ID) (*iaas.EnhancedDBConfig, error) {
	if s.GetConfigStubResult == nil {
		log.Fatal("EnhancedDBStub.GetConfigStubResult is not set")
	}
	return s.GetConfigStubResult.EnhancedDBConfig, s.GetConfigStubResult.Err
}

// SetConfig is API call with trace log
func (s *EnhancedDBStub) SetConfig(ctx context.Context, id types.ID, param *iaas.EnhancedDBSetConfigRequest) error {
	if s.SetConfigStubResult == nil {
		log.Fatal("EnhancedDBStub.SetConfigStubResult is not set")
	}
	return s.SetConfigStubResult.Err
}

/*************************************************
* ESMEStub
*************************************************/

// ESMEFindStubResult is expected values of the Find operation
type ESMEFindStubResult struct {
	Values *iaas.ESMEFindResult
	Err    error
}

// ESMECreateStubResult is expected values of the Create operation
type ESMECreateStubResult struct {
	ESME *iaas.ESME
	Err  error
}

// ESMEReadStubResult is expected values of the Read operation
type ESMEReadStubResult struct {
	ESME *iaas.ESME
	Err  error
}

// ESMEUpdateStubResult is expected values of the Update operation
type ESMEUpdateStubResult struct {
	ESME *iaas.ESME
	Err  error
}

// ESMEDeleteStubResult is expected values of the Delete operation
type ESMEDeleteStubResult struct {
	Err error
}

// ESMESendMessageWithGeneratedOTPStubResult is expected values of the SendMessageWithGeneratedOTP operation
type ESMESendMessageWithGeneratedOTPStubResult struct {
	ESMESendMessageResult *iaas.ESMESendMessageResult
	Err                   error
}

// ESMESendMessageWithInputtedOTPStubResult is expected values of the SendMessageWithInputtedOTP operation
type ESMESendMessageWithInputtedOTPStubResult struct {
	ESMESendMessageResult *iaas.ESMESendMessageResult
	Err                   error
}

// ESMELogsStubResult is expected values of the Logs operation
type ESMELogsStubResult struct {
	Logs []*iaas.ESMELogs
	Err  error
}

// ESMEStub is for trace ESMEOp operations
type ESMEStub struct {
	FindStubResult                        *ESMEFindStubResult
	CreateStubResult                      *ESMECreateStubResult
	ReadStubResult                        *ESMEReadStubResult
	UpdateStubResult                      *ESMEUpdateStubResult
	DeleteStubResult                      *ESMEDeleteStubResult
	SendMessageWithGeneratedOTPStubResult *ESMESendMessageWithGeneratedOTPStubResult
	SendMessageWithInputtedOTPStubResult  *ESMESendMessageWithInputtedOTPStubResult
	LogsStubResult                        *ESMELogsStubResult
}

// NewESMEStub creates new ESMEStub instance
func NewESMEStub(caller iaas.APICaller) iaas.ESMEAPI {
	return &ESMEStub{}
}

// Find is API call with trace log
func (s *ESMEStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ESMEFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ESMEStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *ESMEStub) Create(ctx context.Context, param *iaas.ESMECreateRequest) (*iaas.ESME, error) {
	if s.CreateStubResult == nil {
		log.Fatal("ESMEStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.ESME, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *ESMEStub) Read(ctx context.Context, id types.ID) (*iaas.ESME, error) {
	if s.ReadStubResult == nil {
		log.Fatal("ESMEStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.ESME, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *ESMEStub) Update(ctx context.Context, id types.ID, param *iaas.ESMEUpdateRequest) (*iaas.ESME, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("ESMEStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.ESME, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *ESMEStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("ESMEStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// SendMessageWithGeneratedOTP is API call with trace log
func (s *ESMEStub) SendMessageWithGeneratedOTP(ctx context.Context, id types.ID, param *iaas.ESMESendMessageWithGeneratedOTPRequest) (*iaas.ESMESendMessageResult, error) {
	if s.SendMessageWithGeneratedOTPStubResult == nil {
		log.Fatal("ESMEStub.SendMessageWithGeneratedOTPStubResult is not set")
	}
	return s.SendMessageWithGeneratedOTPStubResult.ESMESendMessageResult, s.SendMessageWithGeneratedOTPStubResult.Err
}

// SendMessageWithInputtedOTP is API call with trace log
func (s *ESMEStub) SendMessageWithInputtedOTP(ctx context.Context, id types.ID, param *iaas.ESMESendMessageWithInputtedOTPRequest) (*iaas.ESMESendMessageResult, error) {
	if s.SendMessageWithInputtedOTPStubResult == nil {
		log.Fatal("ESMEStub.SendMessageWithInputtedOTPStubResult is not set")
	}
	return s.SendMessageWithInputtedOTPStubResult.ESMESendMessageResult, s.SendMessageWithInputtedOTPStubResult.Err
}

// Logs is API call with trace log
func (s *ESMEStub) Logs(ctx context.Context, id types.ID) ([]*iaas.ESMELogs, error) {
	if s.LogsStubResult == nil {
		log.Fatal("ESMEStub.LogsStubResult is not set")
	}
	return s.LogsStubResult.Logs, s.LogsStubResult.Err
}

/*************************************************
* GSLBStub
*************************************************/

// GSLBFindStubResult is expected values of the Find operation
type GSLBFindStubResult struct {
	Values *iaas.GSLBFindResult
	Err    error
}

// GSLBCreateStubResult is expected values of the Create operation
type GSLBCreateStubResult struct {
	GSLB *iaas.GSLB
	Err  error
}

// GSLBReadStubResult is expected values of the Read operation
type GSLBReadStubResult struct {
	GSLB *iaas.GSLB
	Err  error
}

// GSLBUpdateStubResult is expected values of the Update operation
type GSLBUpdateStubResult struct {
	GSLB *iaas.GSLB
	Err  error
}

// GSLBUpdateSettingsStubResult is expected values of the UpdateSettings operation
type GSLBUpdateSettingsStubResult struct {
	GSLB *iaas.GSLB
	Err  error
}

// GSLBDeleteStubResult is expected values of the Delete operation
type GSLBDeleteStubResult struct {
	Err error
}

// GSLBStub is for trace GSLBOp operations
type GSLBStub struct {
	FindStubResult           *GSLBFindStubResult
	CreateStubResult         *GSLBCreateStubResult
	ReadStubResult           *GSLBReadStubResult
	UpdateStubResult         *GSLBUpdateStubResult
	UpdateSettingsStubResult *GSLBUpdateSettingsStubResult
	DeleteStubResult         *GSLBDeleteStubResult
}

// NewGSLBStub creates new GSLBStub instance
func NewGSLBStub(caller iaas.APICaller) iaas.GSLBAPI {
	return &GSLBStub{}
}

// Find is API call with trace log
func (s *GSLBStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.GSLBFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("GSLBStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *GSLBStub) Create(ctx context.Context, param *iaas.GSLBCreateRequest) (*iaas.GSLB, error) {
	if s.CreateStubResult == nil {
		log.Fatal("GSLBStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.GSLB, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *GSLBStub) Read(ctx context.Context, id types.ID) (*iaas.GSLB, error) {
	if s.ReadStubResult == nil {
		log.Fatal("GSLBStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.GSLB, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *GSLBStub) Update(ctx context.Context, id types.ID, param *iaas.GSLBUpdateRequest) (*iaas.GSLB, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("GSLBStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.GSLB, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *GSLBStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.GSLBUpdateSettingsRequest) (*iaas.GSLB, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("GSLBStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.GSLB, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *GSLBStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("GSLBStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* IconStub
*************************************************/

// IconFindStubResult is expected values of the Find operation
type IconFindStubResult struct {
	Values *iaas.IconFindResult
	Err    error
}

// IconCreateStubResult is expected values of the Create operation
type IconCreateStubResult struct {
	Icon *iaas.Icon
	Err  error
}

// IconReadStubResult is expected values of the Read operation
type IconReadStubResult struct {
	Icon *iaas.Icon
	Err  error
}

// IconUpdateStubResult is expected values of the Update operation
type IconUpdateStubResult struct {
	Icon *iaas.Icon
	Err  error
}

// IconDeleteStubResult is expected values of the Delete operation
type IconDeleteStubResult struct {
	Err error
}

// IconStub is for trace IconOp operations
type IconStub struct {
	FindStubResult   *IconFindStubResult
	CreateStubResult *IconCreateStubResult
	ReadStubResult   *IconReadStubResult
	UpdateStubResult *IconUpdateStubResult
	DeleteStubResult *IconDeleteStubResult
}

// NewIconStub creates new IconStub instance
func NewIconStub(caller iaas.APICaller) iaas.IconAPI {
	return &IconStub{}
}

// Find is API call with trace log
func (s *IconStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.IconFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("IconStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *IconStub) Create(ctx context.Context, param *iaas.IconCreateRequest) (*iaas.Icon, error) {
	if s.CreateStubResult == nil {
		log.Fatal("IconStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Icon, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *IconStub) Read(ctx context.Context, id types.ID) (*iaas.Icon, error) {
	if s.ReadStubResult == nil {
		log.Fatal("IconStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Icon, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *IconStub) Update(ctx context.Context, id types.ID, param *iaas.IconUpdateRequest) (*iaas.Icon, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("IconStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Icon, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *IconStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("IconStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* InterfaceStub
*************************************************/

// InterfaceFindStubResult is expected values of the Find operation
type InterfaceFindStubResult struct {
	Values *iaas.InterfaceFindResult
	Err    error
}

// InterfaceCreateStubResult is expected values of the Create operation
type InterfaceCreateStubResult struct {
	Interface *iaas.Interface
	Err       error
}

// InterfaceReadStubResult is expected values of the Read operation
type InterfaceReadStubResult struct {
	Interface *iaas.Interface
	Err       error
}

// InterfaceUpdateStubResult is expected values of the Update operation
type InterfaceUpdateStubResult struct {
	Interface *iaas.Interface
	Err       error
}

// InterfaceDeleteStubResult is expected values of the Delete operation
type InterfaceDeleteStubResult struct {
	Err error
}

// InterfaceMonitorStubResult is expected values of the Monitor operation
type InterfaceMonitorStubResult struct {
	InterfaceActivity *iaas.InterfaceActivity
	Err               error
}

// InterfaceConnectToSharedSegmentStubResult is expected values of the ConnectToSharedSegment operation
type InterfaceConnectToSharedSegmentStubResult struct {
	Err error
}

// InterfaceConnectToSwitchStubResult is expected values of the ConnectToSwitch operation
type InterfaceConnectToSwitchStubResult struct {
	Err error
}

// InterfaceDisconnectFromSwitchStubResult is expected values of the DisconnectFromSwitch operation
type InterfaceDisconnectFromSwitchStubResult struct {
	Err error
}

// InterfaceConnectToPacketFilterStubResult is expected values of the ConnectToPacketFilter operation
type InterfaceConnectToPacketFilterStubResult struct {
	Err error
}

// InterfaceDisconnectFromPacketFilterStubResult is expected values of the DisconnectFromPacketFilter operation
type InterfaceDisconnectFromPacketFilterStubResult struct {
	Err error
}

// InterfaceStub is for trace InterfaceOp operations
type InterfaceStub struct {
	FindStubResult                       *InterfaceFindStubResult
	CreateStubResult                     *InterfaceCreateStubResult
	ReadStubResult                       *InterfaceReadStubResult
	UpdateStubResult                     *InterfaceUpdateStubResult
	DeleteStubResult                     *InterfaceDeleteStubResult
	MonitorStubResult                    *InterfaceMonitorStubResult
	ConnectToSharedSegmentStubResult     *InterfaceConnectToSharedSegmentStubResult
	ConnectToSwitchStubResult            *InterfaceConnectToSwitchStubResult
	DisconnectFromSwitchStubResult       *InterfaceDisconnectFromSwitchStubResult
	ConnectToPacketFilterStubResult      *InterfaceConnectToPacketFilterStubResult
	DisconnectFromPacketFilterStubResult *InterfaceDisconnectFromPacketFilterStubResult
}

// NewInterfaceStub creates new InterfaceStub instance
func NewInterfaceStub(caller iaas.APICaller) iaas.InterfaceAPI {
	return &InterfaceStub{}
}

// Find is API call with trace log
func (s *InterfaceStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.InterfaceFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("InterfaceStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *InterfaceStub) Create(ctx context.Context, zone string, param *iaas.InterfaceCreateRequest) (*iaas.Interface, error) {
	if s.CreateStubResult == nil {
		log.Fatal("InterfaceStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Interface, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *InterfaceStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Interface, error) {
	if s.ReadStubResult == nil {
		log.Fatal("InterfaceStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Interface, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *InterfaceStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.InterfaceUpdateRequest) (*iaas.Interface, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("InterfaceStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Interface, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *InterfaceStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("InterfaceStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Monitor is API call with trace log
func (s *InterfaceStub) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	if s.MonitorStubResult == nil {
		log.Fatal("InterfaceStub.MonitorStubResult is not set")
	}
	return s.MonitorStubResult.InterfaceActivity, s.MonitorStubResult.Err
}

// ConnectToSharedSegment is API call with trace log
func (s *InterfaceStub) ConnectToSharedSegment(ctx context.Context, zone string, id types.ID) error {
	if s.ConnectToSharedSegmentStubResult == nil {
		log.Fatal("InterfaceStub.ConnectToSharedSegmentStubResult is not set")
	}
	return s.ConnectToSharedSegmentStubResult.Err
}

// ConnectToSwitch is API call with trace log
func (s *InterfaceStub) ConnectToSwitch(ctx context.Context, zone string, id types.ID, switchID types.ID) error {
	if s.ConnectToSwitchStubResult == nil {
		log.Fatal("InterfaceStub.ConnectToSwitchStubResult is not set")
	}
	return s.ConnectToSwitchStubResult.Err
}

// DisconnectFromSwitch is API call with trace log
func (s *InterfaceStub) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID) error {
	if s.DisconnectFromSwitchStubResult == nil {
		log.Fatal("InterfaceStub.DisconnectFromSwitchStubResult is not set")
	}
	return s.DisconnectFromSwitchStubResult.Err
}

// ConnectToPacketFilter is API call with trace log
func (s *InterfaceStub) ConnectToPacketFilter(ctx context.Context, zone string, id types.ID, packetFilterID types.ID) error {
	if s.ConnectToPacketFilterStubResult == nil {
		log.Fatal("InterfaceStub.ConnectToPacketFilterStubResult is not set")
	}
	return s.ConnectToPacketFilterStubResult.Err
}

// DisconnectFromPacketFilter is API call with trace log
func (s *InterfaceStub) DisconnectFromPacketFilter(ctx context.Context, zone string, id types.ID) error {
	if s.DisconnectFromPacketFilterStubResult == nil {
		log.Fatal("InterfaceStub.DisconnectFromPacketFilterStubResult is not set")
	}
	return s.DisconnectFromPacketFilterStubResult.Err
}

/*************************************************
* InternetStub
*************************************************/

// InternetFindStubResult is expected values of the Find operation
type InternetFindStubResult struct {
	Values *iaas.InternetFindResult
	Err    error
}

// InternetCreateStubResult is expected values of the Create operation
type InternetCreateStubResult struct {
	Internet *iaas.Internet
	Err      error
}

// InternetReadStubResult is expected values of the Read operation
type InternetReadStubResult struct {
	Internet *iaas.Internet
	Err      error
}

// InternetUpdateStubResult is expected values of the Update operation
type InternetUpdateStubResult struct {
	Internet *iaas.Internet
	Err      error
}

// InternetDeleteStubResult is expected values of the Delete operation
type InternetDeleteStubResult struct {
	Err error
}

// InternetUpdateBandWidthStubResult is expected values of the UpdateBandWidth operation
type InternetUpdateBandWidthStubResult struct {
	Internet *iaas.Internet
	Err      error
}

// InternetAddSubnetStubResult is expected values of the AddSubnet operation
type InternetAddSubnetStubResult struct {
	Subnet *iaas.InternetSubnetOperationResult
	Err    error
}

// InternetUpdateSubnetStubResult is expected values of the UpdateSubnet operation
type InternetUpdateSubnetStubResult struct {
	Subnet *iaas.InternetSubnetOperationResult
	Err    error
}

// InternetDeleteSubnetStubResult is expected values of the DeleteSubnet operation
type InternetDeleteSubnetStubResult struct {
	Err error
}

// InternetMonitorStubResult is expected values of the Monitor operation
type InternetMonitorStubResult struct {
	RouterActivity *iaas.RouterActivity
	Err            error
}

// InternetMonitorRouterStubResult is expected values of the MonitorRouter operation
type InternetMonitorRouterStubResult struct {
	RouterActivity *iaas.RouterActivity
	Err            error
}

// InternetEnableIPv6StubResult is expected values of the EnableIPv6 operation
type InternetEnableIPv6StubResult struct {
	IPv6Net *iaas.IPv6NetInfo
	Err     error
}

// InternetDisableIPv6StubResult is expected values of the DisableIPv6 operation
type InternetDisableIPv6StubResult struct {
	Err error
}

// InternetStub is for trace InternetOp operations
type InternetStub struct {
	FindStubResult            *InternetFindStubResult
	CreateStubResult          *InternetCreateStubResult
	ReadStubResult            *InternetReadStubResult
	UpdateStubResult          *InternetUpdateStubResult
	DeleteStubResult          *InternetDeleteStubResult
	UpdateBandWidthStubResult *InternetUpdateBandWidthStubResult
	AddSubnetStubResult       *InternetAddSubnetStubResult
	UpdateSubnetStubResult    *InternetUpdateSubnetStubResult
	DeleteSubnetStubResult    *InternetDeleteSubnetStubResult
	MonitorStubResult         *InternetMonitorStubResult
	MonitorRouterStubResult   *InternetMonitorRouterStubResult
	EnableIPv6StubResult      *InternetEnableIPv6StubResult
	DisableIPv6StubResult     *InternetDisableIPv6StubResult
}

// NewInternetStub creates new InternetStub instance
func NewInternetStub(caller iaas.APICaller) iaas.InternetAPI {
	return &InternetStub{}
}

// Find is API call with trace log
func (s *InternetStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.InternetFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("InternetStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *InternetStub) Create(ctx context.Context, zone string, param *iaas.InternetCreateRequest) (*iaas.Internet, error) {
	if s.CreateStubResult == nil {
		log.Fatal("InternetStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Internet, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *InternetStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Internet, error) {
	if s.ReadStubResult == nil {
		log.Fatal("InternetStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Internet, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *InternetStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.InternetUpdateRequest) (*iaas.Internet, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("InternetStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Internet, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *InternetStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("InternetStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// UpdateBandWidth is API call with trace log
func (s *InternetStub) UpdateBandWidth(ctx context.Context, zone string, id types.ID, param *iaas.InternetUpdateBandWidthRequest) (*iaas.Internet, error) {
	if s.UpdateBandWidthStubResult == nil {
		log.Fatal("InternetStub.UpdateBandWidthStubResult is not set")
	}
	return s.UpdateBandWidthStubResult.Internet, s.UpdateBandWidthStubResult.Err
}

// AddSubnet is API call with trace log
func (s *InternetStub) AddSubnet(ctx context.Context, zone string, id types.ID, param *iaas.InternetAddSubnetRequest) (*iaas.InternetSubnetOperationResult, error) {
	if s.AddSubnetStubResult == nil {
		log.Fatal("InternetStub.AddSubnetStubResult is not set")
	}
	return s.AddSubnetStubResult.Subnet, s.AddSubnetStubResult.Err
}

// UpdateSubnet is API call with trace log
func (s *InternetStub) UpdateSubnet(ctx context.Context, zone string, id types.ID, subnetID types.ID, param *iaas.InternetUpdateSubnetRequest) (*iaas.InternetSubnetOperationResult, error) {
	if s.UpdateSubnetStubResult == nil {
		log.Fatal("InternetStub.UpdateSubnetStubResult is not set")
	}
	return s.UpdateSubnetStubResult.Subnet, s.UpdateSubnetStubResult.Err
}

// DeleteSubnet is API call with trace log
func (s *InternetStub) DeleteSubnet(ctx context.Context, zone string, id types.ID, subnetID types.ID) error {
	if s.DeleteSubnetStubResult == nil {
		log.Fatal("InternetStub.DeleteSubnetStubResult is not set")
	}
	return s.DeleteSubnetStubResult.Err
}

// Monitor is API call with trace log
func (s *InternetStub) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.RouterActivity, error) {
	if s.MonitorStubResult == nil {
		log.Fatal("InternetStub.MonitorStubResult is not set")
	}
	return s.MonitorStubResult.RouterActivity, s.MonitorStubResult.Err
}

// MonitorRouter is API call with trace log
func (s *InternetStub) MonitorRouter(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.RouterActivity, error) {
	if s.MonitorRouterStubResult == nil {
		log.Fatal("InternetStub.MonitorRouterStubResult is not set")
	}
	return s.MonitorRouterStubResult.RouterActivity, s.MonitorRouterStubResult.Err
}

// EnableIPv6 is API call with trace log
func (s *InternetStub) EnableIPv6(ctx context.Context, zone string, id types.ID) (*iaas.IPv6NetInfo, error) {
	if s.EnableIPv6StubResult == nil {
		log.Fatal("InternetStub.EnableIPv6StubResult is not set")
	}
	return s.EnableIPv6StubResult.IPv6Net, s.EnableIPv6StubResult.Err
}

// DisableIPv6 is API call with trace log
func (s *InternetStub) DisableIPv6(ctx context.Context, zone string, id types.ID, ipv6netID types.ID) error {
	if s.DisableIPv6StubResult == nil {
		log.Fatal("InternetStub.DisableIPv6StubResult is not set")
	}
	return s.DisableIPv6StubResult.Err
}

/*************************************************
* InternetPlanStub
*************************************************/

// InternetPlanFindStubResult is expected values of the Find operation
type InternetPlanFindStubResult struct {
	Values *iaas.InternetPlanFindResult
	Err    error
}

// InternetPlanReadStubResult is expected values of the Read operation
type InternetPlanReadStubResult struct {
	InternetPlan *iaas.InternetPlan
	Err          error
}

// InternetPlanStub is for trace InternetPlanOp operations
type InternetPlanStub struct {
	FindStubResult *InternetPlanFindStubResult
	ReadStubResult *InternetPlanReadStubResult
}

// NewInternetPlanStub creates new InternetPlanStub instance
func NewInternetPlanStub(caller iaas.APICaller) iaas.InternetPlanAPI {
	return &InternetPlanStub{}
}

// Find is API call with trace log
func (s *InternetPlanStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.InternetPlanFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("InternetPlanStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *InternetPlanStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.InternetPlan, error) {
	if s.ReadStubResult == nil {
		log.Fatal("InternetPlanStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.InternetPlan, s.ReadStubResult.Err
}

/*************************************************
* IPAddressStub
*************************************************/

// IPAddressListStubResult is expected values of the List operation
type IPAddressListStubResult struct {
	Values *iaas.IPAddressListResult
	Err    error
}

// IPAddressReadStubResult is expected values of the Read operation
type IPAddressReadStubResult struct {
	IPAddress *iaas.IPAddress
	Err       error
}

// IPAddressUpdateHostNameStubResult is expected values of the UpdateHostName operation
type IPAddressUpdateHostNameStubResult struct {
	IPAddress *iaas.IPAddress
	Err       error
}

// IPAddressStub is for trace IPAddressOp operations
type IPAddressStub struct {
	ListStubResult           *IPAddressListStubResult
	ReadStubResult           *IPAddressReadStubResult
	UpdateHostNameStubResult *IPAddressUpdateHostNameStubResult
}

// NewIPAddressStub creates new IPAddressStub instance
func NewIPAddressStub(caller iaas.APICaller) iaas.IPAddressAPI {
	return &IPAddressStub{}
}

// List is API call with trace log
func (s *IPAddressStub) List(ctx context.Context, zone string) (*iaas.IPAddressListResult, error) {
	if s.ListStubResult == nil {
		log.Fatal("IPAddressStub.ListStubResult is not set")
	}
	return s.ListStubResult.Values, s.ListStubResult.Err
}

// Read is API call with trace log
func (s *IPAddressStub) Read(ctx context.Context, zone string, ipAddress string) (*iaas.IPAddress, error) {
	if s.ReadStubResult == nil {
		log.Fatal("IPAddressStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.IPAddress, s.ReadStubResult.Err
}

// UpdateHostName is API call with trace log
func (s *IPAddressStub) UpdateHostName(ctx context.Context, zone string, ipAddress string, hostName string) (*iaas.IPAddress, error) {
	if s.UpdateHostNameStubResult == nil {
		log.Fatal("IPAddressStub.UpdateHostNameStubResult is not set")
	}
	return s.UpdateHostNameStubResult.IPAddress, s.UpdateHostNameStubResult.Err
}

/*************************************************
* IPv6NetStub
*************************************************/

// IPv6NetListStubResult is expected values of the List operation
type IPv6NetListStubResult struct {
	Values *iaas.IPv6NetListResult
	Err    error
}

// IPv6NetFindStubResult is expected values of the Find operation
type IPv6NetFindStubResult struct {
	Values *iaas.IPv6NetFindResult
	Err    error
}

// IPv6NetReadStubResult is expected values of the Read operation
type IPv6NetReadStubResult struct {
	IPv6Net *iaas.IPv6Net
	Err     error
}

// IPv6NetStub is for trace IPv6NetOp operations
type IPv6NetStub struct {
	ListStubResult *IPv6NetListStubResult
	FindStubResult *IPv6NetFindStubResult
	ReadStubResult *IPv6NetReadStubResult
}

// NewIPv6NetStub creates new IPv6NetStub instance
func NewIPv6NetStub(caller iaas.APICaller) iaas.IPv6NetAPI {
	return &IPv6NetStub{}
}

// List is API call with trace log
func (s *IPv6NetStub) List(ctx context.Context, zone string) (*iaas.IPv6NetListResult, error) {
	if s.ListStubResult == nil {
		log.Fatal("IPv6NetStub.ListStubResult is not set")
	}
	return s.ListStubResult.Values, s.ListStubResult.Err
}

// Find is API call with trace log
func (s *IPv6NetStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.IPv6NetFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("IPv6NetStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *IPv6NetStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.IPv6Net, error) {
	if s.ReadStubResult == nil {
		log.Fatal("IPv6NetStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.IPv6Net, s.ReadStubResult.Err
}

/*************************************************
* IPv6AddrStub
*************************************************/

// IPv6AddrFindStubResult is expected values of the Find operation
type IPv6AddrFindStubResult struct {
	Values *iaas.IPv6AddrFindResult
	Err    error
}

// IPv6AddrCreateStubResult is expected values of the Create operation
type IPv6AddrCreateStubResult struct {
	IPv6Addr *iaas.IPv6Addr
	Err      error
}

// IPv6AddrReadStubResult is expected values of the Read operation
type IPv6AddrReadStubResult struct {
	IPv6Addr *iaas.IPv6Addr
	Err      error
}

// IPv6AddrUpdateStubResult is expected values of the Update operation
type IPv6AddrUpdateStubResult struct {
	IPv6Addr *iaas.IPv6Addr
	Err      error
}

// IPv6AddrDeleteStubResult is expected values of the Delete operation
type IPv6AddrDeleteStubResult struct {
	Err error
}

// IPv6AddrStub is for trace IPv6AddrOp operations
type IPv6AddrStub struct {
	FindStubResult   *IPv6AddrFindStubResult
	CreateStubResult *IPv6AddrCreateStubResult
	ReadStubResult   *IPv6AddrReadStubResult
	UpdateStubResult *IPv6AddrUpdateStubResult
	DeleteStubResult *IPv6AddrDeleteStubResult
}

// NewIPv6AddrStub creates new IPv6AddrStub instance
func NewIPv6AddrStub(caller iaas.APICaller) iaas.IPv6AddrAPI {
	return &IPv6AddrStub{}
}

// Find is API call with trace log
func (s *IPv6AddrStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.IPv6AddrFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("IPv6AddrStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *IPv6AddrStub) Create(ctx context.Context, zone string, param *iaas.IPv6AddrCreateRequest) (*iaas.IPv6Addr, error) {
	if s.CreateStubResult == nil {
		log.Fatal("IPv6AddrStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.IPv6Addr, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *IPv6AddrStub) Read(ctx context.Context, zone string, ipv6addr string) (*iaas.IPv6Addr, error) {
	if s.ReadStubResult == nil {
		log.Fatal("IPv6AddrStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.IPv6Addr, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *IPv6AddrStub) Update(ctx context.Context, zone string, ipv6addr string, param *iaas.IPv6AddrUpdateRequest) (*iaas.IPv6Addr, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("IPv6AddrStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.IPv6Addr, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *IPv6AddrStub) Delete(ctx context.Context, zone string, ipv6addr string) error {
	if s.DeleteStubResult == nil {
		log.Fatal("IPv6AddrStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* LicenseStub
*************************************************/

// LicenseFindStubResult is expected values of the Find operation
type LicenseFindStubResult struct {
	Values *iaas.LicenseFindResult
	Err    error
}

// LicenseCreateStubResult is expected values of the Create operation
type LicenseCreateStubResult struct {
	License *iaas.License
	Err     error
}

// LicenseReadStubResult is expected values of the Read operation
type LicenseReadStubResult struct {
	License *iaas.License
	Err     error
}

// LicenseUpdateStubResult is expected values of the Update operation
type LicenseUpdateStubResult struct {
	License *iaas.License
	Err     error
}

// LicenseDeleteStubResult is expected values of the Delete operation
type LicenseDeleteStubResult struct {
	Err error
}

// LicenseStub is for trace LicenseOp operations
type LicenseStub struct {
	FindStubResult   *LicenseFindStubResult
	CreateStubResult *LicenseCreateStubResult
	ReadStubResult   *LicenseReadStubResult
	UpdateStubResult *LicenseUpdateStubResult
	DeleteStubResult *LicenseDeleteStubResult
}

// NewLicenseStub creates new LicenseStub instance
func NewLicenseStub(caller iaas.APICaller) iaas.LicenseAPI {
	return &LicenseStub{}
}

// Find is API call with trace log
func (s *LicenseStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.LicenseFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("LicenseStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *LicenseStub) Create(ctx context.Context, param *iaas.LicenseCreateRequest) (*iaas.License, error) {
	if s.CreateStubResult == nil {
		log.Fatal("LicenseStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.License, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *LicenseStub) Read(ctx context.Context, id types.ID) (*iaas.License, error) {
	if s.ReadStubResult == nil {
		log.Fatal("LicenseStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.License, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *LicenseStub) Update(ctx context.Context, id types.ID, param *iaas.LicenseUpdateRequest) (*iaas.License, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("LicenseStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.License, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *LicenseStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("LicenseStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* LicenseInfoStub
*************************************************/

// LicenseInfoFindStubResult is expected values of the Find operation
type LicenseInfoFindStubResult struct {
	Values *iaas.LicenseInfoFindResult
	Err    error
}

// LicenseInfoReadStubResult is expected values of the Read operation
type LicenseInfoReadStubResult struct {
	LicenseInfo *iaas.LicenseInfo
	Err         error
}

// LicenseInfoStub is for trace LicenseInfoOp operations
type LicenseInfoStub struct {
	FindStubResult *LicenseInfoFindStubResult
	ReadStubResult *LicenseInfoReadStubResult
}

// NewLicenseInfoStub creates new LicenseInfoStub instance
func NewLicenseInfoStub(caller iaas.APICaller) iaas.LicenseInfoAPI {
	return &LicenseInfoStub{}
}

// Find is API call with trace log
func (s *LicenseInfoStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.LicenseInfoFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("LicenseInfoStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *LicenseInfoStub) Read(ctx context.Context, id types.ID) (*iaas.LicenseInfo, error) {
	if s.ReadStubResult == nil {
		log.Fatal("LicenseInfoStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.LicenseInfo, s.ReadStubResult.Err
}

/*************************************************
* LoadBalancerStub
*************************************************/

// LoadBalancerFindStubResult is expected values of the Find operation
type LoadBalancerFindStubResult struct {
	Values *iaas.LoadBalancerFindResult
	Err    error
}

// LoadBalancerCreateStubResult is expected values of the Create operation
type LoadBalancerCreateStubResult struct {
	LoadBalancer *iaas.LoadBalancer
	Err          error
}

// LoadBalancerReadStubResult is expected values of the Read operation
type LoadBalancerReadStubResult struct {
	LoadBalancer *iaas.LoadBalancer
	Err          error
}

// LoadBalancerUpdateStubResult is expected values of the Update operation
type LoadBalancerUpdateStubResult struct {
	LoadBalancer *iaas.LoadBalancer
	Err          error
}

// LoadBalancerUpdateSettingsStubResult is expected values of the UpdateSettings operation
type LoadBalancerUpdateSettingsStubResult struct {
	LoadBalancer *iaas.LoadBalancer
	Err          error
}

// LoadBalancerDeleteStubResult is expected values of the Delete operation
type LoadBalancerDeleteStubResult struct {
	Err error
}

// LoadBalancerConfigStubResult is expected values of the Config operation
type LoadBalancerConfigStubResult struct {
	Err error
}

// LoadBalancerBootStubResult is expected values of the Boot operation
type LoadBalancerBootStubResult struct {
	Err error
}

// LoadBalancerShutdownStubResult is expected values of the Shutdown operation
type LoadBalancerShutdownStubResult struct {
	Err error
}

// LoadBalancerResetStubResult is expected values of the Reset operation
type LoadBalancerResetStubResult struct {
	Err error
}

// LoadBalancerMonitorCPUStubResult is expected values of the MonitorCPU operation
type LoadBalancerMonitorCPUStubResult struct {
	CPUTimeActivity *iaas.CPUTimeActivity
	Err             error
}

// LoadBalancerMonitorInterfaceStubResult is expected values of the MonitorInterface operation
type LoadBalancerMonitorInterfaceStubResult struct {
	InterfaceActivity *iaas.InterfaceActivity
	Err               error
}

// LoadBalancerStatusStubResult is expected values of the Status operation
type LoadBalancerStatusStubResult struct {
	Values *iaas.LoadBalancerStatusResult
	Err    error
}

// LoadBalancerStub is for trace LoadBalancerOp operations
type LoadBalancerStub struct {
	FindStubResult             *LoadBalancerFindStubResult
	CreateStubResult           *LoadBalancerCreateStubResult
	ReadStubResult             *LoadBalancerReadStubResult
	UpdateStubResult           *LoadBalancerUpdateStubResult
	UpdateSettingsStubResult   *LoadBalancerUpdateSettingsStubResult
	DeleteStubResult           *LoadBalancerDeleteStubResult
	ConfigStubResult           *LoadBalancerConfigStubResult
	BootStubResult             *LoadBalancerBootStubResult
	ShutdownStubResult         *LoadBalancerShutdownStubResult
	ResetStubResult            *LoadBalancerResetStubResult
	MonitorCPUStubResult       *LoadBalancerMonitorCPUStubResult
	MonitorInterfaceStubResult *LoadBalancerMonitorInterfaceStubResult
	StatusStubResult           *LoadBalancerStatusStubResult
}

// NewLoadBalancerStub creates new LoadBalancerStub instance
func NewLoadBalancerStub(caller iaas.APICaller) iaas.LoadBalancerAPI {
	return &LoadBalancerStub{}
}

// Find is API call with trace log
func (s *LoadBalancerStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.LoadBalancerFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("LoadBalancerStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *LoadBalancerStub) Create(ctx context.Context, zone string, param *iaas.LoadBalancerCreateRequest) (*iaas.LoadBalancer, error) {
	if s.CreateStubResult == nil {
		log.Fatal("LoadBalancerStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.LoadBalancer, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *LoadBalancerStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.LoadBalancer, error) {
	if s.ReadStubResult == nil {
		log.Fatal("LoadBalancerStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.LoadBalancer, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *LoadBalancerStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.LoadBalancerUpdateRequest) (*iaas.LoadBalancer, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("LoadBalancerStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.LoadBalancer, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *LoadBalancerStub) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.LoadBalancerUpdateSettingsRequest) (*iaas.LoadBalancer, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("LoadBalancerStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.LoadBalancer, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *LoadBalancerStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("LoadBalancerStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Config is API call with trace log
func (s *LoadBalancerStub) Config(ctx context.Context, zone string, id types.ID) error {
	if s.ConfigStubResult == nil {
		log.Fatal("LoadBalancerStub.ConfigStubResult is not set")
	}
	return s.ConfigStubResult.Err
}

// Boot is API call with trace log
func (s *LoadBalancerStub) Boot(ctx context.Context, zone string, id types.ID) error {
	if s.BootStubResult == nil {
		log.Fatal("LoadBalancerStub.BootStubResult is not set")
	}
	return s.BootStubResult.Err
}

// Shutdown is API call with trace log
func (s *LoadBalancerStub) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	if s.ShutdownStubResult == nil {
		log.Fatal("LoadBalancerStub.ShutdownStubResult is not set")
	}
	return s.ShutdownStubResult.Err
}

// Reset is API call with trace log
func (s *LoadBalancerStub) Reset(ctx context.Context, zone string, id types.ID) error {
	if s.ResetStubResult == nil {
		log.Fatal("LoadBalancerStub.ResetStubResult is not set")
	}
	return s.ResetStubResult.Err
}

// MonitorCPU is API call with trace log
func (s *LoadBalancerStub) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	if s.MonitorCPUStubResult == nil {
		log.Fatal("LoadBalancerStub.MonitorCPUStubResult is not set")
	}
	return s.MonitorCPUStubResult.CPUTimeActivity, s.MonitorCPUStubResult.Err
}

// MonitorInterface is API call with trace log
func (s *LoadBalancerStub) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	if s.MonitorInterfaceStubResult == nil {
		log.Fatal("LoadBalancerStub.MonitorInterfaceStubResult is not set")
	}
	return s.MonitorInterfaceStubResult.InterfaceActivity, s.MonitorInterfaceStubResult.Err
}

// Status is API call with trace log
func (s *LoadBalancerStub) Status(ctx context.Context, zone string, id types.ID) (*iaas.LoadBalancerStatusResult, error) {
	if s.StatusStubResult == nil {
		log.Fatal("LoadBalancerStub.StatusStubResult is not set")
	}
	return s.StatusStubResult.Values, s.StatusStubResult.Err
}

/*************************************************
* LocalRouterStub
*************************************************/

// LocalRouterFindStubResult is expected values of the Find operation
type LocalRouterFindStubResult struct {
	Values *iaas.LocalRouterFindResult
	Err    error
}

// LocalRouterCreateStubResult is expected values of the Create operation
type LocalRouterCreateStubResult struct {
	LocalRouter *iaas.LocalRouter
	Err         error
}

// LocalRouterReadStubResult is expected values of the Read operation
type LocalRouterReadStubResult struct {
	LocalRouter *iaas.LocalRouter
	Err         error
}

// LocalRouterUpdateStubResult is expected values of the Update operation
type LocalRouterUpdateStubResult struct {
	LocalRouter *iaas.LocalRouter
	Err         error
}

// LocalRouterUpdateSettingsStubResult is expected values of the UpdateSettings operation
type LocalRouterUpdateSettingsStubResult struct {
	LocalRouter *iaas.LocalRouter
	Err         error
}

// LocalRouterDeleteStubResult is expected values of the Delete operation
type LocalRouterDeleteStubResult struct {
	Err error
}

// LocalRouterHealthStatusStubResult is expected values of the HealthStatus operation
type LocalRouterHealthStatusStubResult struct {
	LocalRouterHealth *iaas.LocalRouterHealth
	Err               error
}

// LocalRouterMonitorLocalRouterStubResult is expected values of the MonitorLocalRouter operation
type LocalRouterMonitorLocalRouterStubResult struct {
	LocalRouterActivity *iaas.LocalRouterActivity
	Err                 error
}

// LocalRouterStub is for trace LocalRouterOp operations
type LocalRouterStub struct {
	FindStubResult               *LocalRouterFindStubResult
	CreateStubResult             *LocalRouterCreateStubResult
	ReadStubResult               *LocalRouterReadStubResult
	UpdateStubResult             *LocalRouterUpdateStubResult
	UpdateSettingsStubResult     *LocalRouterUpdateSettingsStubResult
	DeleteStubResult             *LocalRouterDeleteStubResult
	HealthStatusStubResult       *LocalRouterHealthStatusStubResult
	MonitorLocalRouterStubResult *LocalRouterMonitorLocalRouterStubResult
}

// NewLocalRouterStub creates new LocalRouterStub instance
func NewLocalRouterStub(caller iaas.APICaller) iaas.LocalRouterAPI {
	return &LocalRouterStub{}
}

// Find is API call with trace log
func (s *LocalRouterStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.LocalRouterFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("LocalRouterStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *LocalRouterStub) Create(ctx context.Context, param *iaas.LocalRouterCreateRequest) (*iaas.LocalRouter, error) {
	if s.CreateStubResult == nil {
		log.Fatal("LocalRouterStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.LocalRouter, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *LocalRouterStub) Read(ctx context.Context, id types.ID) (*iaas.LocalRouter, error) {
	if s.ReadStubResult == nil {
		log.Fatal("LocalRouterStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.LocalRouter, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *LocalRouterStub) Update(ctx context.Context, id types.ID, param *iaas.LocalRouterUpdateRequest) (*iaas.LocalRouter, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("LocalRouterStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.LocalRouter, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *LocalRouterStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.LocalRouterUpdateSettingsRequest) (*iaas.LocalRouter, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("LocalRouterStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.LocalRouter, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *LocalRouterStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("LocalRouterStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// HealthStatus is API call with trace log
func (s *LocalRouterStub) HealthStatus(ctx context.Context, id types.ID) (*iaas.LocalRouterHealth, error) {
	if s.HealthStatusStubResult == nil {
		log.Fatal("LocalRouterStub.HealthStatusStubResult is not set")
	}
	return s.HealthStatusStubResult.LocalRouterHealth, s.HealthStatusStubResult.Err
}

// MonitorLocalRouter is API call with trace log
func (s *LocalRouterStub) MonitorLocalRouter(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.LocalRouterActivity, error) {
	if s.MonitorLocalRouterStubResult == nil {
		log.Fatal("LocalRouterStub.MonitorLocalRouterStubResult is not set")
	}
	return s.MonitorLocalRouterStubResult.LocalRouterActivity, s.MonitorLocalRouterStubResult.Err
}

/*************************************************
* MobileGatewayStub
*************************************************/

// MobileGatewayFindStubResult is expected values of the Find operation
type MobileGatewayFindStubResult struct {
	Values *iaas.MobileGatewayFindResult
	Err    error
}

// MobileGatewayCreateStubResult is expected values of the Create operation
type MobileGatewayCreateStubResult struct {
	MobileGateway *iaas.MobileGateway
	Err           error
}

// MobileGatewayReadStubResult is expected values of the Read operation
type MobileGatewayReadStubResult struct {
	MobileGateway *iaas.MobileGateway
	Err           error
}

// MobileGatewayUpdateStubResult is expected values of the Update operation
type MobileGatewayUpdateStubResult struct {
	MobileGateway *iaas.MobileGateway
	Err           error
}

// MobileGatewayUpdateSettingsStubResult is expected values of the UpdateSettings operation
type MobileGatewayUpdateSettingsStubResult struct {
	MobileGateway *iaas.MobileGateway
	Err           error
}

// MobileGatewayDeleteStubResult is expected values of the Delete operation
type MobileGatewayDeleteStubResult struct {
	Err error
}

// MobileGatewayConfigStubResult is expected values of the Config operation
type MobileGatewayConfigStubResult struct {
	Err error
}

// MobileGatewayBootStubResult is expected values of the Boot operation
type MobileGatewayBootStubResult struct {
	Err error
}

// MobileGatewayShutdownStubResult is expected values of the Shutdown operation
type MobileGatewayShutdownStubResult struct {
	Err error
}

// MobileGatewayResetStubResult is expected values of the Reset operation
type MobileGatewayResetStubResult struct {
	Err error
}

// MobileGatewayConnectToSwitchStubResult is expected values of the ConnectToSwitch operation
type MobileGatewayConnectToSwitchStubResult struct {
	Err error
}

// MobileGatewayDisconnectFromSwitchStubResult is expected values of the DisconnectFromSwitch operation
type MobileGatewayDisconnectFromSwitchStubResult struct {
	Err error
}

// MobileGatewayGetDNSStubResult is expected values of the GetDNS operation
type MobileGatewayGetDNSStubResult struct {
	SIMGroup *iaas.MobileGatewayDNSSetting
	Err      error
}

// MobileGatewaySetDNSStubResult is expected values of the SetDNS operation
type MobileGatewaySetDNSStubResult struct {
	Err error
}

// MobileGatewayGetSIMRoutesStubResult is expected values of the GetSIMRoutes operation
type MobileGatewayGetSIMRoutesStubResult struct {
	SIMRoutes iaas.MobileGatewaySIMRoutes
	Err       error
}

// MobileGatewaySetSIMRoutesStubResult is expected values of the SetSIMRoutes operation
type MobileGatewaySetSIMRoutesStubResult struct {
	Err error
}

// MobileGatewayListSIMStubResult is expected values of the ListSIM operation
type MobileGatewayListSIMStubResult struct {
	SIM iaas.MobileGatewaySIMs
	Err error
}

// MobileGatewayAddSIMStubResult is expected values of the AddSIM operation
type MobileGatewayAddSIMStubResult struct {
	Err error
}

// MobileGatewayDeleteSIMStubResult is expected values of the DeleteSIM operation
type MobileGatewayDeleteSIMStubResult struct {
	Err error
}

// MobileGatewayLogsStubResult is expected values of the Logs operation
type MobileGatewayLogsStubResult struct {
	Logs []*iaas.MobileGatewaySIMLogs
	Err  error
}

// MobileGatewayGetTrafficConfigStubResult is expected values of the GetTrafficConfig operation
type MobileGatewayGetTrafficConfigStubResult struct {
	TrafficMonitoring *iaas.MobileGatewayTrafficControl
	Err               error
}

// MobileGatewaySetTrafficConfigStubResult is expected values of the SetTrafficConfig operation
type MobileGatewaySetTrafficConfigStubResult struct {
	Err error
}

// MobileGatewayDeleteTrafficConfigStubResult is expected values of the DeleteTrafficConfig operation
type MobileGatewayDeleteTrafficConfigStubResult struct {
	Err error
}

// MobileGatewayTrafficStatusStubResult is expected values of the TrafficStatus operation
type MobileGatewayTrafficStatusStubResult struct {
	TrafficStatus *iaas.MobileGatewayTrafficStatus
	Err           error
}

// MobileGatewayMonitorInterfaceStubResult is expected values of the MonitorInterface operation
type MobileGatewayMonitorInterfaceStubResult struct {
	InterfaceActivity *iaas.InterfaceActivity
	Err               error
}

// MobileGatewayStub is for trace MobileGatewayOp operations
type MobileGatewayStub struct {
	FindStubResult                 *MobileGatewayFindStubResult
	CreateStubResult               *MobileGatewayCreateStubResult
	ReadStubResult                 *MobileGatewayReadStubResult
	UpdateStubResult               *MobileGatewayUpdateStubResult
	UpdateSettingsStubResult       *MobileGatewayUpdateSettingsStubResult
	DeleteStubResult               *MobileGatewayDeleteStubResult
	ConfigStubResult               *MobileGatewayConfigStubResult
	BootStubResult                 *MobileGatewayBootStubResult
	ShutdownStubResult             *MobileGatewayShutdownStubResult
	ResetStubResult                *MobileGatewayResetStubResult
	ConnectToSwitchStubResult      *MobileGatewayConnectToSwitchStubResult
	DisconnectFromSwitchStubResult *MobileGatewayDisconnectFromSwitchStubResult
	GetDNSStubResult               *MobileGatewayGetDNSStubResult
	SetDNSStubResult               *MobileGatewaySetDNSStubResult
	GetSIMRoutesStubResult         *MobileGatewayGetSIMRoutesStubResult
	SetSIMRoutesStubResult         *MobileGatewaySetSIMRoutesStubResult
	ListSIMStubResult              *MobileGatewayListSIMStubResult
	AddSIMStubResult               *MobileGatewayAddSIMStubResult
	DeleteSIMStubResult            *MobileGatewayDeleteSIMStubResult
	LogsStubResult                 *MobileGatewayLogsStubResult
	GetTrafficConfigStubResult     *MobileGatewayGetTrafficConfigStubResult
	SetTrafficConfigStubResult     *MobileGatewaySetTrafficConfigStubResult
	DeleteTrafficConfigStubResult  *MobileGatewayDeleteTrafficConfigStubResult
	TrafficStatusStubResult        *MobileGatewayTrafficStatusStubResult
	MonitorInterfaceStubResult     *MobileGatewayMonitorInterfaceStubResult
}

// NewMobileGatewayStub creates new MobileGatewayStub instance
func NewMobileGatewayStub(caller iaas.APICaller) iaas.MobileGatewayAPI {
	return &MobileGatewayStub{}
}

// Find is API call with trace log
func (s *MobileGatewayStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.MobileGatewayFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("MobileGatewayStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *MobileGatewayStub) Create(ctx context.Context, zone string, param *iaas.MobileGatewayCreateRequest) (*iaas.MobileGateway, error) {
	if s.CreateStubResult == nil {
		log.Fatal("MobileGatewayStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.MobileGateway, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *MobileGatewayStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.MobileGateway, error) {
	if s.ReadStubResult == nil {
		log.Fatal("MobileGatewayStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.MobileGateway, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *MobileGatewayStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayUpdateRequest) (*iaas.MobileGateway, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("MobileGatewayStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.MobileGateway, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *MobileGatewayStub) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayUpdateSettingsRequest) (*iaas.MobileGateway, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("MobileGatewayStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.MobileGateway, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *MobileGatewayStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("MobileGatewayStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Config is API call with trace log
func (s *MobileGatewayStub) Config(ctx context.Context, zone string, id types.ID) error {
	if s.ConfigStubResult == nil {
		log.Fatal("MobileGatewayStub.ConfigStubResult is not set")
	}
	return s.ConfigStubResult.Err
}

// Boot is API call with trace log
func (s *MobileGatewayStub) Boot(ctx context.Context, zone string, id types.ID) error {
	if s.BootStubResult == nil {
		log.Fatal("MobileGatewayStub.BootStubResult is not set")
	}
	return s.BootStubResult.Err
}

// Shutdown is API call with trace log
func (s *MobileGatewayStub) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	if s.ShutdownStubResult == nil {
		log.Fatal("MobileGatewayStub.ShutdownStubResult is not set")
	}
	return s.ShutdownStubResult.Err
}

// Reset is API call with trace log
func (s *MobileGatewayStub) Reset(ctx context.Context, zone string, id types.ID) error {
	if s.ResetStubResult == nil {
		log.Fatal("MobileGatewayStub.ResetStubResult is not set")
	}
	return s.ResetStubResult.Err
}

// ConnectToSwitch is API call with trace log
func (s *MobileGatewayStub) ConnectToSwitch(ctx context.Context, zone string, id types.ID, switchID types.ID) error {
	if s.ConnectToSwitchStubResult == nil {
		log.Fatal("MobileGatewayStub.ConnectToSwitchStubResult is not set")
	}
	return s.ConnectToSwitchStubResult.Err
}

// DisconnectFromSwitch is API call with trace log
func (s *MobileGatewayStub) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID) error {
	if s.DisconnectFromSwitchStubResult == nil {
		log.Fatal("MobileGatewayStub.DisconnectFromSwitchStubResult is not set")
	}
	return s.DisconnectFromSwitchStubResult.Err
}

// GetDNS is API call with trace log
func (s *MobileGatewayStub) GetDNS(ctx context.Context, zone string, id types.ID) (*iaas.MobileGatewayDNSSetting, error) {
	if s.GetDNSStubResult == nil {
		log.Fatal("MobileGatewayStub.GetDNSStubResult is not set")
	}
	return s.GetDNSStubResult.SIMGroup, s.GetDNSStubResult.Err
}

// SetDNS is API call with trace log
func (s *MobileGatewayStub) SetDNS(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayDNSSetting) error {
	if s.SetDNSStubResult == nil {
		log.Fatal("MobileGatewayStub.SetDNSStubResult is not set")
	}
	return s.SetDNSStubResult.Err
}

// GetSIMRoutes is API call with trace log
func (s *MobileGatewayStub) GetSIMRoutes(ctx context.Context, zone string, id types.ID) (iaas.MobileGatewaySIMRoutes, error) {
	if s.GetSIMRoutesStubResult == nil {
		log.Fatal("MobileGatewayStub.GetSIMRoutesStubResult is not set")
	}
	return s.GetSIMRoutesStubResult.SIMRoutes, s.GetSIMRoutesStubResult.Err
}

// SetSIMRoutes is API call with trace log
func (s *MobileGatewayStub) SetSIMRoutes(ctx context.Context, zone string, id types.ID, param []*iaas.MobileGatewaySIMRouteParam) error {
	if s.SetSIMRoutesStubResult == nil {
		log.Fatal("MobileGatewayStub.SetSIMRoutesStubResult is not set")
	}
	return s.SetSIMRoutesStubResult.Err
}

// ListSIM is API call with trace log
func (s *MobileGatewayStub) ListSIM(ctx context.Context, zone string, id types.ID) (iaas.MobileGatewaySIMs, error) {
	if s.ListSIMStubResult == nil {
		log.Fatal("MobileGatewayStub.ListSIMStubResult is not set")
	}
	return s.ListSIMStubResult.SIM, s.ListSIMStubResult.Err
}

// AddSIM is API call with trace log
func (s *MobileGatewayStub) AddSIM(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayAddSIMRequest) error {
	if s.AddSIMStubResult == nil {
		log.Fatal("MobileGatewayStub.AddSIMStubResult is not set")
	}
	return s.AddSIMStubResult.Err
}

// DeleteSIM is API call with trace log
func (s *MobileGatewayStub) DeleteSIM(ctx context.Context, zone string, id types.ID, simID types.ID) error {
	if s.DeleteSIMStubResult == nil {
		log.Fatal("MobileGatewayStub.DeleteSIMStubResult is not set")
	}
	return s.DeleteSIMStubResult.Err
}

// Logs is API call with trace log
func (s *MobileGatewayStub) Logs(ctx context.Context, zone string, id types.ID) ([]*iaas.MobileGatewaySIMLogs, error) {
	if s.LogsStubResult == nil {
		log.Fatal("MobileGatewayStub.LogsStubResult is not set")
	}
	return s.LogsStubResult.Logs, s.LogsStubResult.Err
}

// GetTrafficConfig is API call with trace log
func (s *MobileGatewayStub) GetTrafficConfig(ctx context.Context, zone string, id types.ID) (*iaas.MobileGatewayTrafficControl, error) {
	if s.GetTrafficConfigStubResult == nil {
		log.Fatal("MobileGatewayStub.GetTrafficConfigStubResult is not set")
	}
	return s.GetTrafficConfigStubResult.TrafficMonitoring, s.GetTrafficConfigStubResult.Err
}

// SetTrafficConfig is API call with trace log
func (s *MobileGatewayStub) SetTrafficConfig(ctx context.Context, zone string, id types.ID, param *iaas.MobileGatewayTrafficControl) error {
	if s.SetTrafficConfigStubResult == nil {
		log.Fatal("MobileGatewayStub.SetTrafficConfigStubResult is not set")
	}
	return s.SetTrafficConfigStubResult.Err
}

// DeleteTrafficConfig is API call with trace log
func (s *MobileGatewayStub) DeleteTrafficConfig(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteTrafficConfigStubResult == nil {
		log.Fatal("MobileGatewayStub.DeleteTrafficConfigStubResult is not set")
	}
	return s.DeleteTrafficConfigStubResult.Err
}

// TrafficStatus is API call with trace log
func (s *MobileGatewayStub) TrafficStatus(ctx context.Context, zone string, id types.ID) (*iaas.MobileGatewayTrafficStatus, error) {
	if s.TrafficStatusStubResult == nil {
		log.Fatal("MobileGatewayStub.TrafficStatusStubResult is not set")
	}
	return s.TrafficStatusStubResult.TrafficStatus, s.TrafficStatusStubResult.Err
}

// MonitorInterface is API call with trace log
func (s *MobileGatewayStub) MonitorInterface(ctx context.Context, zone string, id types.ID, index int, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	if s.MonitorInterfaceStubResult == nil {
		log.Fatal("MobileGatewayStub.MonitorInterfaceStubResult is not set")
	}
	return s.MonitorInterfaceStubResult.InterfaceActivity, s.MonitorInterfaceStubResult.Err
}

/*************************************************
* NFSStub
*************************************************/

// NFSFindStubResult is expected values of the Find operation
type NFSFindStubResult struct {
	Values *iaas.NFSFindResult
	Err    error
}

// NFSCreateStubResult is expected values of the Create operation
type NFSCreateStubResult struct {
	NFS *iaas.NFS
	Err error
}

// NFSReadStubResult is expected values of the Read operation
type NFSReadStubResult struct {
	NFS *iaas.NFS
	Err error
}

// NFSUpdateStubResult is expected values of the Update operation
type NFSUpdateStubResult struct {
	NFS *iaas.NFS
	Err error
}

// NFSDeleteStubResult is expected values of the Delete operation
type NFSDeleteStubResult struct {
	Err error
}

// NFSBootStubResult is expected values of the Boot operation
type NFSBootStubResult struct {
	Err error
}

// NFSShutdownStubResult is expected values of the Shutdown operation
type NFSShutdownStubResult struct {
	Err error
}

// NFSResetStubResult is expected values of the Reset operation
type NFSResetStubResult struct {
	Err error
}

// NFSMonitorCPUStubResult is expected values of the MonitorCPU operation
type NFSMonitorCPUStubResult struct {
	CPUTimeActivity *iaas.CPUTimeActivity
	Err             error
}

// NFSMonitorFreeDiskSizeStubResult is expected values of the MonitorFreeDiskSize operation
type NFSMonitorFreeDiskSizeStubResult struct {
	FreeDiskSizeActivity *iaas.FreeDiskSizeActivity
	Err                  error
}

// NFSMonitorInterfaceStubResult is expected values of the MonitorInterface operation
type NFSMonitorInterfaceStubResult struct {
	InterfaceActivity *iaas.InterfaceActivity
	Err               error
}

// NFSStub is for trace NFSOp operations
type NFSStub struct {
	FindStubResult                *NFSFindStubResult
	CreateStubResult              *NFSCreateStubResult
	ReadStubResult                *NFSReadStubResult
	UpdateStubResult              *NFSUpdateStubResult
	DeleteStubResult              *NFSDeleteStubResult
	BootStubResult                *NFSBootStubResult
	ShutdownStubResult            *NFSShutdownStubResult
	ResetStubResult               *NFSResetStubResult
	MonitorCPUStubResult          *NFSMonitorCPUStubResult
	MonitorFreeDiskSizeStubResult *NFSMonitorFreeDiskSizeStubResult
	MonitorInterfaceStubResult    *NFSMonitorInterfaceStubResult
}

// NewNFSStub creates new NFSStub instance
func NewNFSStub(caller iaas.APICaller) iaas.NFSAPI {
	return &NFSStub{}
}

// Find is API call with trace log
func (s *NFSStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.NFSFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("NFSStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *NFSStub) Create(ctx context.Context, zone string, param *iaas.NFSCreateRequest) (*iaas.NFS, error) {
	if s.CreateStubResult == nil {
		log.Fatal("NFSStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.NFS, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *NFSStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.NFS, error) {
	if s.ReadStubResult == nil {
		log.Fatal("NFSStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.NFS, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *NFSStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.NFSUpdateRequest) (*iaas.NFS, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("NFSStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.NFS, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *NFSStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("NFSStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Boot is API call with trace log
func (s *NFSStub) Boot(ctx context.Context, zone string, id types.ID) error {
	if s.BootStubResult == nil {
		log.Fatal("NFSStub.BootStubResult is not set")
	}
	return s.BootStubResult.Err
}

// Shutdown is API call with trace log
func (s *NFSStub) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	if s.ShutdownStubResult == nil {
		log.Fatal("NFSStub.ShutdownStubResult is not set")
	}
	return s.ShutdownStubResult.Err
}

// Reset is API call with trace log
func (s *NFSStub) Reset(ctx context.Context, zone string, id types.ID) error {
	if s.ResetStubResult == nil {
		log.Fatal("NFSStub.ResetStubResult is not set")
	}
	return s.ResetStubResult.Err
}

// MonitorCPU is API call with trace log
func (s *NFSStub) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	if s.MonitorCPUStubResult == nil {
		log.Fatal("NFSStub.MonitorCPUStubResult is not set")
	}
	return s.MonitorCPUStubResult.CPUTimeActivity, s.MonitorCPUStubResult.Err
}

// MonitorFreeDiskSize is API call with trace log
func (s *NFSStub) MonitorFreeDiskSize(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.FreeDiskSizeActivity, error) {
	if s.MonitorFreeDiskSizeStubResult == nil {
		log.Fatal("NFSStub.MonitorFreeDiskSizeStubResult is not set")
	}
	return s.MonitorFreeDiskSizeStubResult.FreeDiskSizeActivity, s.MonitorFreeDiskSizeStubResult.Err
}

// MonitorInterface is API call with trace log
func (s *NFSStub) MonitorInterface(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	if s.MonitorInterfaceStubResult == nil {
		log.Fatal("NFSStub.MonitorInterfaceStubResult is not set")
	}
	return s.MonitorInterfaceStubResult.InterfaceActivity, s.MonitorInterfaceStubResult.Err
}

/*************************************************
* NoteStub
*************************************************/

// NoteFindStubResult is expected values of the Find operation
type NoteFindStubResult struct {
	Values *iaas.NoteFindResult
	Err    error
}

// NoteCreateStubResult is expected values of the Create operation
type NoteCreateStubResult struct {
	Note *iaas.Note
	Err  error
}

// NoteReadStubResult is expected values of the Read operation
type NoteReadStubResult struct {
	Note *iaas.Note
	Err  error
}

// NoteUpdateStubResult is expected values of the Update operation
type NoteUpdateStubResult struct {
	Note *iaas.Note
	Err  error
}

// NoteDeleteStubResult is expected values of the Delete operation
type NoteDeleteStubResult struct {
	Err error
}

// NoteStub is for trace NoteOp operations
type NoteStub struct {
	FindStubResult   *NoteFindStubResult
	CreateStubResult *NoteCreateStubResult
	ReadStubResult   *NoteReadStubResult
	UpdateStubResult *NoteUpdateStubResult
	DeleteStubResult *NoteDeleteStubResult
}

// NewNoteStub creates new NoteStub instance
func NewNoteStub(caller iaas.APICaller) iaas.NoteAPI {
	return &NoteStub{}
}

// Find is API call with trace log
func (s *NoteStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.NoteFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("NoteStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *NoteStub) Create(ctx context.Context, param *iaas.NoteCreateRequest) (*iaas.Note, error) {
	if s.CreateStubResult == nil {
		log.Fatal("NoteStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Note, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *NoteStub) Read(ctx context.Context, id types.ID) (*iaas.Note, error) {
	if s.ReadStubResult == nil {
		log.Fatal("NoteStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Note, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *NoteStub) Update(ctx context.Context, id types.ID, param *iaas.NoteUpdateRequest) (*iaas.Note, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("NoteStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Note, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *NoteStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("NoteStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* PacketFilterStub
*************************************************/

// PacketFilterFindStubResult is expected values of the Find operation
type PacketFilterFindStubResult struct {
	Values *iaas.PacketFilterFindResult
	Err    error
}

// PacketFilterCreateStubResult is expected values of the Create operation
type PacketFilterCreateStubResult struct {
	PacketFilter *iaas.PacketFilter
	Err          error
}

// PacketFilterReadStubResult is expected values of the Read operation
type PacketFilterReadStubResult struct {
	PacketFilter *iaas.PacketFilter
	Err          error
}

// PacketFilterUpdateStubResult is expected values of the Update operation
type PacketFilterUpdateStubResult struct {
	PacketFilter *iaas.PacketFilter
	Err          error
}

// PacketFilterDeleteStubResult is expected values of the Delete operation
type PacketFilterDeleteStubResult struct {
	Err error
}

// PacketFilterStub is for trace PacketFilterOp operations
type PacketFilterStub struct {
	FindStubResult   *PacketFilterFindStubResult
	CreateStubResult *PacketFilterCreateStubResult
	ReadStubResult   *PacketFilterReadStubResult
	UpdateStubResult *PacketFilterUpdateStubResult
	DeleteStubResult *PacketFilterDeleteStubResult
}

// NewPacketFilterStub creates new PacketFilterStub instance
func NewPacketFilterStub(caller iaas.APICaller) iaas.PacketFilterAPI {
	return &PacketFilterStub{}
}

// Find is API call with trace log
func (s *PacketFilterStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.PacketFilterFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("PacketFilterStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *PacketFilterStub) Create(ctx context.Context, zone string, param *iaas.PacketFilterCreateRequest) (*iaas.PacketFilter, error) {
	if s.CreateStubResult == nil {
		log.Fatal("PacketFilterStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.PacketFilter, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *PacketFilterStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.PacketFilter, error) {
	if s.ReadStubResult == nil {
		log.Fatal("PacketFilterStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.PacketFilter, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *PacketFilterStub) Update(ctx context.Context, zone string, id types.ID, updateParam *iaas.PacketFilterUpdateRequest, originalExpressionHash string) (*iaas.PacketFilter, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("PacketFilterStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.PacketFilter, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *PacketFilterStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("PacketFilterStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* PrivateHostStub
*************************************************/

// PrivateHostFindStubResult is expected values of the Find operation
type PrivateHostFindStubResult struct {
	Values *iaas.PrivateHostFindResult
	Err    error
}

// PrivateHostCreateStubResult is expected values of the Create operation
type PrivateHostCreateStubResult struct {
	PrivateHost *iaas.PrivateHost
	Err         error
}

// PrivateHostReadStubResult is expected values of the Read operation
type PrivateHostReadStubResult struct {
	PrivateHost *iaas.PrivateHost
	Err         error
}

// PrivateHostUpdateStubResult is expected values of the Update operation
type PrivateHostUpdateStubResult struct {
	PrivateHost *iaas.PrivateHost
	Err         error
}

// PrivateHostDeleteStubResult is expected values of the Delete operation
type PrivateHostDeleteStubResult struct {
	Err error
}

// PrivateHostStub is for trace PrivateHostOp operations
type PrivateHostStub struct {
	FindStubResult   *PrivateHostFindStubResult
	CreateStubResult *PrivateHostCreateStubResult
	ReadStubResult   *PrivateHostReadStubResult
	UpdateStubResult *PrivateHostUpdateStubResult
	DeleteStubResult *PrivateHostDeleteStubResult
}

// NewPrivateHostStub creates new PrivateHostStub instance
func NewPrivateHostStub(caller iaas.APICaller) iaas.PrivateHostAPI {
	return &PrivateHostStub{}
}

// Find is API call with trace log
func (s *PrivateHostStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.PrivateHostFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("PrivateHostStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *PrivateHostStub) Create(ctx context.Context, zone string, param *iaas.PrivateHostCreateRequest) (*iaas.PrivateHost, error) {
	if s.CreateStubResult == nil {
		log.Fatal("PrivateHostStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.PrivateHost, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *PrivateHostStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.PrivateHost, error) {
	if s.ReadStubResult == nil {
		log.Fatal("PrivateHostStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.PrivateHost, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *PrivateHostStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.PrivateHostUpdateRequest) (*iaas.PrivateHost, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("PrivateHostStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.PrivateHost, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *PrivateHostStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("PrivateHostStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* PrivateHostPlanStub
*************************************************/

// PrivateHostPlanFindStubResult is expected values of the Find operation
type PrivateHostPlanFindStubResult struct {
	Values *iaas.PrivateHostPlanFindResult
	Err    error
}

// PrivateHostPlanReadStubResult is expected values of the Read operation
type PrivateHostPlanReadStubResult struct {
	PrivateHostPlan *iaas.PrivateHostPlan
	Err             error
}

// PrivateHostPlanStub is for trace PrivateHostPlanOp operations
type PrivateHostPlanStub struct {
	FindStubResult *PrivateHostPlanFindStubResult
	ReadStubResult *PrivateHostPlanReadStubResult
}

// NewPrivateHostPlanStub creates new PrivateHostPlanStub instance
func NewPrivateHostPlanStub(caller iaas.APICaller) iaas.PrivateHostPlanAPI {
	return &PrivateHostPlanStub{}
}

// Find is API call with trace log
func (s *PrivateHostPlanStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.PrivateHostPlanFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("PrivateHostPlanStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *PrivateHostPlanStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.PrivateHostPlan, error) {
	if s.ReadStubResult == nil {
		log.Fatal("PrivateHostPlanStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.PrivateHostPlan, s.ReadStubResult.Err
}

/*************************************************
* ProxyLBStub
*************************************************/

// ProxyLBFindStubResult is expected values of the Find operation
type ProxyLBFindStubResult struct {
	Values *iaas.ProxyLBFindResult
	Err    error
}

// ProxyLBCreateStubResult is expected values of the Create operation
type ProxyLBCreateStubResult struct {
	ProxyLB *iaas.ProxyLB
	Err     error
}

// ProxyLBReadStubResult is expected values of the Read operation
type ProxyLBReadStubResult struct {
	ProxyLB *iaas.ProxyLB
	Err     error
}

// ProxyLBUpdateStubResult is expected values of the Update operation
type ProxyLBUpdateStubResult struct {
	ProxyLB *iaas.ProxyLB
	Err     error
}

// ProxyLBUpdateSettingsStubResult is expected values of the UpdateSettings operation
type ProxyLBUpdateSettingsStubResult struct {
	ProxyLB *iaas.ProxyLB
	Err     error
}

// ProxyLBDeleteStubResult is expected values of the Delete operation
type ProxyLBDeleteStubResult struct {
	Err error
}

// ProxyLBChangePlanStubResult is expected values of the ChangePlan operation
type ProxyLBChangePlanStubResult struct {
	ProxyLB *iaas.ProxyLB
	Err     error
}

// ProxyLBGetCertificatesStubResult is expected values of the GetCertificates operation
type ProxyLBGetCertificatesStubResult struct {
	ProxyLBCertificates *iaas.ProxyLBCertificates
	Err                 error
}

// ProxyLBSetCertificatesStubResult is expected values of the SetCertificates operation
type ProxyLBSetCertificatesStubResult struct {
	ProxyLBCertificates *iaas.ProxyLBCertificates
	Err                 error
}

// ProxyLBDeleteCertificatesStubResult is expected values of the DeleteCertificates operation
type ProxyLBDeleteCertificatesStubResult struct {
	Err error
}

// ProxyLBRenewLetsEncryptCertStubResult is expected values of the RenewLetsEncryptCert operation
type ProxyLBRenewLetsEncryptCertStubResult struct {
	Err error
}

// ProxyLBHealthStatusStubResult is expected values of the HealthStatus operation
type ProxyLBHealthStatusStubResult struct {
	ProxyLBHealth *iaas.ProxyLBHealth
	Err           error
}

// ProxyLBMonitorConnectionStubResult is expected values of the MonitorConnection operation
type ProxyLBMonitorConnectionStubResult struct {
	ConnectionActivity *iaas.ConnectionActivity
	Err                error
}

// ProxyLBStub is for trace ProxyLBOp operations
type ProxyLBStub struct {
	FindStubResult                 *ProxyLBFindStubResult
	CreateStubResult               *ProxyLBCreateStubResult
	ReadStubResult                 *ProxyLBReadStubResult
	UpdateStubResult               *ProxyLBUpdateStubResult
	UpdateSettingsStubResult       *ProxyLBUpdateSettingsStubResult
	DeleteStubResult               *ProxyLBDeleteStubResult
	ChangePlanStubResult           *ProxyLBChangePlanStubResult
	GetCertificatesStubResult      *ProxyLBGetCertificatesStubResult
	SetCertificatesStubResult      *ProxyLBSetCertificatesStubResult
	DeleteCertificatesStubResult   *ProxyLBDeleteCertificatesStubResult
	RenewLetsEncryptCertStubResult *ProxyLBRenewLetsEncryptCertStubResult
	HealthStatusStubResult         *ProxyLBHealthStatusStubResult
	MonitorConnectionStubResult    *ProxyLBMonitorConnectionStubResult
}

// NewProxyLBStub creates new ProxyLBStub instance
func NewProxyLBStub(caller iaas.APICaller) iaas.ProxyLBAPI {
	return &ProxyLBStub{}
}

// Find is API call with trace log
func (s *ProxyLBStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ProxyLBFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ProxyLBStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *ProxyLBStub) Create(ctx context.Context, param *iaas.ProxyLBCreateRequest) (*iaas.ProxyLB, error) {
	if s.CreateStubResult == nil {
		log.Fatal("ProxyLBStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.ProxyLB, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *ProxyLBStub) Read(ctx context.Context, id types.ID) (*iaas.ProxyLB, error) {
	if s.ReadStubResult == nil {
		log.Fatal("ProxyLBStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.ProxyLB, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *ProxyLBStub) Update(ctx context.Context, id types.ID, param *iaas.ProxyLBUpdateRequest) (*iaas.ProxyLB, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("ProxyLBStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.ProxyLB, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *ProxyLBStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.ProxyLBUpdateSettingsRequest) (*iaas.ProxyLB, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("ProxyLBStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.ProxyLB, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *ProxyLBStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("ProxyLBStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// ChangePlan is API call with trace log
func (s *ProxyLBStub) ChangePlan(ctx context.Context, id types.ID, param *iaas.ProxyLBChangePlanRequest) (*iaas.ProxyLB, error) {
	if s.ChangePlanStubResult == nil {
		log.Fatal("ProxyLBStub.ChangePlanStubResult is not set")
	}
	return s.ChangePlanStubResult.ProxyLB, s.ChangePlanStubResult.Err
}

// GetCertificates is API call with trace log
func (s *ProxyLBStub) GetCertificates(ctx context.Context, id types.ID) (*iaas.ProxyLBCertificates, error) {
	if s.GetCertificatesStubResult == nil {
		log.Fatal("ProxyLBStub.GetCertificatesStubResult is not set")
	}
	return s.GetCertificatesStubResult.ProxyLBCertificates, s.GetCertificatesStubResult.Err
}

// SetCertificates is API call with trace log
func (s *ProxyLBStub) SetCertificates(ctx context.Context, id types.ID, param *iaas.ProxyLBSetCertificatesRequest) (*iaas.ProxyLBCertificates, error) {
	if s.SetCertificatesStubResult == nil {
		log.Fatal("ProxyLBStub.SetCertificatesStubResult is not set")
	}
	return s.SetCertificatesStubResult.ProxyLBCertificates, s.SetCertificatesStubResult.Err
}

// DeleteCertificates is API call with trace log
func (s *ProxyLBStub) DeleteCertificates(ctx context.Context, id types.ID) error {
	if s.DeleteCertificatesStubResult == nil {
		log.Fatal("ProxyLBStub.DeleteCertificatesStubResult is not set")
	}
	return s.DeleteCertificatesStubResult.Err
}

// RenewLetsEncryptCert is API call with trace log
func (s *ProxyLBStub) RenewLetsEncryptCert(ctx context.Context, id types.ID) error {
	if s.RenewLetsEncryptCertStubResult == nil {
		log.Fatal("ProxyLBStub.RenewLetsEncryptCertStubResult is not set")
	}
	return s.RenewLetsEncryptCertStubResult.Err
}

// HealthStatus is API call with trace log
func (s *ProxyLBStub) HealthStatus(ctx context.Context, id types.ID) (*iaas.ProxyLBHealth, error) {
	if s.HealthStatusStubResult == nil {
		log.Fatal("ProxyLBStub.HealthStatusStubResult is not set")
	}
	return s.HealthStatusStubResult.ProxyLBHealth, s.HealthStatusStubResult.Err
}

// MonitorConnection is API call with trace log
func (s *ProxyLBStub) MonitorConnection(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.ConnectionActivity, error) {
	if s.MonitorConnectionStubResult == nil {
		log.Fatal("ProxyLBStub.MonitorConnectionStubResult is not set")
	}
	return s.MonitorConnectionStubResult.ConnectionActivity, s.MonitorConnectionStubResult.Err
}

/*************************************************
* RegionStub
*************************************************/

// RegionFindStubResult is expected values of the Find operation
type RegionFindStubResult struct {
	Values *iaas.RegionFindResult
	Err    error
}

// RegionReadStubResult is expected values of the Read operation
type RegionReadStubResult struct {
	Region *iaas.Region
	Err    error
}

// RegionStub is for trace RegionOp operations
type RegionStub struct {
	FindStubResult *RegionFindStubResult
	ReadStubResult *RegionReadStubResult
}

// NewRegionStub creates new RegionStub instance
func NewRegionStub(caller iaas.APICaller) iaas.RegionAPI {
	return &RegionStub{}
}

// Find is API call with trace log
func (s *RegionStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.RegionFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("RegionStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *RegionStub) Read(ctx context.Context, id types.ID) (*iaas.Region, error) {
	if s.ReadStubResult == nil {
		log.Fatal("RegionStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Region, s.ReadStubResult.Err
}

/*************************************************
* ServerStub
*************************************************/

// ServerFindStubResult is expected values of the Find operation
type ServerFindStubResult struct {
	Values *iaas.ServerFindResult
	Err    error
}

// ServerCreateStubResult is expected values of the Create operation
type ServerCreateStubResult struct {
	Server *iaas.Server
	Err    error
}

// ServerReadStubResult is expected values of the Read operation
type ServerReadStubResult struct {
	Server *iaas.Server
	Err    error
}

// ServerUpdateStubResult is expected values of the Update operation
type ServerUpdateStubResult struct {
	Server *iaas.Server
	Err    error
}

// ServerDeleteStubResult is expected values of the Delete operation
type ServerDeleteStubResult struct {
	Err error
}

// ServerDeleteWithDisksStubResult is expected values of the DeleteWithDisks operation
type ServerDeleteWithDisksStubResult struct {
	Err error
}

// ServerChangePlanStubResult is expected values of the ChangePlan operation
type ServerChangePlanStubResult struct {
	Server *iaas.Server
	Err    error
}

// ServerInsertCDROMStubResult is expected values of the InsertCDROM operation
type ServerInsertCDROMStubResult struct {
	Err error
}

// ServerEjectCDROMStubResult is expected values of the EjectCDROM operation
type ServerEjectCDROMStubResult struct {
	Err error
}

// ServerBootStubResult is expected values of the Boot operation
type ServerBootStubResult struct {
	Err error
}

// ServerShutdownStubResult is expected values of the Shutdown operation
type ServerShutdownStubResult struct {
	Err error
}

// ServerResetStubResult is expected values of the Reset operation
type ServerResetStubResult struct {
	Err error
}

// ServerBootWithVariablesStubResult is expected values of the BootWithVariables operation
type ServerBootWithVariablesStubResult struct {
	Err error
}

// ServerSendKeyStubResult is expected values of the SendKey operation
type ServerSendKeyStubResult struct {
	Err error
}

// ServerSendNMIStubResult is expected values of the SendNMI operation
type ServerSendNMIStubResult struct {
	Err error
}

// ServerGetVNCProxyStubResult is expected values of the GetVNCProxy operation
type ServerGetVNCProxyStubResult struct {
	VNCProxyInfo *iaas.VNCProxyInfo
	Err          error
}

// ServerMonitorStubResult is expected values of the Monitor operation
type ServerMonitorStubResult struct {
	CPUTimeActivity *iaas.CPUTimeActivity
	Err             error
}

// ServerMonitorCPUStubResult is expected values of the MonitorCPU operation
type ServerMonitorCPUStubResult struct {
	CPUTimeActivity *iaas.CPUTimeActivity
	Err             error
}

// ServerStub is for trace ServerOp operations
type ServerStub struct {
	FindStubResult              *ServerFindStubResult
	CreateStubResult            *ServerCreateStubResult
	ReadStubResult              *ServerReadStubResult
	UpdateStubResult            *ServerUpdateStubResult
	DeleteStubResult            *ServerDeleteStubResult
	DeleteWithDisksStubResult   *ServerDeleteWithDisksStubResult
	ChangePlanStubResult        *ServerChangePlanStubResult
	InsertCDROMStubResult       *ServerInsertCDROMStubResult
	EjectCDROMStubResult        *ServerEjectCDROMStubResult
	BootStubResult              *ServerBootStubResult
	ShutdownStubResult          *ServerShutdownStubResult
	ResetStubResult             *ServerResetStubResult
	BootWithVariablesStubResult *ServerBootWithVariablesStubResult
	SendKeyStubResult           *ServerSendKeyStubResult
	SendNMIStubResult           *ServerSendNMIStubResult
	GetVNCProxyStubResult       *ServerGetVNCProxyStubResult
	MonitorStubResult           *ServerMonitorStubResult
	MonitorCPUStubResult        *ServerMonitorCPUStubResult
}

// NewServerStub creates new ServerStub instance
func NewServerStub(caller iaas.APICaller) iaas.ServerAPI {
	return &ServerStub{}
}

// Find is API call with trace log
func (s *ServerStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ServerFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ServerStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *ServerStub) Create(ctx context.Context, zone string, param *iaas.ServerCreateRequest) (*iaas.Server, error) {
	if s.CreateStubResult == nil {
		log.Fatal("ServerStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Server, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *ServerStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Server, error) {
	if s.ReadStubResult == nil {
		log.Fatal("ServerStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Server, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *ServerStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.ServerUpdateRequest) (*iaas.Server, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("ServerStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Server, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *ServerStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("ServerStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// DeleteWithDisks is API call with trace log
func (s *ServerStub) DeleteWithDisks(ctx context.Context, zone string, id types.ID, disks *iaas.ServerDeleteWithDisksRequest) error {
	if s.DeleteWithDisksStubResult == nil {
		log.Fatal("ServerStub.DeleteWithDisksStubResult is not set")
	}
	return s.DeleteWithDisksStubResult.Err
}

// ChangePlan is API call with trace log
func (s *ServerStub) ChangePlan(ctx context.Context, zone string, id types.ID, plan *iaas.ServerChangePlanRequest) (*iaas.Server, error) {
	if s.ChangePlanStubResult == nil {
		log.Fatal("ServerStub.ChangePlanStubResult is not set")
	}
	return s.ChangePlanStubResult.Server, s.ChangePlanStubResult.Err
}

// InsertCDROM is API call with trace log
func (s *ServerStub) InsertCDROM(ctx context.Context, zone string, id types.ID, insertParam *iaas.InsertCDROMRequest) error {
	if s.InsertCDROMStubResult == nil {
		log.Fatal("ServerStub.InsertCDROMStubResult is not set")
	}
	return s.InsertCDROMStubResult.Err
}

// EjectCDROM is API call with trace log
func (s *ServerStub) EjectCDROM(ctx context.Context, zone string, id types.ID, ejectParam *iaas.EjectCDROMRequest) error {
	if s.EjectCDROMStubResult == nil {
		log.Fatal("ServerStub.EjectCDROMStubResult is not set")
	}
	return s.EjectCDROMStubResult.Err
}

// Boot is API call with trace log
func (s *ServerStub) Boot(ctx context.Context, zone string, id types.ID) error {
	if s.BootStubResult == nil {
		log.Fatal("ServerStub.BootStubResult is not set")
	}
	return s.BootStubResult.Err
}

// Shutdown is API call with trace log
func (s *ServerStub) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	if s.ShutdownStubResult == nil {
		log.Fatal("ServerStub.ShutdownStubResult is not set")
	}
	return s.ShutdownStubResult.Err
}

// Reset is API call with trace log
func (s *ServerStub) Reset(ctx context.Context, zone string, id types.ID) error {
	if s.ResetStubResult == nil {
		log.Fatal("ServerStub.ResetStubResult is not set")
	}
	return s.ResetStubResult.Err
}

// BootWithVariables is API call with trace log
func (s *ServerStub) BootWithVariables(ctx context.Context, zone string, id types.ID, param *iaas.ServerBootVariables) error {
	if s.BootWithVariablesStubResult == nil {
		log.Fatal("ServerStub.BootWithVariablesStubResult is not set")
	}
	return s.BootWithVariablesStubResult.Err
}

// SendKey is API call with trace log
func (s *ServerStub) SendKey(ctx context.Context, zone string, id types.ID, keyboardParam *iaas.SendKeyRequest) error {
	if s.SendKeyStubResult == nil {
		log.Fatal("ServerStub.SendKeyStubResult is not set")
	}
	return s.SendKeyStubResult.Err
}

// SendNMI is API call with trace log
func (s *ServerStub) SendNMI(ctx context.Context, zone string, id types.ID) error {
	if s.SendNMIStubResult == nil {
		log.Fatal("ServerStub.SendNMIStubResult is not set")
	}
	return s.SendNMIStubResult.Err
}

// GetVNCProxy is API call with trace log
func (s *ServerStub) GetVNCProxy(ctx context.Context, zone string, id types.ID) (*iaas.VNCProxyInfo, error) {
	if s.GetVNCProxyStubResult == nil {
		log.Fatal("ServerStub.GetVNCProxyStubResult is not set")
	}
	return s.GetVNCProxyStubResult.VNCProxyInfo, s.GetVNCProxyStubResult.Err
}

// Monitor is API call with trace log
func (s *ServerStub) Monitor(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	if s.MonitorStubResult == nil {
		log.Fatal("ServerStub.MonitorStubResult is not set")
	}
	return s.MonitorStubResult.CPUTimeActivity, s.MonitorStubResult.Err
}

// MonitorCPU is API call with trace log
func (s *ServerStub) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	if s.MonitorCPUStubResult == nil {
		log.Fatal("ServerStub.MonitorCPUStubResult is not set")
	}
	return s.MonitorCPUStubResult.CPUTimeActivity, s.MonitorCPUStubResult.Err
}

/*************************************************
* ServerPlanStub
*************************************************/

// ServerPlanFindStubResult is expected values of the Find operation
type ServerPlanFindStubResult struct {
	Values *iaas.ServerPlanFindResult
	Err    error
}

// ServerPlanReadStubResult is expected values of the Read operation
type ServerPlanReadStubResult struct {
	ServerPlan *iaas.ServerPlan
	Err        error
}

// ServerPlanStub is for trace ServerPlanOp operations
type ServerPlanStub struct {
	FindStubResult *ServerPlanFindStubResult
	ReadStubResult *ServerPlanReadStubResult
}

// NewServerPlanStub creates new ServerPlanStub instance
func NewServerPlanStub(caller iaas.APICaller) iaas.ServerPlanAPI {
	return &ServerPlanStub{}
}

// Find is API call with trace log
func (s *ServerPlanStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ServerPlanFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ServerPlanStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *ServerPlanStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.ServerPlan, error) {
	if s.ReadStubResult == nil {
		log.Fatal("ServerPlanStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.ServerPlan, s.ReadStubResult.Err
}

/*************************************************
* ServiceClassStub
*************************************************/

// ServiceClassFindStubResult is expected values of the Find operation
type ServiceClassFindStubResult struct {
	Values *iaas.ServiceClassFindResult
	Err    error
}

// ServiceClassStub is for trace ServiceClassOp operations
type ServiceClassStub struct {
	FindStubResult *ServiceClassFindStubResult
}

// NewServiceClassStub creates new ServiceClassStub instance
func NewServiceClassStub(caller iaas.APICaller) iaas.ServiceClassAPI {
	return &ServiceClassStub{}
}

// Find is API call with trace log
func (s *ServiceClassStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.ServiceClassFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ServiceClassStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

/*************************************************
* SIMStub
*************************************************/

// SIMFindStubResult is expected values of the Find operation
type SIMFindStubResult struct {
	Values *iaas.SIMFindResult
	Err    error
}

// SIMCreateStubResult is expected values of the Create operation
type SIMCreateStubResult struct {
	SIM *iaas.SIM
	Err error
}

// SIMReadStubResult is expected values of the Read operation
type SIMReadStubResult struct {
	SIM *iaas.SIM
	Err error
}

// SIMUpdateStubResult is expected values of the Update operation
type SIMUpdateStubResult struct {
	SIM *iaas.SIM
	Err error
}

// SIMDeleteStubResult is expected values of the Delete operation
type SIMDeleteStubResult struct {
	Err error
}

// SIMActivateStubResult is expected values of the Activate operation
type SIMActivateStubResult struct {
	Err error
}

// SIMDeactivateStubResult is expected values of the Deactivate operation
type SIMDeactivateStubResult struct {
	Err error
}

// SIMAssignIPStubResult is expected values of the AssignIP operation
type SIMAssignIPStubResult struct {
	Err error
}

// SIMClearIPStubResult is expected values of the ClearIP operation
type SIMClearIPStubResult struct {
	Err error
}

// SIMIMEILockStubResult is expected values of the IMEILock operation
type SIMIMEILockStubResult struct {
	Err error
}

// SIMIMEIUnlockStubResult is expected values of the IMEIUnlock operation
type SIMIMEIUnlockStubResult struct {
	Err error
}

// SIMLogsStubResult is expected values of the Logs operation
type SIMLogsStubResult struct {
	Values *iaas.SIMLogsResult
	Err    error
}

// SIMGetNetworkOperatorStubResult is expected values of the GetNetworkOperator operation
type SIMGetNetworkOperatorStubResult struct {
	Configs []*iaas.SIMNetworkOperatorConfig
	Err     error
}

// SIMSetNetworkOperatorStubResult is expected values of the SetNetworkOperator operation
type SIMSetNetworkOperatorStubResult struct {
	Err error
}

// SIMMonitorSIMStubResult is expected values of the MonitorSIM operation
type SIMMonitorSIMStubResult struct {
	LinkActivity *iaas.LinkActivity
	Err          error
}

// SIMStatusStubResult is expected values of the Status operation
type SIMStatusStubResult struct {
	SIM *iaas.SIMInfo
	Err error
}

// SIMStub is for trace SIMOp operations
type SIMStub struct {
	FindStubResult               *SIMFindStubResult
	CreateStubResult             *SIMCreateStubResult
	ReadStubResult               *SIMReadStubResult
	UpdateStubResult             *SIMUpdateStubResult
	DeleteStubResult             *SIMDeleteStubResult
	ActivateStubResult           *SIMActivateStubResult
	DeactivateStubResult         *SIMDeactivateStubResult
	AssignIPStubResult           *SIMAssignIPStubResult
	ClearIPStubResult            *SIMClearIPStubResult
	IMEILockStubResult           *SIMIMEILockStubResult
	IMEIUnlockStubResult         *SIMIMEIUnlockStubResult
	LogsStubResult               *SIMLogsStubResult
	GetNetworkOperatorStubResult *SIMGetNetworkOperatorStubResult
	SetNetworkOperatorStubResult *SIMSetNetworkOperatorStubResult
	MonitorSIMStubResult         *SIMMonitorSIMStubResult
	StatusStubResult             *SIMStatusStubResult
}

// NewSIMStub creates new SIMStub instance
func NewSIMStub(caller iaas.APICaller) iaas.SIMAPI {
	return &SIMStub{}
}

// Find is API call with trace log
func (s *SIMStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SIMFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("SIMStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *SIMStub) Create(ctx context.Context, param *iaas.SIMCreateRequest) (*iaas.SIM, error) {
	if s.CreateStubResult == nil {
		log.Fatal("SIMStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.SIM, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *SIMStub) Read(ctx context.Context, id types.ID) (*iaas.SIM, error) {
	if s.ReadStubResult == nil {
		log.Fatal("SIMStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.SIM, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *SIMStub) Update(ctx context.Context, id types.ID, param *iaas.SIMUpdateRequest) (*iaas.SIM, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("SIMStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.SIM, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *SIMStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("SIMStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Activate is API call with trace log
func (s *SIMStub) Activate(ctx context.Context, id types.ID) error {
	if s.ActivateStubResult == nil {
		log.Fatal("SIMStub.ActivateStubResult is not set")
	}
	return s.ActivateStubResult.Err
}

// Deactivate is API call with trace log
func (s *SIMStub) Deactivate(ctx context.Context, id types.ID) error {
	if s.DeactivateStubResult == nil {
		log.Fatal("SIMStub.DeactivateStubResult is not set")
	}
	return s.DeactivateStubResult.Err
}

// AssignIP is API call with trace log
func (s *SIMStub) AssignIP(ctx context.Context, id types.ID, param *iaas.SIMAssignIPRequest) error {
	if s.AssignIPStubResult == nil {
		log.Fatal("SIMStub.AssignIPStubResult is not set")
	}
	return s.AssignIPStubResult.Err
}

// ClearIP is API call with trace log
func (s *SIMStub) ClearIP(ctx context.Context, id types.ID) error {
	if s.ClearIPStubResult == nil {
		log.Fatal("SIMStub.ClearIPStubResult is not set")
	}
	return s.ClearIPStubResult.Err
}

// IMEILock is API call with trace log
func (s *SIMStub) IMEILock(ctx context.Context, id types.ID, param *iaas.SIMIMEILockRequest) error {
	if s.IMEILockStubResult == nil {
		log.Fatal("SIMStub.IMEILockStubResult is not set")
	}
	return s.IMEILockStubResult.Err
}

// IMEIUnlock is API call with trace log
func (s *SIMStub) IMEIUnlock(ctx context.Context, id types.ID) error {
	if s.IMEIUnlockStubResult == nil {
		log.Fatal("SIMStub.IMEIUnlockStubResult is not set")
	}
	return s.IMEIUnlockStubResult.Err
}

// Logs is API call with trace log
func (s *SIMStub) Logs(ctx context.Context, id types.ID) (*iaas.SIMLogsResult, error) {
	if s.LogsStubResult == nil {
		log.Fatal("SIMStub.LogsStubResult is not set")
	}
	return s.LogsStubResult.Values, s.LogsStubResult.Err
}

// GetNetworkOperator is API call with trace log
func (s *SIMStub) GetNetworkOperator(ctx context.Context, id types.ID) ([]*iaas.SIMNetworkOperatorConfig, error) {
	if s.GetNetworkOperatorStubResult == nil {
		log.Fatal("SIMStub.GetNetworkOperatorStubResult is not set")
	}
	return s.GetNetworkOperatorStubResult.Configs, s.GetNetworkOperatorStubResult.Err
}

// SetNetworkOperator is API call with trace log
func (s *SIMStub) SetNetworkOperator(ctx context.Context, id types.ID, configs []*iaas.SIMNetworkOperatorConfig) error {
	if s.SetNetworkOperatorStubResult == nil {
		log.Fatal("SIMStub.SetNetworkOperatorStubResult is not set")
	}
	return s.SetNetworkOperatorStubResult.Err
}

// MonitorSIM is API call with trace log
func (s *SIMStub) MonitorSIM(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.LinkActivity, error) {
	if s.MonitorSIMStubResult == nil {
		log.Fatal("SIMStub.MonitorSIMStubResult is not set")
	}
	return s.MonitorSIMStubResult.LinkActivity, s.MonitorSIMStubResult.Err
}

// Status is API call with trace log
func (s *SIMStub) Status(ctx context.Context, id types.ID) (*iaas.SIMInfo, error) {
	if s.StatusStubResult == nil {
		log.Fatal("SIMStub.StatusStubResult is not set")
	}
	return s.StatusStubResult.SIM, s.StatusStubResult.Err
}

/*************************************************
* SimpleMonitorStub
*************************************************/

// SimpleMonitorFindStubResult is expected values of the Find operation
type SimpleMonitorFindStubResult struct {
	Values *iaas.SimpleMonitorFindResult
	Err    error
}

// SimpleMonitorCreateStubResult is expected values of the Create operation
type SimpleMonitorCreateStubResult struct {
	SimpleMonitor *iaas.SimpleMonitor
	Err           error
}

// SimpleMonitorReadStubResult is expected values of the Read operation
type SimpleMonitorReadStubResult struct {
	SimpleMonitor *iaas.SimpleMonitor
	Err           error
}

// SimpleMonitorUpdateStubResult is expected values of the Update operation
type SimpleMonitorUpdateStubResult struct {
	SimpleMonitor *iaas.SimpleMonitor
	Err           error
}

// SimpleMonitorUpdateSettingsStubResult is expected values of the UpdateSettings operation
type SimpleMonitorUpdateSettingsStubResult struct {
	SimpleMonitor *iaas.SimpleMonitor
	Err           error
}

// SimpleMonitorDeleteStubResult is expected values of the Delete operation
type SimpleMonitorDeleteStubResult struct {
	Err error
}

// SimpleMonitorMonitorResponseTimeStubResult is expected values of the MonitorResponseTime operation
type SimpleMonitorMonitorResponseTimeStubResult struct {
	ResponseTimeSecActivity *iaas.ResponseTimeSecActivity
	Err                     error
}

// SimpleMonitorHealthStatusStubResult is expected values of the HealthStatus operation
type SimpleMonitorHealthStatusStubResult struct {
	SimpleMonitorHealthStatus *iaas.SimpleMonitorHealthStatus
	Err                       error
}

// SimpleMonitorStub is for trace SimpleMonitorOp operations
type SimpleMonitorStub struct {
	FindStubResult                *SimpleMonitorFindStubResult
	CreateStubResult              *SimpleMonitorCreateStubResult
	ReadStubResult                *SimpleMonitorReadStubResult
	UpdateStubResult              *SimpleMonitorUpdateStubResult
	UpdateSettingsStubResult      *SimpleMonitorUpdateSettingsStubResult
	DeleteStubResult              *SimpleMonitorDeleteStubResult
	MonitorResponseTimeStubResult *SimpleMonitorMonitorResponseTimeStubResult
	HealthStatusStubResult        *SimpleMonitorHealthStatusStubResult
}

// NewSimpleMonitorStub creates new SimpleMonitorStub instance
func NewSimpleMonitorStub(caller iaas.APICaller) iaas.SimpleMonitorAPI {
	return &SimpleMonitorStub{}
}

// Find is API call with trace log
func (s *SimpleMonitorStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SimpleMonitorFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("SimpleMonitorStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *SimpleMonitorStub) Create(ctx context.Context, param *iaas.SimpleMonitorCreateRequest) (*iaas.SimpleMonitor, error) {
	if s.CreateStubResult == nil {
		log.Fatal("SimpleMonitorStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.SimpleMonitor, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *SimpleMonitorStub) Read(ctx context.Context, id types.ID) (*iaas.SimpleMonitor, error) {
	if s.ReadStubResult == nil {
		log.Fatal("SimpleMonitorStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.SimpleMonitor, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *SimpleMonitorStub) Update(ctx context.Context, id types.ID, param *iaas.SimpleMonitorUpdateRequest) (*iaas.SimpleMonitor, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("SimpleMonitorStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.SimpleMonitor, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *SimpleMonitorStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.SimpleMonitorUpdateSettingsRequest) (*iaas.SimpleMonitor, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("SimpleMonitorStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.SimpleMonitor, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *SimpleMonitorStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("SimpleMonitorStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// MonitorResponseTime is API call with trace log
func (s *SimpleMonitorStub) MonitorResponseTime(ctx context.Context, id types.ID, condition *iaas.MonitorCondition) (*iaas.ResponseTimeSecActivity, error) {
	if s.MonitorResponseTimeStubResult == nil {
		log.Fatal("SimpleMonitorStub.MonitorResponseTimeStubResult is not set")
	}
	return s.MonitorResponseTimeStubResult.ResponseTimeSecActivity, s.MonitorResponseTimeStubResult.Err
}

// HealthStatus is API call with trace log
func (s *SimpleMonitorStub) HealthStatus(ctx context.Context, id types.ID) (*iaas.SimpleMonitorHealthStatus, error) {
	if s.HealthStatusStubResult == nil {
		log.Fatal("SimpleMonitorStub.HealthStatusStubResult is not set")
	}
	return s.HealthStatusStubResult.SimpleMonitorHealthStatus, s.HealthStatusStubResult.Err
}

/*************************************************
* SimpleNotificationDestinationStub
*************************************************/

// SimpleNotificationDestinationFindStubResult is expected values of the Find operation
type SimpleNotificationDestinationFindStubResult struct {
	Values *iaas.SimpleNotificationDestinationFindResult
	Err    error
}

// SimpleNotificationDestinationCreateStubResult is expected values of the Create operation
type SimpleNotificationDestinationCreateStubResult struct {
	SimpleNotificationDestination *iaas.SimpleNotificationDestination
	Err                           error
}

// SimpleNotificationDestinationReadStubResult is expected values of the Read operation
type SimpleNotificationDestinationReadStubResult struct {
	SimpleNotificationDestination *iaas.SimpleNotificationDestination
	Err                           error
}

// SimpleNotificationDestinationUpdateStubResult is expected values of the Update operation
type SimpleNotificationDestinationUpdateStubResult struct {
	SimpleNotificationDestination *iaas.SimpleNotificationDestination
	Err                           error
}

// SimpleNotificationDestinationUpdateSettingsStubResult is expected values of the UpdateSettings operation
type SimpleNotificationDestinationUpdateSettingsStubResult struct {
	SimpleNotificationDestination *iaas.SimpleNotificationDestination
	Err                           error
}

// SimpleNotificationDestinationDeleteStubResult is expected values of the Delete operation
type SimpleNotificationDestinationDeleteStubResult struct {
	Err error
}

// SimpleNotificationDestinationStatusStubResult is expected values of the Status operation
type SimpleNotificationDestinationStatusStubResult struct {
	SimpleNotificationDestinationStatus *iaas.SimpleNotificationDestinationStatus
	Err                                 error
}

// SimpleNotificationDestinationStub is for trace SimpleNotificationDestinationOp operations
type SimpleNotificationDestinationStub struct {
	FindStubResult           *SimpleNotificationDestinationFindStubResult
	CreateStubResult         *SimpleNotificationDestinationCreateStubResult
	ReadStubResult           *SimpleNotificationDestinationReadStubResult
	UpdateStubResult         *SimpleNotificationDestinationUpdateStubResult
	UpdateSettingsStubResult *SimpleNotificationDestinationUpdateSettingsStubResult
	DeleteStubResult         *SimpleNotificationDestinationDeleteStubResult
	StatusStubResult         *SimpleNotificationDestinationStatusStubResult
}

// NewSimpleNotificationDestinationStub creates new SimpleNotificationDestinationStub instance
func NewSimpleNotificationDestinationStub(caller iaas.APICaller) iaas.SimpleNotificationDestinationAPI {
	return &SimpleNotificationDestinationStub{}
}

// Find is API call with trace log
func (s *SimpleNotificationDestinationStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SimpleNotificationDestinationFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("SimpleNotificationDestinationStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *SimpleNotificationDestinationStub) Create(ctx context.Context, param *iaas.SimpleNotificationDestinationCreateRequest) (*iaas.SimpleNotificationDestination, error) {
	if s.CreateStubResult == nil {
		log.Fatal("SimpleNotificationDestinationStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.SimpleNotificationDestination, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *SimpleNotificationDestinationStub) Read(ctx context.Context, id types.ID) (*iaas.SimpleNotificationDestination, error) {
	if s.ReadStubResult == nil {
		log.Fatal("SimpleNotificationDestinationStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.SimpleNotificationDestination, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *SimpleNotificationDestinationStub) Update(ctx context.Context, id types.ID, param *iaas.SimpleNotificationDestinationUpdateRequest) (*iaas.SimpleNotificationDestination, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("SimpleNotificationDestinationStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.SimpleNotificationDestination, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *SimpleNotificationDestinationStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.SimpleNotificationDestinationUpdateSettingsRequest) (*iaas.SimpleNotificationDestination, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("SimpleNotificationDestinationStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.SimpleNotificationDestination, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *SimpleNotificationDestinationStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("SimpleNotificationDestinationStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Status is API call with trace log
func (s *SimpleNotificationDestinationStub) Status(ctx context.Context, id types.ID) (*iaas.SimpleNotificationDestinationStatus, error) {
	if s.StatusStubResult == nil {
		log.Fatal("SimpleNotificationDestinationStub.StatusStubResult is not set")
	}
	return s.StatusStubResult.SimpleNotificationDestinationStatus, s.StatusStubResult.Err
}

/*************************************************
* SimpleNotificationGroupStub
*************************************************/

// SimpleNotificationGroupFindStubResult is expected values of the Find operation
type SimpleNotificationGroupFindStubResult struct {
	Values *iaas.SimpleNotificationGroupFindResult
	Err    error
}

// SimpleNotificationGroupCreateStubResult is expected values of the Create operation
type SimpleNotificationGroupCreateStubResult struct {
	SimpleNotificationGroup *iaas.SimpleNotificationGroup
	Err                     error
}

// SimpleNotificationGroupReadStubResult is expected values of the Read operation
type SimpleNotificationGroupReadStubResult struct {
	SimpleNotificationGroup *iaas.SimpleNotificationGroup
	Err                     error
}

// SimpleNotificationGroupUpdateStubResult is expected values of the Update operation
type SimpleNotificationGroupUpdateStubResult struct {
	SimpleNotificationGroup *iaas.SimpleNotificationGroup
	Err                     error
}

// SimpleNotificationGroupUpdateSettingsStubResult is expected values of the UpdateSettings operation
type SimpleNotificationGroupUpdateSettingsStubResult struct {
	SimpleNotificationGroup *iaas.SimpleNotificationGroup
	Err                     error
}

// SimpleNotificationGroupDeleteStubResult is expected values of the Delete operation
type SimpleNotificationGroupDeleteStubResult struct {
	Err error
}

// SimpleNotificationGroupPostMessageStubResult is expected values of the PostMessage operation
type SimpleNotificationGroupPostMessageStubResult struct {
	Err error
}

// SimpleNotificationGroupHistoryStubResult is expected values of the History operation
type SimpleNotificationGroupHistoryStubResult struct {
	SimpleNotificationHistories *iaas.SimpleNotificationHistories
	Err                         error
}

// SimpleNotificationGroupStub is for trace SimpleNotificationGroupOp operations
type SimpleNotificationGroupStub struct {
	FindStubResult           *SimpleNotificationGroupFindStubResult
	CreateStubResult         *SimpleNotificationGroupCreateStubResult
	ReadStubResult           *SimpleNotificationGroupReadStubResult
	UpdateStubResult         *SimpleNotificationGroupUpdateStubResult
	UpdateSettingsStubResult *SimpleNotificationGroupUpdateSettingsStubResult
	DeleteStubResult         *SimpleNotificationGroupDeleteStubResult
	PostMessageStubResult    *SimpleNotificationGroupPostMessageStubResult
	HistoryStubResult        *SimpleNotificationGroupHistoryStubResult
}

// NewSimpleNotificationGroupStub creates new SimpleNotificationGroupStub instance
func NewSimpleNotificationGroupStub(caller iaas.APICaller) iaas.SimpleNotificationGroupAPI {
	return &SimpleNotificationGroupStub{}
}

// Find is API call with trace log
func (s *SimpleNotificationGroupStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SimpleNotificationGroupFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *SimpleNotificationGroupStub) Create(ctx context.Context, param *iaas.SimpleNotificationGroupCreateRequest) (*iaas.SimpleNotificationGroup, error) {
	if s.CreateStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.SimpleNotificationGroup, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *SimpleNotificationGroupStub) Read(ctx context.Context, id types.ID) (*iaas.SimpleNotificationGroup, error) {
	if s.ReadStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.SimpleNotificationGroup, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *SimpleNotificationGroupStub) Update(ctx context.Context, id types.ID, param *iaas.SimpleNotificationGroupUpdateRequest) (*iaas.SimpleNotificationGroup, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.SimpleNotificationGroup, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *SimpleNotificationGroupStub) UpdateSettings(ctx context.Context, id types.ID, param *iaas.SimpleNotificationGroupUpdateSettingsRequest) (*iaas.SimpleNotificationGroup, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.SimpleNotificationGroup, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *SimpleNotificationGroupStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// PostMessage is API call with trace log
func (s *SimpleNotificationGroupStub) PostMessage(ctx context.Context, id types.ID, message string) error {
	if s.PostMessageStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.PostMessageStubResult is not set")
	}
	return s.PostMessageStubResult.Err
}

// History is API call with trace log
func (s *SimpleNotificationGroupStub) History(ctx context.Context) (*iaas.SimpleNotificationHistories, error) {
	if s.HistoryStubResult == nil {
		log.Fatal("SimpleNotificationGroupStub.HistoryStubResult is not set")
	}
	return s.HistoryStubResult.SimpleNotificationHistories, s.HistoryStubResult.Err
}

/*************************************************
* SSHKeyStub
*************************************************/

// SSHKeyFindStubResult is expected values of the Find operation
type SSHKeyFindStubResult struct {
	Values *iaas.SSHKeyFindResult
	Err    error
}

// SSHKeyCreateStubResult is expected values of the Create operation
type SSHKeyCreateStubResult struct {
	SSHKey *iaas.SSHKey
	Err    error
}

// SSHKeyReadStubResult is expected values of the Read operation
type SSHKeyReadStubResult struct {
	SSHKey *iaas.SSHKey
	Err    error
}

// SSHKeyUpdateStubResult is expected values of the Update operation
type SSHKeyUpdateStubResult struct {
	SSHKey *iaas.SSHKey
	Err    error
}

// SSHKeyDeleteStubResult is expected values of the Delete operation
type SSHKeyDeleteStubResult struct {
	Err error
}

// SSHKeyStub is for trace SSHKeyOp operations
type SSHKeyStub struct {
	FindStubResult   *SSHKeyFindStubResult
	CreateStubResult *SSHKeyCreateStubResult
	ReadStubResult   *SSHKeyReadStubResult
	UpdateStubResult *SSHKeyUpdateStubResult
	DeleteStubResult *SSHKeyDeleteStubResult
}

// NewSSHKeyStub creates new SSHKeyStub instance
func NewSSHKeyStub(caller iaas.APICaller) iaas.SSHKeyAPI {
	return &SSHKeyStub{}
}

// Find is API call with trace log
func (s *SSHKeyStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.SSHKeyFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("SSHKeyStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *SSHKeyStub) Create(ctx context.Context, param *iaas.SSHKeyCreateRequest) (*iaas.SSHKey, error) {
	if s.CreateStubResult == nil {
		log.Fatal("SSHKeyStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.SSHKey, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *SSHKeyStub) Read(ctx context.Context, id types.ID) (*iaas.SSHKey, error) {
	if s.ReadStubResult == nil {
		log.Fatal("SSHKeyStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.SSHKey, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *SSHKeyStub) Update(ctx context.Context, id types.ID, param *iaas.SSHKeyUpdateRequest) (*iaas.SSHKey, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("SSHKeyStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.SSHKey, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *SSHKeyStub) Delete(ctx context.Context, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("SSHKeyStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

/*************************************************
* SubnetStub
*************************************************/

// SubnetFindStubResult is expected values of the Find operation
type SubnetFindStubResult struct {
	Values *iaas.SubnetFindResult
	Err    error
}

// SubnetReadStubResult is expected values of the Read operation
type SubnetReadStubResult struct {
	Subnet *iaas.Subnet
	Err    error
}

// SubnetStub is for trace SubnetOp operations
type SubnetStub struct {
	FindStubResult *SubnetFindStubResult
	ReadStubResult *SubnetReadStubResult
}

// NewSubnetStub creates new SubnetStub instance
func NewSubnetStub(caller iaas.APICaller) iaas.SubnetAPI {
	return &SubnetStub{}
}

// Find is API call with trace log
func (s *SubnetStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.SubnetFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("SubnetStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *SubnetStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Subnet, error) {
	if s.ReadStubResult == nil {
		log.Fatal("SubnetStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Subnet, s.ReadStubResult.Err
}

/*************************************************
* SwitchStub
*************************************************/

// SwitchFindStubResult is expected values of the Find operation
type SwitchFindStubResult struct {
	Values *iaas.SwitchFindResult
	Err    error
}

// SwitchCreateStubResult is expected values of the Create operation
type SwitchCreateStubResult struct {
	Switch *iaas.Switch
	Err    error
}

// SwitchReadStubResult is expected values of the Read operation
type SwitchReadStubResult struct {
	Switch *iaas.Switch
	Err    error
}

// SwitchUpdateStubResult is expected values of the Update operation
type SwitchUpdateStubResult struct {
	Switch *iaas.Switch
	Err    error
}

// SwitchDeleteStubResult is expected values of the Delete operation
type SwitchDeleteStubResult struct {
	Err error
}

// SwitchConnectToBridgeStubResult is expected values of the ConnectToBridge operation
type SwitchConnectToBridgeStubResult struct {
	Err error
}

// SwitchDisconnectFromBridgeStubResult is expected values of the DisconnectFromBridge operation
type SwitchDisconnectFromBridgeStubResult struct {
	Err error
}

// SwitchGetServersStubResult is expected values of the GetServers operation
type SwitchGetServersStubResult struct {
	Values *iaas.SwitchGetServersResult
	Err    error
}

// SwitchStub is for trace SwitchOp operations
type SwitchStub struct {
	FindStubResult                 *SwitchFindStubResult
	CreateStubResult               *SwitchCreateStubResult
	ReadStubResult                 *SwitchReadStubResult
	UpdateStubResult               *SwitchUpdateStubResult
	DeleteStubResult               *SwitchDeleteStubResult
	ConnectToBridgeStubResult      *SwitchConnectToBridgeStubResult
	DisconnectFromBridgeStubResult *SwitchDisconnectFromBridgeStubResult
	GetServersStubResult           *SwitchGetServersStubResult
}

// NewSwitchStub creates new SwitchStub instance
func NewSwitchStub(caller iaas.APICaller) iaas.SwitchAPI {
	return &SwitchStub{}
}

// Find is API call with trace log
func (s *SwitchStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.SwitchFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("SwitchStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *SwitchStub) Create(ctx context.Context, zone string, param *iaas.SwitchCreateRequest) (*iaas.Switch, error) {
	if s.CreateStubResult == nil {
		log.Fatal("SwitchStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.Switch, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *SwitchStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.Switch, error) {
	if s.ReadStubResult == nil {
		log.Fatal("SwitchStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Switch, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *SwitchStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.SwitchUpdateRequest) (*iaas.Switch, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("SwitchStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.Switch, s.UpdateStubResult.Err
}

// Delete is API call with trace log
func (s *SwitchStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("SwitchStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// ConnectToBridge is API call with trace log
func (s *SwitchStub) ConnectToBridge(ctx context.Context, zone string, id types.ID, bridgeID types.ID) error {
	if s.ConnectToBridgeStubResult == nil {
		log.Fatal("SwitchStub.ConnectToBridgeStubResult is not set")
	}
	return s.ConnectToBridgeStubResult.Err
}

// DisconnectFromBridge is API call with trace log
func (s *SwitchStub) DisconnectFromBridge(ctx context.Context, zone string, id types.ID) error {
	if s.DisconnectFromBridgeStubResult == nil {
		log.Fatal("SwitchStub.DisconnectFromBridgeStubResult is not set")
	}
	return s.DisconnectFromBridgeStubResult.Err
}

// GetServers is API call with trace log
func (s *SwitchStub) GetServers(ctx context.Context, zone string, id types.ID) (*iaas.SwitchGetServersResult, error) {
	if s.GetServersStubResult == nil {
		log.Fatal("SwitchStub.GetServersStubResult is not set")
	}
	return s.GetServersStubResult.Values, s.GetServersStubResult.Err
}

/*************************************************
* VPCRouterStub
*************************************************/

// VPCRouterFindStubResult is expected values of the Find operation
type VPCRouterFindStubResult struct {
	Values *iaas.VPCRouterFindResult
	Err    error
}

// VPCRouterCreateStubResult is expected values of the Create operation
type VPCRouterCreateStubResult struct {
	VPCRouter *iaas.VPCRouter
	Err       error
}

// VPCRouterReadStubResult is expected values of the Read operation
type VPCRouterReadStubResult struct {
	VPCRouter *iaas.VPCRouter
	Err       error
}

// VPCRouterUpdateStubResult is expected values of the Update operation
type VPCRouterUpdateStubResult struct {
	VPCRouter *iaas.VPCRouter
	Err       error
}

// VPCRouterUpdateSettingsStubResult is expected values of the UpdateSettings operation
type VPCRouterUpdateSettingsStubResult struct {
	VPCRouter *iaas.VPCRouter
	Err       error
}

// VPCRouterDeleteStubResult is expected values of the Delete operation
type VPCRouterDeleteStubResult struct {
	Err error
}

// VPCRouterConfigStubResult is expected values of the Config operation
type VPCRouterConfigStubResult struct {
	Err error
}

// VPCRouterBootStubResult is expected values of the Boot operation
type VPCRouterBootStubResult struct {
	Err error
}

// VPCRouterShutdownStubResult is expected values of the Shutdown operation
type VPCRouterShutdownStubResult struct {
	Err error
}

// VPCRouterResetStubResult is expected values of the Reset operation
type VPCRouterResetStubResult struct {
	Err error
}

// VPCRouterConnectToSwitchStubResult is expected values of the ConnectToSwitch operation
type VPCRouterConnectToSwitchStubResult struct {
	Err error
}

// VPCRouterDisconnectFromSwitchStubResult is expected values of the DisconnectFromSwitch operation
type VPCRouterDisconnectFromSwitchStubResult struct {
	Err error
}

// VPCRouterMonitorCPUStubResult is expected values of the MonitorCPU operation
type VPCRouterMonitorCPUStubResult struct {
	CPUTimeActivity *iaas.CPUTimeActivity
	Err             error
}

// VPCRouterMonitorInterfaceStubResult is expected values of the MonitorInterface operation
type VPCRouterMonitorInterfaceStubResult struct {
	InterfaceActivity *iaas.InterfaceActivity
	Err               error
}

// VPCRouterStatusStubResult is expected values of the Status operation
type VPCRouterStatusStubResult struct {
	VPCRouterStatus *iaas.VPCRouterStatus
	Err             error
}

// VPCRouterLogsStubResult is expected values of the Logs operation
type VPCRouterLogsStubResult struct {
	VPCRouterLog *iaas.VPCRouterLog
	Err          error
}

// VPCRouterPingStubResult is expected values of the Ping operation
type VPCRouterPingStubResult struct {
	VPCRouterPingResults *iaas.VPCRouterPingResults
	Err                  error
}

// VPCRouterStub is for trace VPCRouterOp operations
type VPCRouterStub struct {
	FindStubResult                 *VPCRouterFindStubResult
	CreateStubResult               *VPCRouterCreateStubResult
	ReadStubResult                 *VPCRouterReadStubResult
	UpdateStubResult               *VPCRouterUpdateStubResult
	UpdateSettingsStubResult       *VPCRouterUpdateSettingsStubResult
	DeleteStubResult               *VPCRouterDeleteStubResult
	ConfigStubResult               *VPCRouterConfigStubResult
	BootStubResult                 *VPCRouterBootStubResult
	ShutdownStubResult             *VPCRouterShutdownStubResult
	ResetStubResult                *VPCRouterResetStubResult
	ConnectToSwitchStubResult      *VPCRouterConnectToSwitchStubResult
	DisconnectFromSwitchStubResult *VPCRouterDisconnectFromSwitchStubResult
	MonitorCPUStubResult           *VPCRouterMonitorCPUStubResult
	MonitorInterfaceStubResult     *VPCRouterMonitorInterfaceStubResult
	StatusStubResult               *VPCRouterStatusStubResult
	LogsStubResult                 *VPCRouterLogsStubResult
	PingStubResult                 *VPCRouterPingStubResult
}

// NewVPCRouterStub creates new VPCRouterStub instance
func NewVPCRouterStub(caller iaas.APICaller) iaas.VPCRouterAPI {
	return &VPCRouterStub{}
}

// Find is API call with trace log
func (s *VPCRouterStub) Find(ctx context.Context, zone string, conditions *iaas.FindCondition) (*iaas.VPCRouterFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("VPCRouterStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Create is API call with trace log
func (s *VPCRouterStub) Create(ctx context.Context, zone string, param *iaas.VPCRouterCreateRequest) (*iaas.VPCRouter, error) {
	if s.CreateStubResult == nil {
		log.Fatal("VPCRouterStub.CreateStubResult is not set")
	}
	return s.CreateStubResult.VPCRouter, s.CreateStubResult.Err
}

// Read is API call with trace log
func (s *VPCRouterStub) Read(ctx context.Context, zone string, id types.ID) (*iaas.VPCRouter, error) {
	if s.ReadStubResult == nil {
		log.Fatal("VPCRouterStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.VPCRouter, s.ReadStubResult.Err
}

// Update is API call with trace log
func (s *VPCRouterStub) Update(ctx context.Context, zone string, id types.ID, param *iaas.VPCRouterUpdateRequest) (*iaas.VPCRouter, error) {
	if s.UpdateStubResult == nil {
		log.Fatal("VPCRouterStub.UpdateStubResult is not set")
	}
	return s.UpdateStubResult.VPCRouter, s.UpdateStubResult.Err
}

// UpdateSettings is API call with trace log
func (s *VPCRouterStub) UpdateSettings(ctx context.Context, zone string, id types.ID, param *iaas.VPCRouterUpdateSettingsRequest) (*iaas.VPCRouter, error) {
	if s.UpdateSettingsStubResult == nil {
		log.Fatal("VPCRouterStub.UpdateSettingsStubResult is not set")
	}
	return s.UpdateSettingsStubResult.VPCRouter, s.UpdateSettingsStubResult.Err
}

// Delete is API call with trace log
func (s *VPCRouterStub) Delete(ctx context.Context, zone string, id types.ID) error {
	if s.DeleteStubResult == nil {
		log.Fatal("VPCRouterStub.DeleteStubResult is not set")
	}
	return s.DeleteStubResult.Err
}

// Config is API call with trace log
func (s *VPCRouterStub) Config(ctx context.Context, zone string, id types.ID) error {
	if s.ConfigStubResult == nil {
		log.Fatal("VPCRouterStub.ConfigStubResult is not set")
	}
	return s.ConfigStubResult.Err
}

// Boot is API call with trace log
func (s *VPCRouterStub) Boot(ctx context.Context, zone string, id types.ID) error {
	if s.BootStubResult == nil {
		log.Fatal("VPCRouterStub.BootStubResult is not set")
	}
	return s.BootStubResult.Err
}

// Shutdown is API call with trace log
func (s *VPCRouterStub) Shutdown(ctx context.Context, zone string, id types.ID, shutdownOption *iaas.ShutdownOption) error {
	if s.ShutdownStubResult == nil {
		log.Fatal("VPCRouterStub.ShutdownStubResult is not set")
	}
	return s.ShutdownStubResult.Err
}

// Reset is API call with trace log
func (s *VPCRouterStub) Reset(ctx context.Context, zone string, id types.ID) error {
	if s.ResetStubResult == nil {
		log.Fatal("VPCRouterStub.ResetStubResult is not set")
	}
	return s.ResetStubResult.Err
}

// ConnectToSwitch is API call with trace log
func (s *VPCRouterStub) ConnectToSwitch(ctx context.Context, zone string, id types.ID, nicIndex int, switchID types.ID) error {
	if s.ConnectToSwitchStubResult == nil {
		log.Fatal("VPCRouterStub.ConnectToSwitchStubResult is not set")
	}
	return s.ConnectToSwitchStubResult.Err
}

// DisconnectFromSwitch is API call with trace log
func (s *VPCRouterStub) DisconnectFromSwitch(ctx context.Context, zone string, id types.ID, nicIndex int) error {
	if s.DisconnectFromSwitchStubResult == nil {
		log.Fatal("VPCRouterStub.DisconnectFromSwitchStubResult is not set")
	}
	return s.DisconnectFromSwitchStubResult.Err
}

// MonitorCPU is API call with trace log
func (s *VPCRouterStub) MonitorCPU(ctx context.Context, zone string, id types.ID, condition *iaas.MonitorCondition) (*iaas.CPUTimeActivity, error) {
	if s.MonitorCPUStubResult == nil {
		log.Fatal("VPCRouterStub.MonitorCPUStubResult is not set")
	}
	return s.MonitorCPUStubResult.CPUTimeActivity, s.MonitorCPUStubResult.Err
}

// MonitorInterface is API call with trace log
func (s *VPCRouterStub) MonitorInterface(ctx context.Context, zone string, id types.ID, index int, condition *iaas.MonitorCondition) (*iaas.InterfaceActivity, error) {
	if s.MonitorInterfaceStubResult == nil {
		log.Fatal("VPCRouterStub.MonitorInterfaceStubResult is not set")
	}
	return s.MonitorInterfaceStubResult.InterfaceActivity, s.MonitorInterfaceStubResult.Err
}

// Status is API call with trace log
func (s *VPCRouterStub) Status(ctx context.Context, zone string, id types.ID) (*iaas.VPCRouterStatus, error) {
	if s.StatusStubResult == nil {
		log.Fatal("VPCRouterStub.StatusStubResult is not set")
	}
	return s.StatusStubResult.VPCRouterStatus, s.StatusStubResult.Err
}

// Logs is API call with trace log
func (s *VPCRouterStub) Logs(ctx context.Context, zone string, id types.ID) (*iaas.VPCRouterLog, error) {
	if s.LogsStubResult == nil {
		log.Fatal("VPCRouterStub.LogsStubResult is not set")
	}
	return s.LogsStubResult.VPCRouterLog, s.LogsStubResult.Err
}

// Ping is API call with trace log
func (s *VPCRouterStub) Ping(ctx context.Context, zone string, id types.ID, destination string) (*iaas.VPCRouterPingResults, error) {
	if s.PingStubResult == nil {
		log.Fatal("VPCRouterStub.PingStubResult is not set")
	}
	return s.PingStubResult.VPCRouterPingResults, s.PingStubResult.Err
}

/*************************************************
* ZoneStub
*************************************************/

// ZoneFindStubResult is expected values of the Find operation
type ZoneFindStubResult struct {
	Values *iaas.ZoneFindResult
	Err    error
}

// ZoneReadStubResult is expected values of the Read operation
type ZoneReadStubResult struct {
	Zone *iaas.Zone
	Err  error
}

// ZoneStub is for trace ZoneOp operations
type ZoneStub struct {
	FindStubResult *ZoneFindStubResult
	ReadStubResult *ZoneReadStubResult
}

// NewZoneStub creates new ZoneStub instance
func NewZoneStub(caller iaas.APICaller) iaas.ZoneAPI {
	return &ZoneStub{}
}

// Find is API call with trace log
func (s *ZoneStub) Find(ctx context.Context, conditions *iaas.FindCondition) (*iaas.ZoneFindResult, error) {
	if s.FindStubResult == nil {
		log.Fatal("ZoneStub.FindStubResult is not set")
	}
	return s.FindStubResult.Values, s.FindStubResult.Err
}

// Read is API call with trace log
func (s *ZoneStub) Read(ctx context.Context, id types.ID) (*iaas.Zone, error) {
	if s.ReadStubResult == nil {
		log.Fatal("ZoneStub.ReadStubResult is not set")
	}
	return s.ReadStubResult.Zone, s.ReadStubResult.Err
}
